# Task Templates

Common task patterns with pre-configured model assignments and budget estimates.

## Research Tasks

### Library/Technology Comparison
```yaml
Model: Sonnet
Budget: $1.50-3.00
Template: |
  Research and compare [TECHNOLOGIES] for [USE_CASE].
  
  For each option, analyze:
  - Pros/cons for our specific use case
  - Performance characteristics
  - Learning curve and documentation
  - Community support and maintenance
  - License and cost implications
  
  Provide a recommendation with reasoning.
```

### Market Research
```yaml
Model: Sonnet  
Budget: $2.00-4.00
Template: |
  Research [MARKET/TOPIC] and provide analysis.
  
  Include:
  - Current market size and trends
  - Key players and competitive landscape
  - Opportunities and challenges
  - 3-5 actionable insights
  
  Focus on [SPECIFIC_ANGLE] for our context.
```

## Development Tasks

### Code Implementation
```yaml
Model: Sonnet
Budget: $1.00-5.00
Template: |
  Implement [FEATURE] using [TECHNOLOGY_STACK].
  
  Requirements:
  - [REQUIREMENT_1]
  - [REQUIREMENT_2]
  - [REQUIREMENT_3]
  
  Include error handling, comments, and basic tests.
  Follow [CODING_STANDARDS] conventions.
```

### Bug Investigation
```yaml
Model: Sonnet (escalate to Opus if complex)
Budget: $0.50-3.00
Template: |
  Debug the following issue: [BUG_DESCRIPTION]
  
  Current behavior: [WHAT_HAPPENS]
  Expected behavior: [WHAT_SHOULD_HAPPEN]
  
  Reproduction steps: [STEPS]
  
  Analyze the root cause and provide a fix with explanation.
```

## Content Tasks

### Documentation Creation
```yaml
Model: Sonnet
Budget: $0.75-2.00
Template: |
  Create documentation for [SYSTEM/FEATURE].
  
  Target audience: [DEVELOPERS/USERS/ADMINS]
  
  Include:
  - Overview and purpose
  - Setup/installation instructions
  - Usage examples
  - Common troubleshooting
  - API reference (if applicable)
```

### Blog Post/Article
```yaml
Model: Sonnet  
Budget: $1.50-3.00
Template: |
  Write a [LENGTH] article about [TOPIC].
  
  Target audience: [AUDIENCE]
  Tone: [TECHNICAL/CASUAL/PROFESSIONAL]
  
  Structure:
  - Engaging introduction
  - 3-5 main points with examples
  - Actionable takeaways
  - Conclusion
```

## Data Tasks

### Data Extraction/Processing
```yaml
Model: Haiku
Budget: $0.25-1.00
Template: |
  Extract/process data from [SOURCE].
  
  Input: [INPUT_DESCRIPTION]
  Output format: [JSON/CSV/XML/etc]
  
  Required fields:
  - [FIELD_1]
  - [FIELD_2]
  
  Handle edge cases: [EDGE_CASE_RULES]
```

### Web Scraping
```yaml
Model: Haiku
Budget: $0.50-1.50
Template: |
  Scrape data from [WEBSITE/URL].
  
  Target elements:
  - [ELEMENT_1]: [SELECTOR]
  - [ELEMENT_2]: [SELECTOR]
  
  Output: [FORMAT]
  Rate limiting: [DELAY_MS]ms between requests
  
  Handle errors gracefully and report failed pages.
```

## Analysis Tasks

### Performance Analysis
```yaml
Model: Sonnet (Opus for architecture-level issues)
Budget: $1.50-4.00
Template: |
  Analyze performance of [SYSTEM/CODE].
  
  Current metrics:
  - [METRIC_1]: [VALUE]
  - [METRIC_2]: [VALUE]
  
  Goals:
  - [PERFORMANCE_TARGET_1]
  - [PERFORMANCE_TARGET_2]
  
  Identify bottlenecks and recommend optimizations.
```

### Security Review
```yaml
Model: Opus
Budget: $3.00-8.00
Template: |
  Security review of [SYSTEM/CODE].
  
  Focus areas:
  - Authentication and authorization
  - Input validation and sanitization  
  - Data storage and transmission
  - Access controls
  - [SPECIFIC_CONCERNS]
  
  Provide risk assessment and mitigation recommendations.
```

## Project Management Tasks

### Project Breakdown
```yaml
Model: Sonnet (Opus for complex projects)
Budget: $2.00-5.00
Template: |
  Break down [PROJECT] into manageable tasks.
  
  Project scope: [DESCRIPTION]
  Timeline: [TIMEFRAME]
  Resources: [TEAM_SIZE/CONSTRAINTS]
  
  Provide:
  - Task hierarchy with dependencies
  - Effort estimates
  - Critical path identification
  - Risk assessment
```

### Status Report
```yaml
Model: Haiku
Budget: $0.25-0.75
Template: |
  Generate status report for [PROJECT/SPRINT].
  
  Period: [DATE_RANGE]
  
  Include:
  - Completed tasks
  - In-progress work
  - Blockers and issues
  - Next steps
  - Key metrics
```

## Usage Examples

### Simple Task Assignment
```markdown
TaskMaster: Use "Data Extraction" template
- Source: customer_data.csv  
- Output: JSON with email, name, signup_date
- Budget: $0.50
```

### Custom Task with Template Base
```markdown
TaskMaster: Use "Library Comparison" template
- Technologies: React, Vue, Angular
- Use case: Dashboard application
- Custom requirement: Must support real-time updates
- Budget: $2.50
```

### Multi-Task Project
```markdown
TaskMaster: E-commerce site project
- Task 1: Use "Project Breakdown" template
- Task 2: Use "Code Implementation" template (shopping cart)
- Task 3: Use "Security Review" template 
- Total budget: $12.00
- Run in sequence: 1 → 2,3 (parallel)
```