# Model Selection Rules

## Decision Matrix

| Task Type | Complexity Indicators | Model | Cost | Reasoning |
|-----------|----------------------|-------|------|-----------|
| **Data Retrieval** | Simple web search, API calls, file reading | Haiku | $0.25/$1.25 | Straightforward, well-defined output |
| **Basic Analysis** | Summarize articles, extract key points, format data | Haiku | $0.25/$1.25 | Pattern matching, no complex reasoning |
| **Content Creation** | Write documentation, blog posts, simple code | Sonnet | $3/$15 | Requires coherence and domain knowledge |
| **Research & Investigation** | Compare options, analyze trade-offs, technical deep-dives | Sonnet | $3/$15 | Multi-step reasoning, synthesis required |
| **Code Development** | Write applications, debug complex issues, optimization | Sonnet | $3/$15 | Logic + creativity, most dev work |
| **Architecture Decisions** | System design, technology selection, security reviews | Opus | $15/$75 | High-stakes reasoning, broad expertise needed |
| **Creative Problem Solving** | Novel approaches, complex debugging, research breakthroughs | Opus | $15/$75 | Unknown unknowns, requires deep thinking |

## Complexity Assessment Questions

### Use Haiku When:
- [ ] Task has clear input → output mapping
- [ ] Similar tasks could be templated/scripted
- [ ] Failure is low-cost (easy to retry)
- [ ] Speed matters more than nuance
- [ ] **Examples**: "Find latest PDF.js version", "Extract emails from text", "Format this data as JSON"

### Use Sonnet When:
- [ ] Task requires understanding context
- [ ] Multiple steps with decision points
- [ ] Quality matters, but not mission-critical
- [ ] **Examples**: "Research React vs Vue for our use case", "Write user authentication module", "Debug this API integration"

### Use Opus When:
- [ ] High-stakes decisions (architecture, security)
- [ ] Novel problems without clear patterns
- [ ] Tasks that could fail in expensive ways
- [ ] Strategic thinking required
- [ ] **Examples**: "Design scalable microservices architecture", "Solve this performance bottleneck", "Review security implications"

## Cost-Benefit Thresholds

### When to Escalate from Haiku → Sonnet:
- Task fails after 2 attempts
- Output quality insufficient for downstream work
- Context understanding clearly needed

### When to Escalate from Sonnet → Opus:
- Task requires >30 minutes of back-and-forth
- Decisions have >$100 real-world impact
- Novel research/architecture problems
- Complex debugging with unclear solutions

### When to Force-Override Rules:
- You have domain expertise the model lacks
- Time pressure requires speed over optimization
- Budget constraints require cost minimization
- Previous experience with specific task types

## Budget Guidelines

### Per-Task Budgets:
- **Haiku tasks**: $0.10-0.50 typical
- **Sonnet tasks**: $0.50-3.00 typical  
- **Opus tasks**: $2.00-10.00+ typical

### Red Flags (Auto-escalate to human):
- Any single task >$5.00
- Project total >50% of daily budget
- Repeated task failures (3+ retries)
- Unusual token consumption patterns

## Common Anti-Patterns

❌ **Don't do:**
- Use Opus for simple web searches
- Use Haiku for creative writing
- Assign Haiku to debug complex code
- Use Opus without clear complexity justification

✅ **Do:**
- Start conservative, escalate as needed  
- Use Sonnet as the default for development
- Reserve Opus for high-stakes decisions
- Track actual costs vs. predictions to improve selection