---
name: taskmaster
description: Project manager and task delegation system. Use when you need to break down complex work into smaller tasks, assign appropriate AI models based on complexity, spawn sub-agents for parallel execution, track progress, and manage token budgets. Ideal for research projects, multi-step workflows, or when you want to delegate routine tasks to cheaper models while handling complex coordination yourself.
---

# TaskMaster: AI Project Manager & Task Delegation

Transform complex projects into managed workflows with smart model selection and sub-agent orchestration.

## Core Capabilities

**🎯 Smart Task Triage**
- Analyze complexity → assign appropriate model (Haiku/Sonnet/Opus)
- Break large projects into smaller, manageable tasks
- Prevent over-engineering (don't use Opus for simple web searches)

**🤖 Sub-Agent Orchestration**
- Spawn isolated sub-agents with specific model constraints
- Run tasks in parallel for faster completion
- Consolidate results into coherent deliverables

**💰 Budget Management**
- Track token costs per task and total project
- Set budget limits to prevent runaway spending
- Optimize model selection for cost-efficiency

**📊 Progress Tracking**
- Real-time status of all active tasks
- Failed task retry with escalation
- Final deliverable compilation

## Quick Start

### 1. Basic Task Delegation
```markdown
TaskMaster: Research PDF processing libraries
- Budget: $2.00
- Priority: medium
- Deadline: 2 hours
```

### 2. Complex Project Breakdown
```markdown
TaskMaster: Build recipe app MVP
- Components: UI mockup, backend API, data schema, deployment
- Budget: $15.00
- Timeline: 1 week
- Auto-assign models based on complexity
```

## Model Selection Rules

**Haiku ($0.25/$1.25)** - Simple, repetitive tasks:
- Web searches & summarization
- Data formatting & extraction
- Basic file operations
- Status checks & monitoring

**Sonnet ($3/$15)** - Most development work:
- Research & analysis
- Code writing & debugging
- Documentation creation
- Technical design

**Opus ($15/$75)** - Complex reasoning:
- Architecture decisions
- Creative problem-solving
- Code reviews & optimization
- Strategic planning

## Advanced Usage

### Custom Model Assignment
Override automatic selection when you know better:
```markdown
TaskMaster: Debug complex algorithm [FORCE: Opus]
```

### Parallel Execution
Run multiple tasks simultaneously:
```markdown
TaskMaster: Multi-research project
- Task A: Library comparison
- Task B: Performance benchmarks  
- Task C: Security analysis
[PARALLEL: true]
```

### Budget Controls
Set spending limits:
```markdown
TaskMaster: Market research
- Max budget: $5.00
- Escalate if >$3.00 spent
- Stop if any single task >$1.00
```

## Key Resources

- **Model Selection**: See [references/model-selection-rules.md](references/model-selection-rules.md) for detailed complexity guidelines
- **Task Templates**: See [references/task-templates.md](references/task-templates.md) for common task patterns
- **Delegation Engine**: Uses `scripts/delegate_task.py` for core orchestration logic

## Implementation Notes

**Sessions Management**: Each sub-agent gets isolated session with specific model constraints. No cross-talk unless explicitly designed.

**Error Handling**: Failed tasks automatically retry once on Sonnet, then escalate to human review.

**Result Aggregation**: TaskMaster compiles all sub-agent results into a single, coherent deliverable for the user.

**Token Tracking**: Real-time cost monitoring with alerts when approaching budget limits.