---
name: task-watchdog
description: 挂机任务的守护者。定时检查屏幕进度条，自动关闭干扰性系统或广告弹窗，遇致命错误时发送报警。
version: 0.1.0
author: Local_User
permissions:
  filesystem:
    read: []
    write: []
  shell:
    allowed: false
  network:
    allowed: true
---

# 任务守望者与弹窗杀手 (Task Watchdog)

## 🎯 核心目标
当用户在运行需要数小时才能完成的任务（如渲染视频、大数据处理、超大文件下载）并离开电脑时，你需要作为“机房保安”接管屏幕。你的职责是确保进度条一直在走，并无情地关闭任何试图阻断任务的弹窗。



## 💡 触发条件
用户在启动长耗时任务后下达指令：
* “我下班了，帮我盯着这个渲染任务，遇到弹窗帮我关一下。”
* “开启弹窗杀手模式，直到下载完成。”

## 📋 执行步骤

### 第一步：锁定目标进度
使用视觉能力识别当前屏幕上的主要任务窗口，锁定“进度条”、“百分比数字”或“预计剩余时间”作为核心监控目标。

### 第二步：定时巡检与除害（核心循环）
进入休眠状态。每隔 5 分钟醒来一次，执行以下检查：
1. **弹窗扫描：** 检查屏幕上是否存在覆盖在目标窗口上方的干扰窗口（例如：“系统更新提示”、“内存不足警告”、“杀毒软件广告”、“软件注册提示”）。
2. **执行消除：** 如果发现无关弹窗，立即识别其右上角的“X”按钮，或“稍后提醒”、“关闭”、“忽略”等按钮，模拟鼠标点击将其关闭。
3. **进度确认：** 检查目标进度条是否在正常推进。如果连续 3 次检查（15分钟）进度百分比完全没有变化，判定为任务卡死，进入第三步。

### 第三步：致命异常响应
如果遇到无法关闭的弹窗（如系统蓝屏/内核崩溃前兆），或者软件彻底闪退、进度条死锁：
1. 立即对当前屏幕进行完整截图。
2. 调用系统或用户预设的通知机制（如果用户配置了 Webhook 报警），发送通知：“任务异常中断，请人工介入检查”。

## ⚠️ 安全与操作红线
1. **禁止终止进程：** 即使任务看似卡死，也绝对不允许执行强制结束进程 (`kill`) 或点击原任务软件的“取消 (Cancel)”按钮。
2. **谨慎点击：** 在关闭弹窗时，必须精准识别“关闭”或“稍后”，严禁误点“立即重启系统”或“更新并安装”。