---
name: task-system
displayName: Task System
description: Complete task tracking system with SQLite persistence, automatic creation, notifications, heartbeat monitoring, and stuck task recovery. Replaces task-queue-heartbeat, auto-track, and notification skills. Use for all task management needs.
version: 1.0.0
author: Santosh
license: MIT
install: ./install.sh
---

# Task System

One skill for complete task lifecycle management.

## Installation

```bash
./install.sh
```

Or manually add to PATH:
```bash
export PATH="$HOME/.openclaw/agents/main/workspace/skills/task-system/scripts:$PATH"
```

## Quick Commands

```bash
# Create task
task-system.sh create "Your request here"

# Update heartbeat
task-system.sh heartbeat $TASK_ID

# Mark complete
task-system.sh complete $TASK_ID "Optional notes"

# Check stuck
task-system.sh stuck

# Daily status
task-system.sh status
```

## Database Schema

```sql
CREATE TABLE IF NOT EXISTS tasks (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  request_text TEXT NOT NULL,
  status TEXT DEFAULT 'pending',
  priority INTEGER DEFAULT 5,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  started_at DATETIME,
  completed_at DATETIME,
  last_updated DATETIME DEFAULT CURRENT_TIMESTAMP,
  notes TEXT
);

-- Key indexes
CREATE INDEX IF NOT EXISTS idx_tasks_status_updated ON tasks(status, last_updated);
CREATE INDEX IF NOT EXISTS idx_tasks_priority ON tasks(priority ASC);
```

## Scripts

See `scripts/` directory:
- `task-system.sh` — Main CLI (create, heartbeat, complete, stuck, status)
- `create-task.sh` — Create new task
- `heartbeat.sh` — Update last_updated
- `complete-task.sh` — Mark complete
- `stuck-check.sh` — Find stuck tasks
