---
name: task-review-workflow
description: Standard PR review and merge workflow for task-driven development. Use when reviewing a programmer agent PR linked to a task, deciding merge vs change request, handling post-merge actions (Trello + branch cleanup), and sending a clear outcome handoff.
---

# Task Review Workflow

Follow this workflow in order for every task-linked PR.

## 1) Gather Context

- Read the PR description.
- Open and read the linked task before reviewing code.
- Confirm expected behavior and acceptance criteria from the task context.

## 2) Review Against Standard

- Use `REVIEW_CHECKLIST.md` as the mandatory review baseline.
- Check correctness, edge cases, regressions, security, performance, and test adequacy.

## 3) Review the Diff Thoroughly

- Review file-by-file.
- Flag logic flaws, unsafe assumptions, missing validation, unclear naming, dead code, and side-effect risks.

## 4) Validate Locally When Possible

- Check out the PR branch.
- Run relevant test/lint/build commands.
- Exercise changed behavior directly where practical.

## 5) Write Clear Review Feedback

- Leave actionable, specific CR comments.
- Separate must-fix issues from optional suggestions.

## 6) Decide Outcome

- If issues remain: request changes with a concrete fix list.
- If quality is acceptable: approve/merge with a short merge note.

## 7) Execute Post-Merge Steps

- Move the related Trello card to **Done**.
- Delete the **task branch** after merge.
- Never delete the `main` branch.

## 8) Complete Handoff

- Send the final outcome back to the programmer agent:
  - `merged`, or
  - `CR sent`, or
  - `waiting for fixes`.
- Ensure the next task starts only after this outcome message.
