#!/bin/bash

PID_FILE="$HOME/.openclaw/task-monitor-server.pid"

if [ ! -f "$PID_FILE" ]; then
  echo "Server not running (no PID file)"
  exit 0
fi

PID=$(cat "$PID_FILE")

if ps -p "$PID" > /dev/null 2>&1; then
  echo "Stopping server (PID $PID)..."
  kill "$PID"
  rm "$PID_FILE"
  echo "Server stopped"
else
  echo "Server not running (stale PID file)"
  rm "$PID_FILE"
fi
