#!/bin/bash

# Task Monitor Web Server Startup Script

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SERVER_SCRIPT="$SCRIPT_DIR/../server.js"
LOG_FILE="$HOME/.openclaw/task-monitor-server.log"
PID_FILE="$HOME/.openclaw/task-monitor-server.pid"

# Check if already running
if [ -f "$PID_FILE" ]; then
  PID=$(cat "$PID_FILE")
  if ps -p "$PID" > /dev/null 2>&1; then
    echo "Server already running with PID $PID"
    exit 0
  else
    rm "$PID_FILE"
  fi
fi

# Start server in background
echo "Starting Task Monitor Web Server..."
nohup node "$SERVER_SCRIPT" >> "$LOG_FILE" 2>&1 &
echo $! > "$PID_FILE"

echo "Server started with PID $(cat "$PID_FILE")"
echo "Logs: $LOG_FILE"
echo "Access: http://localhost:3030 (or http://<your-ip>:3030 on LAN)"
