---
name: task-monitor
description: Real-time web dashboard for OpenClaw sessions and background tasks. Mobile-responsive with auto-refresh.
version: 0.1.0
---

# Task Monitor v0.1

Real-time monitoring dashboard for OpenClaw with web interface.

## Features

- 🌐 **Web Dashboard** - Beautiful, responsive UI accessible from any device
- 📱 **Mobile-First** - Optimized for phones and tablets
- 🔄 **Auto-Refresh** - Updates every 60 seconds
- 🎨 **Modern Design** - Gradient UI with dark theme
- 📊 **Live Data** - Main session, Discord, sub-agents, cron jobs
- 🚀 **Fast API** - JSON endpoint with intelligent caching (30s TTL)
- ⚡ **Performance** - <100ms response time (cached), ~15s cold cache

## Installation

```bash
cd skills/task-monitor
npm install
```

## Usage

### Start Web Server

```bash
./scripts/start-server.sh
```

Server will run on port **3030** (accessible on LAN).

**Access URLs:**
- Local: `http://localhost:3030`
- LAN: `http://<your-ip>:3030`

### Stop Server

```bash
./scripts/stop-server.sh
```

### API Endpoint

```bash
curl http://localhost:3030/api/status
```

Returns JSON with:
- Main session stats
- Discord session stats
- Active sub-agents (with descriptions)
- Recent cron job history

### Generate Markdown (v0.1)

Legacy markdown generator still available:

```bash
./scripts/generate-dashboard.js
```

Updates `DASHBOARD.md` in workspace root.

## Automation

CRON job runs every 5 minutes to update markdown dashboard:
`*/5 * * * *` -> Executes `generate-dashboard.js`

## Architecture

- **Backend:** Node.js + Express
- **Frontend:** Pure HTML/CSS/JS (no frameworks)
- **Data Source:** `openclaw sessions list --json` + `openclaw cron list --json`
- **Caching:** In-memory cache with 30-second TTL
  - Pre-warmed on server startup
  - Async background refresh when expired
  - Stale-while-revalidate pattern for optimal UX
- **Refresh:** Client-side polling (60s interval)

## Performance

**Without cache:**
- API response time: ~15 seconds (blocking)
- Problem: Each request blocks Node.js event loop

**With cache:**
- Cache hit: <100ms (~365x faster)
- Cache miss: ~15s (first request only)
- Stale cache: <100ms while refreshing in background
- Cache TTL: 30 seconds

The caching system ensures:
- Lightning-fast responses for most requests
- No blocking of concurrent requests
- Graceful degradation when cache expires
