# 🤖 Task Monitor v0.1

Real-time web dashboard for monitoring OpenClaw sessions and background tasks with a beautiful, mobile-responsive interface.

## ✨ Features

- **🌐 Web Dashboard** - Beautiful, responsive UI accessible from any device (desktop, tablet, mobile)
- **📱 Mobile-First Design** - Optimized touch-friendly interface for phones and tablets
- **🔄 Auto-Refresh** - Live updates every 60 seconds without manual intervention
- **🎨 Modern UI** - Gradient design with dark theme and glassmorphism effects
- **📊 Comprehensive Monitoring** - Track main session, Discord, sub-agents, and cron jobs
- **🚀 Fast API** - JSON endpoint with intelligent caching (30s TTL)
- **⚡ High Performance** - <100ms response time (cached), ~15s cold cache
- **💾 Smart Caching** - Stale-while-revalidate pattern ensures fast responses even when cache expires

## 📋 Prerequisites

- Node.js 14.0.0 or higher
- OpenClaw CLI installed and configured
- Access to `openclaw sessions list` and `openclaw cron list` commands

## 🚀 Installation

1. Navigate to the skill directory:
```bash
cd skills/task-monitor
```

2. Install dependencies:
```bash
npm install
```

## 📖 Usage

### Start the Web Server

```bash
./scripts/start-server.sh
```

The server will start on port **3030** and be accessible on your local network.

**Access URLs:**
- **Local:** `http://localhost:3030`
- **LAN:** `http://<your-ip>:3030`

To find your IP address:
- **Linux/Mac:** `hostname -I` or `ifconfig`
- **Windows:** `ipconfig`

### Stop the Server

```bash
./scripts/stop-server.sh
```

### View Server Logs

```bash
tail -f ~/.openclaw/task-monitor-server.log
```

### API Endpoint

The dashboard exposes a JSON API endpoint:

```bash
curl http://localhost:3030/api/status
```

**Response Example:**
```json
{
  "timestamp": "2024-02-01T23:15:00.000Z",
  "totalSessions": 5,
  "main": {
    "model": "anthropic/claude-sonnet-4",
    "totalTokens": 125000,
    "contextTokens": 50000,
    "ageMs": 3600000
  },
  "discord": {
    "model": "anthropic/claude-sonnet-4",
    "totalTokens": 85000,
    "contextTokens": 35000,
    "ageMs": 7200000
  },
  "subagents": [
    {
      "sessionId": "abc123...",
      "description": "Processing user request...",
      "model": "anthropic/claude-sonnet-4",
      "totalTokens": 15000,
      "ageMs": 300000
    }
  ],
  "recentCrons": [
    {
      "name": "heartbeat-check",
      "updatedAt": 1706827500000,
      "model": "anthropic/claude-sonnet-4"
    }
  ],
  "cached": true,
  "cacheAge": 15
}
```

### Legacy Markdown Generator (v0.1)

The original markdown generator is still available:

```bash
./scripts/generate-dashboard.js
```

This creates/updates `DASHBOARD.md` in your workspace root.

## 🏗️ Architecture

### Technology Stack
- **Backend:** Node.js + Express
- **Frontend:** Pure HTML/CSS/JavaScript (no frameworks required)
- **Data Source:** OpenClaw CLI (`sessions list`, `cron list`)
- **Caching:** In-memory cache with 30-second TTL

### Caching Strategy
- **Pre-warmed on startup** - Cache loaded immediately when server starts
- **Async background refresh** - Non-blocking cache updates
- **Stale-while-revalidate** - Returns stale data while fetching fresh data
- **Separate cron cache** - Cron jobs cached for 5 minutes (they rarely change)

### Performance Metrics

| Scenario | Response Time | Notes |
|----------|---------------|-------|
| Cache Hit | <100ms | ~365x faster than cold fetch |
| Cache Miss | ~15s | First request or expired cache |
| Stale Cache | <100ms | Returns stale data while refreshing |

## 📱 Mobile Experience

The dashboard is fully optimized for mobile devices:
- Touch-friendly card-based layout
- Responsive grid that adapts to screen size
- Readable fonts on small screens
- No horizontal scrolling
- Optimized for portrait and landscape modes

## 🔧 Configuration

### Change Port

Edit `server.js` and modify:
```javascript
const PORT = 3030; // Change to your desired port
```

### Adjust Cache TTL

Edit `server.js`:
```javascript
const CACHE_TTL_MS = 30000; // 30 seconds (adjust as needed)
const CRON_CACHE_TTL_MS = 300000; // 5 minutes (adjust as needed)
```

### Customize UI

The HTML dashboard is embedded in `server.js`. You can modify:
- Color scheme (CSS gradients)
- Refresh interval (JavaScript: `setInterval`)
- Card layout and content
- Typography and spacing

## 🔄 Automation

### Optional: CRON Integration

You can set up a cron job to keep the markdown dashboard updated:

```bash
openclaw cron add "*/5 * * * *" "cd ~/clawd/skills/task-monitor && ./scripts/generate-dashboard.js" --name "dashboard-update"
```

This updates `DASHBOARD.md` every 5 minutes.

## 🐛 Troubleshooting

### Server won't start
- Check if port 3030 is already in use: `lsof -i :3030`
- Verify Node.js is installed: `node --version`
- Check logs: `cat ~/.openclaw/task-monitor-server.log`

### Empty dashboard
- Ensure OpenClaw CLI is working: `openclaw sessions list --json`
- Verify you have active sessions
- Check browser console for JavaScript errors

### Performance issues
- Increase cache TTL if data freshness isn't critical
- Check if `openclaw` commands are slow (try running manually)
- Monitor server logs for errors

## 📝 License

MIT License - Free to use, modify, and distribute.

## 🤝 Contributing

Contributions welcome! This skill is part of the OpenClaw ecosystem.

## 🔗 Related Skills

- **session-manager** - Manage OpenClaw sessions
- **cron-helper** - Advanced cron job management
- **log-viewer** - View and search OpenClaw logs

## 📚 Learn More

- [OpenClaw Documentation](https://openclaw.org/docs)
- [ClawHub](https://clawhub.org)
- [OpenClaw GitHub](https://github.com/openclaw)
