# Changelog

All notable changes to Task Monitor will be documented in this file.

## [0.1.0] - 2026-02-02

### Initial Release

#### Features
- 🌐 **Web Dashboard** - Beautiful, responsive UI accessible from any device
- 📱 **Mobile-First Design** - Optimized for phones and tablets
- 🔄 **Auto-Refresh** - Updates every 60 seconds automatically
- 🎨 **Modern UI** - Gradient design with dark theme
- 📊 **Real-Time Data** - Monitor main session, Discord, sub-agents, and cron jobs
- 🚀 **Fast API** - JSON endpoint with intelligent caching
- ⚡ **High Performance** - <100ms response time with caching, ~15s cold cache

#### Components
- **Web Server** (`server.js`) - Express-based HTTP server on port 3030
- **Dashboard Generator** (`scripts/generate-dashboard.js`) - Legacy markdown generator
- **Management Scripts**:
  - `start-server.sh` - Start the web server
  - `stop-server.sh` - Stop the web server gracefully

#### Technical Details
- **Cache System**: Two-tier caching (30s for sessions, 5min for cron jobs)
- **Async Architecture**: Non-blocking event loop for fast response times
- **Session Detection**: Automatically finds and displays all active sessions
- **Cron Integration**: Lists all scheduled jobs with next execution times
- **Mobile Optimization**: Responsive design adapts to any screen size

#### API Endpoints
- `GET /` - HTML dashboard interface
- `GET /api/status` - JSON API with session and cron data

#### Dependencies
- `express` ^4.22.1 - Web server framework

#### Platform Support
- Node.js >= 14.0.0
- Linux, macOS, Windows (WSL)

#### Usage
```bash
# Installation
cd skills/task-monitor
npm install

# Start server
./scripts/start-server.sh

# Access dashboard
http://localhost:3030          # Local
http://<your-ip>:3030         # LAN

# Stop server
./scripts/stop-server.sh
```

#### Documentation
- `README.md` - Comprehensive usage guide
- `SKILL.md` - OpenClaw skill metadata and overview
- `CHANGELOG.md` - This file

---

**License:** MIT  
**Author:** OpenClaw Community  
**Repository:** https://github.com/openclaw/clawhub
