---
name: task-experience-logger
description: 任务经验记录与总结工具。用于在任务执行过程中记录遇到的问题、解决方案和经验教训，支持自动保存到长期记忆。适用于任何需要持续学习改进的任务场景，包括技术问题解决、工作流优化、错误排查等。当用户需要记录任务经验、总结执行过程、或建立知识库时使用此技能。
---

# Task Experience Logger - 任务经验记录器

## 功能概述

本技能提供一套完整的工作流程，用于系统化地记录任务执行过程中的关键信息：
- 遇到的问题及错误信息
- 解决方案和修复步骤
- 经验教训和最佳实践
- 工具配置验证记录

## 工作目录结构

```
task-experiences/
├── YYYY-MM-DD/              # 按日期归档
│   ├── task-name-report.md  # 任务执行报告
│   └── quick-notes.md       # 快速笔记
├── lessons-learned.md       # 经验教训汇总
├── verified-tools.md        # 已验证工具清单
└── common-issues.md         # 常见问题库
```

## 记录类别

### 1. 问题记录 (Problem)

记录任务中遇到的问题：
- **问题描述**: 清晰描述发生了什么
- **错误信息**: 完整的错误日志或截图
- **影响范围**: 影响的功能或模块
- **紧急程度**: P0(致命) / P1(严重) / P2(一般)
- **发生时间**: 精确到分钟

### 2. 解决方案 (Solution)

记录问题的解决过程：
- **根因分析**: 为什么会出现这个问题
- **解决方法**: 具体的修复步骤
- **验证步骤**: 如何确认问题已解决
- **耗时**: 解决花费的时间
- **替代方案**: 其他可行的方法

### 3. 经验教训 (Lesson)

提炼可复用的知识：
- **原因**: 为什么会发生
- **预防**: 如何避免再次发生
- **最佳实践**: 推荐的做事方式
- **相关文档**: 参考资料链接

### 4. 工具验证 (Tool Validation)

记录工具配置状态：
- **工具名称**: 工具标识
- **版本**: 使用的版本
- **配置状态**: ✅ 可用 / ❌ 不可用
- **验证时间**: 最后验证时间
- **备注**: 特殊配置或限制

## 快速记录模板

### 新问题

```markdown
## [日期时间] 问题: [简要描述]

**类型**: 问题/错误/异常
**严重程度**: P0/P1/P2/P3
**状态**: 待解决/解决中/已解决

### 详情
[详细描述]

### 错误日志
```
[粘贴错误信息]
```

### 解决方案
[解决方法]

### 学习要点
- 
- 
```

### 新验证的工具

```markdown
## [工具名称]

- **状态**: ✅ 已验证可用
- **版本**: 
- **验证时间**: 
- **配置要点**: 
- **限制/注意事项**: 
```

## 长期记忆更新

任务结束后，按以下优先级更新 MEMORY.md：

1. **关键经验**: 影响未来决策的洞察
2. **工具配置**: 已验证可用的工具和配置
3. **问题模式**: 重复出现的问题类型
4. **最佳实践**: 形成规范的工作方式

## 使用建议

- **实时记录**: 遇到问题时立即记录，不要依赖记忆
- **保持简洁**: 记录关键信息，避免冗余
- **便于搜索**: 使用关键词标签方便日后查找
- **定期回顾**: 每周回顾一次，更新长期记忆
