---
name: task-development-workflow
description: TDD-first development workflow with structured planning, task tracking, and PR-based code review. Use when building software projects that require clarification phases, planning approval gates, Trello task management, test-driven development, Git branching policies, and PR feedback loops with reviewers.
---

# Task Workflow

A structured development workflow enforcing quality through planning, TDD, and code review.

## Workflow Overview

```
Clarify → Plan → Approve → Implement (TDD) → PR → Review → Merge → Next Task
```

## Phase 1: Clarification

Before any implementation, ask questions to clarify:
- Business requirements and goals
- UI/UX flow expectations
- Architecture decisions
- Technical constraints
- Ambiguous requirements

**Do not proceed until requirements are clear.**

## Phase 2: Planning & Approval

1. Present a detailed plan with task breakdown
2. Keep tasks small and focused
3. **Wait for explicit approval** before starting
4. No implementation without approval

## Phase 3: Task Tracking Setup

Set up Trello board (or similar) with columns:
- 📝 Backlog
- 📋 To Do
- 🔨 In Progress
- 🔍 Review
- ✅ Done

All tasks must be tracked on the board.

## Phase 4: Implementation (Per Task)

For each task:

1. **Move card** to "In Progress"
2. **Write tests first** (TDD):
   - Define expected behavior in tests
   - Run tests (should fail)
   - Implement the feature
   - Run tests (should pass)
3. **Commit** after task completion
4. Tests may be skipped **only with explicit approval**

## Phase 5: Branching & PR Policy

**Rules:**
- Never push directly to `main`
- Never change the default branch — `main` must always remain default
- Create feature branches for each task

**After task completion:**
1. Open PR from task branch → `main`
2. Include Trello task link in PR description
3. Move card to "Review"
4. Notify Reviewer with both Trello link and PR link

## Phase 6: PR Feedback Loop

When CR comments arrive:
1. Move task back to "In Progress"
2. Address all review comments
3. Push fixes
4. Notify Reviewer to re-review (include both links)

Repeat until approved.

## Phase 7: Merge Gate

- **Only pick the next task after current PR is merged**
- Move completed card to "Done"
- Then proceed to next task from "To Do"

## Flow Diagram

```
Backlog → To Do → In Progress → Review → Done
                      ↑            │
                      └─── CR ─────┘
```

## New Project Bootstrap

For new projects:
1. Create repository with initial README
2. Push to remote
3. Then begin implementation tasks

## Key Principles

- **Quality over speed** — TDD catches bugs early
- **Small tasks** — easier to review and merge
- **Clear communication** — always notify reviewers
- **No shortcuts** — follow the process every time
