# 任务分解器 & 技能生成器

一个强大的技能，帮助将复杂的用户请求分解为可执行的子任务，识别所需能力，从开放技能生态系统中搜索现有技能，并在没有现有解决方案时自动创建新技能。

## 功能特性

- **任务分解**：将复杂请求拆分为原子化、可执行的子任务
- **能力识别**：将任务映射到通用能力分类体系
- **技能搜索**：从 [skills.sh](https://skills.sh/) 生态系统中搜索现有解决方案
- **差距分析**：识别没有匹配技能的任务
- **技能创建**：在没有现有解决方案时生成新技能
- **执行规划**：创建包含依赖关系的结构化执行计划

## 安装

对话框：安装技能 https://github.com/clawdbot-skills/task-decomposer

```bash
npx skills add https://github.com/clawdbot-skills/task-decomposer -g -y
```

## 核心工作流程

```
用户请求 → 任务分解 → 能力识别 → 技能搜索 → 差距分析 → 技能创建 → 执行计划
```

## 通用能力类型

| 能力类型 | 描述 |
|----------|------|
| `browser_automation` | 网页导航、交互、数据抓取 |
| `web_search` | 互联网搜索和信息检索 |
| `api_integration` | 第三方 API 通信 |
| `data_extraction` | 解析和提取结构化数据 |
| `data_transformation` | 数据转换、清洗、变换 |
| `content_generation` | 创建文本、图像或其他内容 |
| `file_operations` | 读取、写入、操作文件 |
| `message_delivery` | 发送通知或消息 |
| `scheduling` | 基于时间的任务执行 |
| `authentication` | 身份和访问管理 |
| `database_operations` | 数据库增删改查操作 |
| `code_execution` | 运行脚本或程序 |
| `version_control` | Git 和代码仓库操作 |
| `testing` | 自动化测试和质量保证 |
| `deployment` | 应用部署和 CI/CD |
| `monitoring` | 系统和应用监控 |

## 使用示例

### 示例 1：工作流自动化

**用户请求：**
```
创建一个工作流，监控 GitHub issues，总结新 issues，并发送通知到 Discord
```

**分解结果：**
- 监控 GitHub 仓库的新 issues（api_integration）
- 提取 issue 内容和元数据（内置能力）
- 生成 issue 摘要（内置 LLM）
- 发送通知到 Discord（message_delivery）
- 配置 webhook 或轮询触发器（内置能力）

### 示例 2：数据管道

**用户请求：**
```
搜索 AI 研究论文，下载 PDF，提取关键发现，并保存到 Notion
```

**分解结果：**
- 搜索 AI 研究论文（web_search）
- 下载 PDF 文件（browser_automation）
- 从 PDF 中提取文本（data_extraction）
- 生成关键发现摘要（内置 LLM）
- 保存到 Notion 数据库（api_integration）

## 任务分解原则

1. **原子性**：每个子任务应该是最小的可执行单元
2. **独立性**：最小化任务之间的依赖关系
3. **可验证性**：每个任务应该有明确的验证方法
4. **可复用性**：优先创建通用的技能
5. **单一职责**：每个任务只做一件事

## 最佳实践

- 在创建新技能之前，始终先在 [skills.sh](https://skills.sh/) 搜索
- 使用具体的搜索词，将能力关键词与领域术语结合
- 利用内置能力处理 AI 代理本身能做的事情
- 设计新技能时尽量使其通用化
- 为新技能编写详细的文档和使用说明
- 在执行任务前验证技能安装
- 在执行计划中包含降级策略

## 相关命令

```bash
# 搜索技能生态系统
npx skills find <关键词>

# 安装发现的技能
npx skills add <owner/repo@skill> -g -y

# 初始化新技能
npx skills init <技能名称>
```

## 许可证

MIT
