# Task Decomposer & Skill Generator

A powerful skill that helps decompose complex user requests into executable subtasks, identify required capabilities, search for existing skills from the open skills ecosystem, and automatically create new skills when no existing solution is available.

## Features

- **Task Decomposition**: Breaks down complex requests into atomic, executable subtasks
- **Capability Identification**: Maps tasks to a universal capability taxonomy
- **Skill Search**: Searches the [skills.sh](https://skills.sh/) ecosystem for existing solutions
- **Gap Analysis**: Identifies tasks without matching skills
- **Skill Creation**: Generates new skills when no existing solution is found
- **Execution Planning**: Creates structured execution plans with dependencies

## Installation

```bash
npx skills add https://github.com/clawdbot-skills/task-decomposer -g -y
```

## Core Workflow

```
User Request → Task Decomposition → Capability Identification → Skill Search → Gap Analysis → Skill Creation → Execution Plan
```

## Universal Capability Types

| Capability | Description |
|------------|-------------|
| `browser_automation` | Web navigation, interaction, scraping |
| `web_search` | Internet search and information retrieval |
| `api_integration` | Third-party API communication |
| `data_extraction` | Parse and extract structured data |
| `data_transformation` | Convert, clean, transform data |
| `content_generation` | Create text, images, or other content |
| `file_operations` | Read, write, manipulate files |
| `message_delivery` | Send notifications or messages |
| `scheduling` | Time-based task execution |
| `authentication` | Identity and access management |
| `database_operations` | Database CRUD operations |
| `code_execution` | Run scripts or programs |
| `version_control` | Git and code repository operations |
| `testing` | Automated testing and QA |
| `deployment` | Application deployment and CI/CD |
| `monitoring` | System and application monitoring |

## Usage Examples

### Example 1: Workflow Automation

**User Request:**
```
Create a workflow that monitors GitHub issues, summarizes new issues, and posts notifications to Discord
```

**Decomposition Result:**
- Monitor GitHub repository for new issues (api_integration)
- Extract issue content and metadata (built-in)
- Generate issue summary (built-in LLM)
- Send notification to Discord (message_delivery)
- Configure webhook or polling trigger (built-in)

### Example 2: Data Pipeline

**User Request:**
```
Search for AI research papers, download PDFs, extract key findings, and save to Notion
```

**Decomposition Result:**
- Search for AI research papers (web_search)
- Download PDF files (browser_automation)
- Extract text from PDFs (data_extraction)
- Generate summaries of key findings (built-in LLM)
- Save to Notion database (api_integration)

## Task Decomposition Principles

1. **Atomicity**: Each subtask should be the minimal executable unit
2. **Independence**: Minimize dependencies between tasks
3. **Verifiability**: Each task should have a clear verification method
4. **Reusability**: Prefer creating general-purpose skills
5. **Single Responsibility**: Each task should do one thing well

## Best Practices

- Always search [skills.sh](https://skills.sh/) before creating new skills
- Use specific search terms combining capability keywords with domain terms
- Leverage built-in capabilities for things the agent can do natively
- Design new skills to be general-purpose when possible
- Document new skills thoroughly with clear usage instructions
- Verify skill installation before executing tasks
- Include fallback strategies in execution plans

## Related Commands

```bash
# Search the skills ecosystem
npx skills find <query>

# Install a discovered skill
npx skills add <owner/repo@skill> -g -y

# Initialize a new skill
npx skills init <skill-name>
```

## License

MIT
