---
name: task-decomp
description: "Decompose complex multi-step requests into tracked subtasks with dependencies, status tracking, and progress reporting. Use when: (1) A request involves 3+ distinct steps, (2) Steps have dependencies (B needs A's output), (3) Work spans multiple tool calls or sub-agents, (4) User asks to 'plan this out' or 'break this down', (5) A task is complex enough that losing track mid-execution would waste work. NOT for: simple one-shot requests, single tool calls, or purely conversational exchanges."
---

# Task Decomposition

Break complex work into tracked, dependency-aware subtasks. Prevents losing the thread on multi-step operations.

## When to Decompose

Decompose when a request has **3+ steps with dependencies**. Don't over-engineer simple work.

**Signals:**
- "Build me X" (multi-component)
- "Set up Y, then configure Z, then test it"
- "Research A, compare with B, write up C"
- Multi-agent orchestration
- Any work where failure mid-stream means restarting from scratch

## Task Plan Format

Create a plan file at `memory/active-plan.md` (one active plan at a time):

```markdown
# Plan: [Brief title]
Started: [timestamp]
Status: in-progress | completed | blocked | abandoned

## Tasks

- [x] 1. [Task name] — [outcome/result summary]
- [ ] 2. [Task name] (depends: 1) — [status note]
- [ ] 3. [Task name] (depends: 1,2)
- [ ] 4. [Task name] (depends: 3) ⚠️ blocked: [reason]
```

## Rules

### Planning Phase
1. Read the full request before decomposing
2. Identify natural boundaries (different tools, different contexts, different outputs)
3. Mark dependencies explicitly — `(depends: 1,3)` means tasks 1 and 3 must complete first
4. Order by dependency chain, not importance
5. Keep task names action-oriented: "Install X", "Configure Y", "Verify Z"

### Execution Phase
1. Work tasks in dependency order
2. Check off completed tasks with outcome notes: `- [x] 1. Install redis — installed v7.2, confirmed running`
3. If blocked, mark with ⚠️ and reason, skip to next unblocked task
4. Update `active-plan.md` after each task completes (not after each tool call)
5. On completion, move plan to `memory/plans/[date]-[slug].md`

### Failure Handling
- If a task fails, note the failure and assess: can downstream tasks still run?
- If the whole plan is unrecoverable, mark `abandoned` with explanation
- Partial completions are valuable — always record what DID work

### Sub-agent Delegation
When spawning sub-agents for tasks:
- One sub-agent per independent task branch (not per task)
- Record sub-agent session ID next to the task: `spawned: session-abc`
- Don't poll in loops — check on completion events or when asked

## Progress Reporting

When user asks "where are we?" or "status?":
```
📋 Plan: [title]
Done: 3/7 tasks
Current: Task 4 — [what's happening]
Blocked: Task 6 — [why]
ETA: [rough estimate if possible]
```

## Archive

Completed/abandoned plans go to `memory/plans/` with the date prefix:
```
memory/
├── active-plan.md          # Current plan (only one)
└── plans/
    ├── 2026-03-01-setup-acw.md
    └── 2026-03-02-osint-recon.md
```

Archived plans become reference for similar future work — before decomposing a new task, check if a similar plan exists.

## Anti-patterns

- **Over-decomposition:** Don't create 15 tasks for what's really 4 steps
- **Phantom dependencies:** Don't mark dependencies that aren't real — tasks that CAN run in parallel SHOULD
- **Plan worship:** If the plan is wrong, update it — don't follow a bad plan to completion
- **Decomposing the obvious:** `clawhub install X` doesn't need a plan
