#!/bin/bash
# Check and restart SendGrid webhook services if down
# Only outputs when a restart happens

# Source .env for Discord webhook URL
if [ -f /root/.env ]; then
    export $(grep -v '^#' /root/.env | xargs)
fi

WEBHOOK_PORT=8089
DISCORD_WEBHOOK="${TARDIS_DISCORD_WEBHOOK:-}"
RESTART_NEEDED=false
RESTARTED=""

# Check webhook server
if ! pgrep -f "sendgrid_webhook.py.*--port $WEBHOOK_PORT" > /dev/null; then
    cd /root/.openclaw/workspace/skills/hour-meter
    nohup python3 scripts/sendgrid_webhook.py --port $WEBHOOK_PORT --discord-webhook "$DISCORD_WEBHOOK" > /tmp/webhook-server.log 2>&1 &
    RESTARTED="webhook-server"
    RESTART_NEEDED=true
fi

# Check cloudflared
if ! pgrep -f "cloudflared tunnel" > /dev/null; then
    nohup cloudflared tunnel --url http://localhost:$WEBHOOK_PORT > /tmp/cloudflared.log 2>&1 &
    sleep 5
    TUNNEL_URL=$(grep -o 'https://[^[:space:]]*trycloudflare.com' /tmp/cloudflared.log | head -1)
    if [ -n "$RESTARTED" ]; then
        RESTARTED="$RESTARTED + cloudflared"
    else
        RESTARTED="cloudflared"
    fi
    RESTART_NEEDED=true
fi

# Only output if we restarted something
if [ "$RESTART_NEEDED" = true ]; then
    TUNNEL_URL=$(grep -o 'https://[^[:space:]]*trycloudflare.com' /tmp/cloudflared.log 2>/dev/null | head -1)
    echo "RESTARTED: $RESTARTED"
    if [ -n "$TUNNEL_URL" ]; then
        echo "TUNNEL_URL: $TUNNEL_URL/webhooks/sendgrid"
    fi
fi
