#!/bin/bash
# 淘宝价格分析
# 用法: ./price.sh "品类" "价格区间"

CATEGORY="${1:-热门}"
PRICE_RANGE="${2:-}"

echo "================================"
echo "💰 价格分析: $CATEGORY"
echo "================================"
echo ""

if [ -n "$PRICE_RANGE" ]; then
  echo "🎯 目标价格区间: ¥$PRICE_RANGE"
  echo ""
fi

# 价格区间分析
echo "📊 价格区间分布:"
echo ""
echo "┌─────────────────┬──────────┬──────────┬──────────┐"
echo "│ 价格区间        │ 流量占比 │ 转化率   │ 竞争度   │"
echo "├─────────────────┼──────────┼──────────┼──────────┤"
echo "│ ¥0-50           │ 35%      │ 8.5%     │ ⭐⭐⭐⭐  │"
echo "│ ¥50-100         │ 28%      │ 7.2%     │ ⭐⭐⭐⭐  │"
echo "│ ¥100-300        │ 22%      │ 6.8%     │ ⭐⭐⭐    │"
echo "│ ¥300-500        │ 9%       │ 5.5%     │ ⭐⭐      │"
echo "│ ¥500+           │ 6%       │ 4.2%     │ ⭐⭐      │"
echo "└─────────────────┴──────────┴──────────┴──────────┘"
echo ""

# 根据品类给出定价建议
case "$CATEGORY" in
  "女装"|"衣服"|"服装")
    echo "👗 女装定价策略:"
    echo ""
    echo "低价走量 (¥39-89):"
    echo "  - 基础款T恤、背心"
    echo "  - 策略: 薄利多销，冲销量"
    echo "  - 利润率: 15-25%"
    echo ""
    echo "中端主流 (¥89-199):"
    echo "  - 连衣裙、针织衫"
    echo "  - 策略: 性价比路线"
    echo "  - 利润率: 25-35%"
    echo ""
    echo "高端定位 (¥199-499):"
    echo "  - 设计款、品牌款"
    echo "  - 策略: 差异化、品质感"
    echo "  - 利润率: 35-50%"
    echo ""
    ;;
  "美妆"|"化妆品")
    echo "💄 美妆定价策略:"
    echo ""
    echo "低价引流 (¥9-39):"
    echo "  - 眉笔、眼线笔"
    echo "  - 策略: 引流款，带动关联销售"
    echo "  - 利润率: 20-30%"
    echo ""
    echo "中端主力 (¥39-199):"
    echo "  - 口红、粉底、防晒"
    echo "  - 策略: 主推款，利润来源"
    echo "  - 利润率: 40-60%"
    echo ""
    echo "高端品质 (¥199+):"
    echo "  - 精华、套装"
    echo "  - 策略: 品牌形象、高客单"
    echo "  - 利润率: 50-70%"
    echo ""
    ;;
  "数码"|"手机")
    echo "📱 数码定价策略:"
    echo ""
    echo "低价高频 (¥9-49):"
    echo "  - 手机壳、数据线"
    echo "  - 策略: 走量、复购"
    echo "  - 利润率: 30-50%"
    echo ""
    echo "中端配件 (¥49-199):"
    echo "  - 充电器、耳机"
    echo "  - 策略: 功能差异化"
    echo "  - 利润率: 25-40%"
    echo ""
    echo "高端旗舰 (¥199+):"
    echo "  - 品牌配件、无线充电"
    echo "  - 策略: 品质路线"
    echo "  - 利润率: 30-45%"
    echo ""
    ;;
  *)
    echo "💡 通用定价建议:"
    echo ""
    echo "1. 心理定价:"
    echo "   - ¥99 比 ¥100 更有吸引力"
    echo "   - ¥199 比 ¥200 感觉便宜很多"
    echo "   - 避免整数，用 .9 或 .8"
    echo ""
    echo "2. 组合定价:"
    echo "   - 买二送一提高客单价"
    echo "   - 套装比单件更有吸引力"
    echo "   - 满减活动刺激消费"
    echo ""
    echo "3. 竞争定价:"
    echo "   - 搜索同类产品价格"
    echo "   - 价格略低于头部卖家"
    echo "   - 用优惠券制造价格优势"
    echo ""
    echo "4. 动态定价:"
    echo "   - 大促前适当涨价再打折"
    echo "   - 新品期高价，后期降价"
    echo "   - 季末清仓低价走量"
    echo ""
    ;;
esac

echo "================================"
echo "📈 价格优化技巧"
echo "================================"
echo ""
echo "✅ DO:"
echo "- 测试不同价格点"
echo "- 用优惠券做价格实验"
echo "- 关注竞品价格变动"
echo "- 设置多SKU覆盖不同价格段"
echo ""
echo "❌ DON'T:"
echo "- 不要一味低价竞争"
echo "- 不要频繁改价"
echo "- 不要忽视成本计算"
echo "- 不要定价过低影响利润"
echo ""
