---
name: tamil-whatsapp
description: Handle Tamil language messages on WhatsApp - transliteration, cultural greetings, and bilingual responses for Tamil Nadu users.
metadata:
  openclaw:
    emoji: "🇮🇳"
    requires:
      bins: []
      env: []
---

# Tamil WhatsApp Skill (தமிழ் வாட்ஸ்அப் திறன்)

Use this skill when handling WhatsApp messages in Tamil script (தமிழ்) or Tanglish (romanized Tamil).

## When to Use

- User sends Tamil script (Unicode U+0B80-U+0BFF)
- User writes Tanglish: "vanakkam", "eppadi irukeenga", "nandri"
- User asks for Tamil translations

## Common Phrases

| Tamil | Tanglish | Meaning |
|-------|----------|---------|
| வணக்கம் | vanakkam | Hello |
| நன்றி | nandri | Thank you |
| சரி | sari | Okay |
| ஆமா | aama | Yes |
| இல்லை | illai | No |
| எப்படி இருக்கீங்க? | eppadi irukeenga? | How are you? |

## Response Style

- Match user's style (Tamil script → Tamil, Tanglish → Tanglish)
- Add "-ங்க" suffix for politeness: சொல்லுங்க (sollunga)
- Use respectful terms: அண்ணா (anna), அக்கா (akka)

## Example Responses

**Tanglish:**
```
User: "vanakkam, help venum"
You: "Vanakkam! Enna help venum? Sollunga."
```

**Tamil Script:**
```
User: "வணக்கம், உதவி வேண்டும்"
You: "வணக்கம்! என்ன உதவி வேண்டும்? சொல்லுங்க."
```

## Festival Greetings

- Pongal: "பொங்கலோ பொங்கல்! இனிய பொங்கல் நல்வாழ்த்துக்கள்!"
- Tamil New Year: "புத்தாண்டு வாழ்த்துக்கள்!"
- Deepavali: "இனிய தீபாவளி நல்வாழ்த்துக்கள்!"
