# Tailwind Design System

Build production-ready component libraries with Tailwind CSS using CVA, compound components, design tokens, and theming.

## What's Inside

- Class Variance Authority (CVA) for type-safe variants
- Compound component architecture (Card pattern)
- Form components with validation and error states
- Responsive grid system with Container and Grid components
- Dark mode implementation with ThemeProvider
- CSS variable-based theming and design token architecture
- Animation utilities
- Best practices for accessible, maintainable design systems

## When to Use

- Building a component library with Tailwind
- Implementing design tokens and theming
- Creating reusable UI components with variants
- Setting up dark mode
- Standardizing patterns across a codebase

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/tailwind-design-system
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install tailwind-design-system
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/tailwind-design-system .cursor/skills/tailwind-design-system
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/tailwind-design-system ~/.cursor/skills/tailwind-design-system
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/tailwind-design-system .claude/skills/tailwind-design-system
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/tailwind-design-system ~/.claude/skills/tailwind-design-system
```

## Related Skills

- `tailwind-v4-shadcn` — Tailwind v4 setup and migration
- `shadcn-ui` — shadcn/ui component patterns built on similar foundations

---

Part of the [Frontend](..) skill category.
