# 系统修复专家使用示例

## 示例1: Web服务器错误

**用户**: "我的Nginx服务器返回502错误，无法访问网站"

**系统修复专家**:
```
✅ 第0步：记忆模式匹配 → 找到相似历史案例：Nginx 502错误通常与上游服务有关

✅ 第1步：问题理解完成 → Nginx返回502 Bad Gateway错误

→ 第2步：官方方案查询中...正在查找Nginx官方文档中关于502错误的解决方案...
  - 根据官方文档，502错误通常表示Nginx无法连接到上游服务器(如PHP-FPM, Node.js等)
  - 建议检查上游服务是否正在运行
  - 检查Nginx配置中的proxy_pass或fastcgi_pass设置

→ 第3步：ClawdHub技能匹配...正在搜索相关技能
  - 找到技能：nginx-troubleshooter-v1.0
  - 建议先尝试安装此技能进行自动诊断

⚠️ 置信度评估：高 - Nginx 502错误是常见问题，解决方案相对标准化
```

## 示例2: 数据库连接问题

**用户**: "MySQL连接超时，应用程序无法连接数据库"

**系统修复专家**:
```
✅ 第0步：记忆模式匹配 → 找到相似历史案例：MySQL连接超时问题

✅ 第1步：问题理解完成 → MySQL连接超时错误

→ 第2步：官方方案查询中...正在查找MySQL官方文档中关于连接超时的解决方案...
  - 检查MySQL服务是否正在运行
  - 验证网络连接和防火墙设置
  - 检查max_connections参数设置

⚠️ 置信度评估：高 - MySQL连接问题是常见问题，有标准排查流程
```

## 示例3: 权限错误

**用户**: "尝试运行脚本时收到权限被拒绝错误"

**系统修复专家**:
```
✅ 第0步：记忆模式匹配 → 未找到直接匹配

✅ 第1步：问题理解完成 → 脚本执行权限被拒绝

→ 第2步：官方方案查询中...正在查找操作系统权限管理的官方文档...
  - 检查文件权限：ls -la <script_file>
  - 修改权限：chmod +x <script_file>
  - 验证所有权：chown <user>:<group> <script_file>

⚠️ 置信度评估：高 - 权限问题是标准的系统管理问题
```