# JavaScript/TypeScript Development Standards

## Code Style
- Use **camelCase** for variables, functions, and methods.
- Use **PascalCase** for classes, components, and interfaces.
- Use **UPPER_CASE** for constants.
- Indent using **2 spaces**.
- Always use **Semicolons**.

## TypeScript Rules
- Avoid `any` - use explicit types or `unknown`.
- Use `interface` over `type` for object shapes.
- Enable `strict: true` in `tsconfig.json`.

## Tools
- **Formatter**: `prettier`.
- **Linter**: `eslint` (with TypeScript plugin).
- **Package Manager**: `npm` (preferred) or `pnpm`.
