# Project:

## Overview

Brief description of the project.

## Quick Start

### Node / TypeScript

```bash
git clone ...
npm install
npm run dev
```

### Python

```bash
git clone ...
python3 -m venv .venv
source .venv/bin/activate   # Windows: .venv\Scripts\activate
pip install -e .
pytest
```

## Architecture

- **Frontend**: [React/Vue/Next.js]
- **Backend**: [Node/Python/Go]
- **Database**: [Postgres/MySQL/SQLite]
- **Cache**: [Redis/Memcached]

See [ARCHITECTURE.md](ARCHITECTURE.md) for components, data flow, and decisions.

## Development Standards

- Use pre-commit hooks (e.g. `husky` for Node, `pre-commit` for Python).
- Lint and format before pushing.
- Unit tests required for new features.

## Contributors

- [Your Name]
