# Source Types & Credibility Weights

## Primary Sources (High Weight)
- **Original research** — peer-reviewed studies, official reports
- **First-hand accounts** — interviews, testimonies, direct observation
- **Official documentation** — specs, legal documents, standards

## Secondary Sources (Medium Weight)
- **Analysis/Commentary** — expert articles, reviews, case studies
- **Aggregated data** — surveys, meta-analyses, industry reports
- **Educational content** — textbooks, courses, tutorials

## Tertiary Sources (Lower Weight)
- **Summaries** — encyclopedias, wikis, overview articles
- **News reporting** — journalism (verify with primary when possible)
- **Social/Community** — forums, discussions, anecdotal

## Credibility Signals

| Signal | Increases | Decreases |
|--------|-----------|-----------|
| Author expertise | Domain credentials | No background |
| Publication venue | Peer review, editorial | Self-published |
| Citations | Well-cited by others | No references |
| Recency | Recent for fast-moving topics | Outdated data |
| Transparency | Methodology shown | Black box claims |
| Conflicts | Disclosed/none | Hidden interests |

## Weighting Formula

```
credibility = base_type_weight 
            × recency_factor (0.5-1.0)
            × authority_factor (0.5-1.5)
            × transparency_factor (0.7-1.0)
```

Use relative weights when reconciling conflicts between sources.
