# Conflict Resolution Strategies

## Detection

Conflicts appear as:
- Direct contradiction (A says X, B says not-X)
- Magnitude disagreement (A says 10%, B says 50%)
- Scope difference (A discusses narrow case, B generalizes)
- Temporal shift (A was true in 2020, B reflects 2024)

## Resolution Hierarchy

### 1. Reconcile (Preferred)
Both can be true under different conditions:
- "A applies to [context], B applies to [other context]"
- "A was true until [event], now B applies"
- "A measures [X], B measures [Y] — different metrics"

### 2. Weight & Choose
When truly contradictory, weight by:
1. **Recency** — newer data for evolving topics
2. **Methodology** — better research design wins
3. **Sample size** — larger/more representative
4. **Expertise** — domain authority of source
5. **Consensus** — N sources vs 1 outlier

### 3. Present Both
When resolution isn't possible:
- State both positions clearly
- Explain why resolution failed
- Note what would resolve it (more data, time, etc.)

## Documentation Format

```
⚔️ CONFLICT: [topic]
   Source A: [claim] (weight: X)
   Source B: [claim] (weight: Y)
   Resolution: [reconciled/chose A/chose B/both presented]
   Reasoning: [why]
```

## Red Flags

- Silently dropping one source's claim
- Averaging contradictory numbers without justification
- Assuming newer always beats older
- Ignoring outliers without examination
