# Synthdata API Reference

## Endpoint

```
GET https://api.synthdata.co/insights/volatility?asset={TICKER}
```

## Authentication

Include API key in header:
```
Authorization: Apikey {YOUR_API_KEY}
```

## Available Assets

| Ticker | Name | Description |
|--------|------|-------------|
| BTC | Bitcoin | Leading cryptocurrency |
| ETH | Ethereum | Smart contract platform |
| SOL | Solana | High-performance blockchain |
| XAU | Gold | Precious metal spot price |
| SPYX | S&P 500 | US large-cap index |
| NVDAX | NVIDIA | AI/GPU semiconductor |
| GOOGLX | Google | Alphabet Inc. |
| TSLAX | Tesla | Electric vehicles |
| AAPLX | Apple | Consumer tech |

## Response Structure

```json
{
  "realized": {
    "prices": [
      { "price": 77132.29, "returns": null },
      { "price": 77172.32, "returns": 0.00052 },
      ...
    ],
    "volatility": [41.62, 82.4, 60.11, ...],
    "average_volatility": 53.36
  },
  "current_price": 77941.58,
  "forecast_past": {
    "volatility": [null, 50.84, 48.33, ...],
    "average_volatility": 52.75
  },
  "forecast_future": {
    "volatility": [null, 40.67, 43.48, ...],
    "average_volatility": 52.21
  }
}
```

## Response Fields

### `realized`
Historical data containing:
- **prices**: Array of `{price, returns}` objects - recent price history with log returns
- **volatility**: Array of realized volatility values (annualized %)
- **average_volatility**: Mean of realized volatility array

### `current_price`
Latest price for the asset.

### `forecast_past`
Model's historical volatility predictions (for backtesting):
- **volatility**: Array of predicted values
- **average_volatility**: Mean prediction

### `forecast_future`
Forward-looking volatility predictions:
- **volatility**: Array of forecast values (next periods)
- **average_volatility**: Mean forecast

## Volatility Interpretation

| Level | Range | Meaning |
|-------|-------|---------|
| Low | < 20% | Stable, low risk |
| Moderate | 20-40% | Normal market conditions |
| Elevated | 40-60% | Above-average movement expected |
| High | 60-80% | Significant price swings likely |
| Extreme | > 80% | Very volatile, high risk |

## Rate Limits

- Free tier: ~1 request/second recommended
- Add delays when fetching multiple assets

## Error Handling

HTTP errors return standard status codes. Check for `error` key in response for API-specific errors.
