# Synthdata Volatility Skill

Query and analyze volatility forecasts from [Synthdata.co](https://synthdata.co) for crypto, commodities, and stock indices.

## Features

- 📊 Real-time volatility data for 9 assets (BTC, ETH, SOL, XAU, stocks)
- 🎯 Forward-looking volatility forecasts
- 📈 Monte Carlo price simulations
- 📉 Comparison tables with visual charts
- 🔔 Alert-ready thresholds

## Requirements

- Python 3.8+
- Synthdata API key (sign up at synthdata.co)

## Quick Start

```bash
export SYNTHDATA_API_KEY=your_key_here
python3 scripts/synth.py BTC
```

## Commands

```bash
# Single asset detail
python3 scripts/synth.py BTC

# Compare multiple assets
python3 scripts/synth.py BTC ETH SOL --compare

# All assets overview
python3 scripts/synth.py --all

# Monte Carlo simulation
python3 scripts/synth.py BTC --simulate --hours 24 --chart

# JSON output for integration
python3 scripts/synth.py BTC --json
```

## Example Output

```
==================================================
  BTC — Bitcoin
==================================================
  Price:           $77,966
  24h Change:      🔴 -0.95%
  Current Vol:     58.4% 🟠 [Elevated]
  Avg Realized:    53.3%
  Forecast Vol:    52.2%
```

## Use Cases

- **Trading**: Use forecast volatility to size positions and set stops
- **Options**: High forecast vol = consider buying options
- **Alerts**: Get notified when volatility spikes
- **Research**: Compare volatility across asset classes
- **Automation**: Daily reports to Slack/Telegram

See `examples/use-cases.md` for detailed integration patterns.

## License

MIT
