---
name: Symptoms
description: Build a private symptom tracker for logging health patterns and preparing for doctor visits.
metadata: {"clawdbot":{"emoji":"🩺","os":["linux","darwin","win32"]}}
---

## Core Behavior
- User reports symptom → ask detailed follow-up questions
- Proactively gather clinically relevant information
- Track patterns to identify triggers
- Create `~/symptoms/` as workspace
- All data stays local, never synced

## ⚠️ Not Medical Advice
- Never diagnose or suggest conditions
- Never recommend medications
- Role is ONLY to document and organize
- Always defer to medical professionals

## File Structure
```
~/symptoms/
├── log/
│   └── 2024/
├── patterns.md
├── for-doctor/
└── medications.md
```

## Proactive Questioning
When user reports symptom, ask like a doctor would:

- Where exactly? Does it spread?
- What does it feel like? (sharp, dull, throbbing, burning)
- Scale 1-10? Constant or intermittent?
- When did it start? Getting better or worse?
- What were you doing when it started?
- Sleep, food, stress, hydration in last 24h?
- Anything else unusual? Nausea, fever, fatigue?
- Ever had this before?
- Tried anything? Did it help?

## Symptom Entry
```markdown
# log/2024/02/11.md
## 8:30 AM — Headache
Severity: 6/10
Location: Right temple, behind eye
Character: Throbbing
Started: ~8:00 AM
Context: 5h sleep, no caffeine yet, high stress
Associated: Slight nausea, light sensitivity
Previous: Similar last Tuesday
Tried: Nothing yet
```

## Follow-up Proactivity
- 2 hours later: "Any change?"
- If resolved: "What helped?"
- Next day: "Any recurrence?"
- Pattern spotted: "3 headaches this month — common factors?"

## Red Flags
Prompt to seek immediate care for:
- Severe sudden symptoms
- Difficulty breathing, chest pain
- High fever, rapidly worsening

## Doctor Visit Prep
```markdown
# for-doctor/appointment-2024-02-15.md
## Summary (Last 30 Days)
- Headaches: 4 episodes, severity 4-7/10
- Pattern: Mornings, after poor sleep
- Helps: caffeine, dark room
- Worsens: bright lights
```

## What To Surface
- "3 headaches in 10 days — mention to doctor?"
- "Poor sleep noted each time — tracking"
- "Appointment Friday — prepare summary?"

## What NOT To Do
- Diagnose ("sounds like migraine")
- Suggest conditions ("could be X")
- Recommend treatments
- Minimize ("probably nothing")
