# Sydney Visitor Itineraries

> Practical, day-by-day guides for visitors. All prices in AUD, current as of February 2026.

---

## Quick Reference: Transport & Costs

### Getting Around
- **Opal Card**: Contactless payments accepted (credit/debit card, Apple Pay, Google Pay)
- **Daily Cap**: $19.30 Mon-Thu, $9.65 Fri-Sun & holidays
- **Weekly Cap**: $50
- **30% off**: Off-peak travel discount
- **$2 transfer discount**: Between different transport modes

### Key Ferry Routes
| Route | Duration | Frequency |
|-------|----------|-----------|
| Circular Quay → Manly | 30 min | Every 15-20 min |
| Circular Quay → Taronga Zoo | 12 min | Every 15 min |
| Circular Quay → Barangaroo | 5 min | Every 10 min |

---

## 1-Day Sydney Essentials

**Best for**: First-time visitors, cruise ship passengers, transit stops

### Hour-by-Hour Schedule

| Time | Activity | Location | Cost |
|------|----------|----------|------|
| 8:00 | Breakfast | The Rocks | $20-35 |
| 9:00 | Sydney Opera House | Circular Quay | Free (exterior) |
| 9:30 | Opera House Tour (optional) | Bennelong Point | $47 |
| 10:30 | Harbour Bridge walk | The Rocks | Free |
| 11:30 | The Rocks exploration | Historic quarter | Free |
| 12:30 | Lunch | Circular Quay/The Rocks | $25-45 |
| 14:00 | Ferry to Manly | Circular Quay | Opal fare |
| 14:30 | Manly Beach | Northern Beaches | Free |
| 16:30 | Ferry back | Manly Wharf | Opal fare |
| 17:00 | Mrs Macquarie's Chair | Royal Botanic Garden | Free |
| 18:00 | Sunset drinks | Opera Bar | $15-25 |
| 19:30 | Dinner | CBD/The Rocks | $40-80 |

### Detailed Breakdown

**8:00 – Breakfast at The Rocks**
- **La Renaissance** (47 Argyle St) – French patisserie, excellent coffee and croissants. $15-25
- **The Fine Food Store** (Kendall Lane) – Great breakfast bowls and local produce. $18-28

**9:00 – Sydney Opera House**
- Walk around the exterior – completely free
- Photo spots: Mrs Macquarie's Point, Opera Bar forecourt, Circular Quay steps
- **Tour Option**: 1-hour guided tour $47 adult, $35 child. Book online in advance.

**10:30 – Sydney Harbour Bridge**
- Free pedestrian walk across (east side, access from Cumberland St, The Rocks)
- Takes ~20 minutes one way
- **BridgeClimb** (if booked): From $198-398 depending on time/climb type. Book 2-4 weeks ahead for popular times.
- **Pylon Lookout**: $19 adult, great views without the climb

**11:30 – The Rocks Historic Quarter**
- Cobblestone laneways, heritage buildings, street art
- **Weekend**: The Rocks Markets (Sat-Sun 10am-5pm) – artisan crafts, food stalls
- Free walking tours available (tips appreciated)

**12:30 – Lunch Options**
- **Quay** (fine dining, harbour views) – $250+ pp. Advance booking essential.
- **Sake Restaurant** (contemporary Japanese) – $50-80 pp
- **Fortune of War** (Sydney's oldest pub, est. 1828) – pub meals $25-35
- **Glenmore Hotel rooftop** – casual food, stunning views $30-45

**14:00 – Manly Ferry**
- Departs from Circular Quay Wharf 3
- 30-minute scenic journey past Opera House, Fort Denison, Sydney Heads
- One of the world's most beautiful urban ferry rides

**14:30 – Manly Beach**
- Walk The Corso (pedestrian mall) to the beach (5 min)
- Swim at the main beach or calmer Shelly Beach (10 min walk south)
- **Optional**: Rent a surfboard/paddleboard at Manly Surf School (~$30/hour)

**17:00 – Mrs Macquarie's Chair**
- Walk through Royal Botanic Garden (free entry)
- Best sunset photo spot with Opera House and Bridge together
- 15-min walk from Circular Quay through the gardens

**18:00 – Sunset Drinks**
- **Opera Bar** (right under the Opera House) – cocktails $20-28, wine from $14
- **The Glenmore** rooftop (The Rocks) – more casual, great views

**19:30 – Dinner**
- **Bistecca** (CBD) – Florentine steaks, order by weight. $80-120 pp
- **Ho Jiak** (Haymarket) – Authentic Malaysian. $30-50 pp
- **Pellegrino 2000** (Surry Hills) – Classic Italian trattoria. $60-80 pp

### Transport Summary
- Total Opal spend: ~$10-15 (under daily cap)
- All attractions walkable from Circular Quay except Manly (ferry)

---

## 3-Day Sydney Itinerary

### Day 1: CBD & Harbour

**Morning**
| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 8:00 | Breakfast | Paramount Coffee Project, Surry Hills | $20-30 |
| 9:30 | Art Gallery of NSW | Free permanent collection, opens 10am Wed til 10pm | Free |
| 11:00 | Royal Botanic Garden | Walk to Mrs Macquarie's Chair | Free |
| 12:00 | Sydney Opera House | Exterior exploration, photos | Free |

**Afternoon**
| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 12:30 | Lunch | Opera Bar or MCA Cafe | $35-50 |
| 14:00 | The Rocks | Markets (weekend) or walking tour | Free |
| 15:30 | Harbour Bridge | Walk or Pylon Lookout | Free/$19 |
| 17:00 | Barangaroo | Waterfront walk, modern precinct | Free |

**Evening**
| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 18:30 | Sunset drinks | Barooo Bar or The Glenmore | $20-30 |
| 20:00 | Dinner | Quay, Bennelong, or Aria | $150-300 |

**Day 1 Restaurant Picks**
- **Breakfast**: Paramount Coffee Project (Surry Hills) – specialty coffee, creative breakfast. $22-35
- **Lunch**: MCA Cafe (The Rocks) – level 4, harbour views, modern Australian. $30-45
- **Dinner Options**:
  - **Bennelong** (inside Opera House) – Australian fine dining, $180-250 pp
  - **Aria** (Circular Quay) – harbour views, degustation available. $150-220 pp
  - **King Clarence** (CBD) – Asian fusion, buzzy atmosphere. $70-100 pp

---

### Day 2: Beaches (Bondi, Coogee, Manly)

**Option A: Bondi to Coogee Coastal Walk** (recommended)

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 8:00 | Bus to Bondi | From CBD, bus 333 or 380 (30 min) | Opal |
| 8:30 | Breakfast at Bondi | Beach views while you eat | $20-35 |
| 9:30 | Start coastal walk | 6km, 2-3 hours with stops | Free |
| 10:00 | Bondi Icebergs Pool | Iconic ocean pool (swim optional) | $9 |
| 10:30 | Tamarama Beach | Small, beautiful, good for photos | Free |
| 11:00 | Bronte Beach | Larger beach, ocean pool, cafes | Free |
| 12:00 | Waverley Cemetery | Heritage-listed, ocean views | Free |
| 12:30 | Clovelly | Calm bay, snorkeling spot | Free |
| 13:00 | Arrive Coogee | End of walk | Free |
| 13:30 | Lunch at Coogee | Beach dining | $30-50 |
| 15:00 | Return to CBD | Bus from Coogee (~40 min) | Opal |
| 16:00 | Rest/hotel | | |

**Day 2 Beach Restaurants**
- **Breakfast at Bondi**:
  - **Sean's Panorama** – seasonal menu, beach views. $35-50 (booking recommended)
  - **Porch and Parlour** – healthy bowls, coffee. $18-28
  - **Speedos Cafe** – classic Australian breakfast. $20-30
- **Lunch at Bronte** (mid-walk):
  - **The Bogey Hole** – casual cafe, great for a pit stop. $15-25
  - **Iggy's Bread** – famous bakery, excellent pastries. $8-15
- **Lunch at Coogee**:
  - **Coogee Pavilion** – wood-fired pizzas, beach views. $30-50
  - **Coogee Wine Room** – wine bar, small plates. $40-60
  - **The Coogee Bay Hotel** – pub classic since 1873. $25-40

**Walk Essentials**
- Wear comfortable shoes (some stairs/uneven paths)
- Bring sunscreen, hat, water
- Swimming gear if stopping at pools/beaches
- Dogs allowed on leads
- Drinking fountains at each beach

**Option B: Manly Day** (alternative or PM addition)

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 14:00 | Ferry to Manly | 30 min scenic ride | Opal |
| 14:30 | Manly Beach | Swim, surf, or relax | Free |
| 15:30 | Walk to Shelly Beach | 10 min, calmer swimming | Free |
| 16:30 | Explore The Corso | Shops, cafes, surf stores | Free |
| 17:30 | Drinks | 4 Pines Brewpub or Hugo's | $20-30 |
| 18:30 | Dinner | Manly options | $40-70 |
| 20:00 | Ferry back | Night ferry, city lights | Opal |

**Manly Restaurants**
- **Garfish Manly** – seafood, always busy. $50-70 pp
- **The Boathouse Shelly Beach** – fish & chips, beachfront. $30-45
- **4 Pines Brewpub** – craft beer, pub food. $30-45
- **Manly Pavilion** – upscale, ocean views. $70-100

---

### Day 3: Inner Suburbs Culture

**Route**: Newtown → Surry Hills → Paddington (or reverse)

**Morning: Newtown** (Train to Newtown Station, 10 min from CBD)

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 9:00 | Coffee & breakfast | King Street cafes | $18-30 |
| 10:00 | King Street stroll | Vintage shops, bookstores, street art | Free |
| 11:30 | Record store browsing | Repressed Records, vintage finds | Varies |
| 12:30 | Lunch | Newtown diverse dining | $25-50 |

**Newtown Highlights**
- **Better Read Than Dead** – iconic bookshop
- **Gould's Book Arcade** – enormous second-hand bookstore
- **Repressed Records** – vinyl paradise
- **Street art** – murals throughout, self-guided walking tour
- **King Street** – 2.5km of cafes, bars, vintage stores

**Newtown Restaurants**
- **Breakfast**: Continental Deli – tinned cocktails, continental vibes. $20-35
- **Lunch**:
  - **Ante** – Japanese-fusion, 60+ sakes, vinyl collection. $50-80
  - **Cafe Paci** – Finnish-Australian, excellent wine list. $60-90
  - **Mary's** – dive bar burgers. $25-35

**Afternoon: Surry Hills** (Bus or 20-min walk from Newtown)

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 14:00 | Crown Street | Shopping, galleries | Free |
| 14:30 | Brett Whiteley Studio | Art museum in converted warehouse | $15 |
| 15:30 | Coffee break | Specialty coffee culture | $6-10 |
| 16:30 | Walk to Paddington | Via Oxford Street | Free |

**Surry Hills Must-Dos**
- **Brett Whiteley Studio** (2 Raper St) – intimate museum of iconic Australian artist. $15
- **Golden Age Cinema** – underground movie theatre, cocktails. Films from $20
- **Vintage shopping** – Zoo Emporium, C's Flashback
- **Coffee**: Single O, Reuben Hills, Artificer

**Evening: Paddington**

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 17:00 | Oxford Street | Designer boutiques, galleries | Free |
| 17:30 | William Street | Art galleries, wine bars | Free |
| 18:30 | Drinks | 10 William Street wine bar | $15-25 |
| 20:00 | Dinner | Paddington dining | $70-120 |

**Paddington Restaurants**
- **Pre-dinner drinks**: 10 William Street – natural wines, Italian small plates. $40-60
- **Dinner**:
  - **Saint Peter** (Josh Niland's fish restaurant) – $120-180 pp. Book ahead.
  - **Fred's** – farm-to-table, wood-fired. $100-140 pp
  - **Ursula's** – French-Australian bistro. $80-110 pp
  - **Buon Ricordo** – Italian institution, 30+ years. $100-150 pp

**Day 3 Tips**
- Saturday: Paddington Markets (10am-4pm) at Paddington Uniting Church – emerging designers, handmade goods
- October-November: Jacaranda season – purple-covered streets
- Walking: Flat terrain, ~8-10km total if walking between suburbs

---

## 7-Day Sydney & Surrounds

### Overview

| Day | Focus | Transport |
|-----|-------|-----------|
| 1 | CBD & Harbour | Walk/ferry |
| 2 | Beaches (Bondi-Coogee) | Bus |
| 3 | Inner suburbs | Train/bus |
| 4 | Blue Mountains | Train/car |
| 5 | Northern Beaches | Bus/ferry |
| 6 | South (Royal National Park) | Train |
| 7 | Flexible/Hunter Valley | Car/tour |

---

### Day 4: Blue Mountains

**Distance from Sydney**: 100km west (~2 hours by train, 1.5 hours by car)

**Getting There**
- **Train**: Central Station → Katoomba. 2 hours, ~$8-10 Opal (off-peak)
- **Car**: Via M4/Great Western Highway. Parking available at attractions.
- **Guided Tour**: From $150-200 pp, includes transport + Scenic World

**Full Day Itinerary**

| Time | Activity | Location | Cost |
|------|----------|----------|------|
| 7:00 | Train departs Central | Platform 16/17 | Opal |
| 9:00 | Arrive Katoomba | | |
| 9:15 | Breakfast | Katoomba cafes | $15-25 |
| 10:00 | Echo Point | Three Sisters viewpoint | Free |
| 10:30 | Scenic World | All rides + walkway | $61 |
| 13:00 | Lunch | Scenic World or Leura | $20-40 |
| 14:00 | Leura Village | Quaint shops, cafes | Free |
| 15:30 | Prince Henry Cliff Walk | Optional hiking | Free |
| 17:00 | Return train | Katoomba Station | Opal |
| 19:00 | Arrive Sydney | | |

**Scenic World (Must-Do)**
- **Scenic Railway**: World's steepest (52°) passenger railway into rainforest
- **Scenic Skyway**: Glass-floor cable car, 270m above valley
- **Scenic Cableway**: Panoramic views across Jamison Valley
- **Scenic Walkway**: 2.4km elevated boardwalk through rainforest

**Prices (Feb 2026)**
- Adults: from $61 (unlimited rides day pass)
- Kids under 3: Free
- Premium experiences: from $105

**Book online to save up to 20%**

**Blue Mountains Restaurants**
- **Katoomba**: 
  - Yellow Deli – unique café experience. $15-25
  - Common Ground Cafe – local favourite. $18-30
- **Leura** (5 min from Katoomba, more charming):
  - Leura Garage – modern Australian in vintage service station. $50-80
  - Silk's Brasserie – fine dining. $80-120
  - Red Door Café – cozy, excellent coffee. $15-25

**Walking Options**
- **Three Sisters Walk** (easy, 20 min) – steps down to first sister
- **Prince Henry Cliff Walk** (moderate, 2-3 hours) – clifftop views
- **Grand Canyon Track** (harder, 3 hours) – into the valley
- **Giant Stairway** (challenging, 800+ steps) – down to valley floor

**Tips**
- Weather can be 10°C cooler than Sydney – bring layers
- Morning fog often clears by 10am, creating dramatic photos
- Weekends are busy – go early or weekday if possible

---

### Day 5: Northern Beaches Exploration

**Route**: Manly → Freshwater → Curl Curl → Dee Why → (optional) Palm Beach

**Getting There**
- Ferry: Circular Quay → Manly (30 min)
- Continue north by bus (routes 136, 169)

**Itinerary**

| Time | Activity | Location | Cost |
|------|----------|----------|------|
| 8:30 | Ferry to Manly | Circular Quay | Opal |
| 9:00 | Breakfast at Manly | Beach cafes | $20-30 |
| 10:00 | Manly to Shelly Beach | Walk (10 min) | Free |
| 10:30 | Spit to Manly Walk (partial) | Coastal bushland | Free |
| 12:00 | Freshwater Beach | Surf beach, less crowded | Free |
| 13:00 | Lunch | Freshwater | $25-40 |
| 14:30 | Curl Curl Beach | Local beach, rock pools | Free |
| 15:30 | Dee Why Beach | Long beach, cafes | Free |
| 16:30 | Return to Manly | Bus | Opal |
| 17:30 | Drinks at Manly | Sunset views | $20-30 |
| 18:30 | Ferry back | Night views | Opal |

**Palm Beach Extension** (add 2-3 hours)
- Bus from Manly to Palm Beach: ~1 hour
- **Barrenjoey Lighthouse walk**: 1.5km, stunning views
- **The Boathouse Palm Beach**: Legendary fish & chips. $25-40
- **Jonah's** (Whale Beach): Fine dining with views. $150-250

**Northern Beaches Restaurants**
- **Manly**: Papi Chulo (BBQ, waterfront) $50-70, Garfish $60-80
- **Freshwater**: Harbord Beach Hotel (pub with surf views) $30-50
- **Palm Beach**: Barrenjoey House $70-100

---

### Day 6: Royal National Park

**The World's Second-Oldest National Park** (est. 1879)

**Getting There**
- **Train**: Central → Cronulla (~50 min), then ferry to Bundeena (25 min)
- **Car**: ~45 min from CBD, $12 park entry fee per vehicle

**Itinerary Option 1: Coast Track (Full Day)**

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 7:30 | Train to Cronulla | Central Station | Opal |
| 8:20 | Ferry to Bundeena | Cronulla Wharf | $7.60 |
| 9:00 | Start Coast Track | Bundeena end | Free |
| 10:30 | Wedding Cake Rock | Photo spot (fenced) | Free |
| 11:30 | Marley Beach | Swim, picnic | Free |
| 13:00 | Little Marley Beach | Quieter option | Free |
| 14:00 | Wattamolla | Beach, lagoon, BBQs | Free |
| 15:30 | Continue or return | Via bus or arrange pickup | Varies |

**Itinerary Option 2: Audley & Easy Walks**

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 9:00 | Drive to Audley | Via Princes Highway | $12 entry |
| 10:00 | Audley Boatshed | Kayak hire | $20-30/hr |
| 11:30 | Forest Walk | Easy 2km loop | Free |
| 13:00 | Picnic at Audley | BYO or nearby cafe | $15-30 |
| 14:30 | Drive to Wattamolla | 15 min | Free |
| 15:00 | Wattamolla Beach | Swim in lagoon | Free |
| 17:00 | Return to Sydney | Via McKell Ave | |

**Figure Eight Pools** (Advanced)
- ⚠️ Only accessible at low tide, dangerous conditions common
- Check conditions: nationalparks.nsw.gov.au
- Guided tours recommended: ~$150 pp
- Not suitable for casual visitors

**Royal National Park Highlights**
- **The Coast Track**: 26km multi-day or sections, stunning cliffs
- **Wattamolla**: Lagoon beach, waterfalls, BBQ facilities
- **Garie Beach**: Surf beach, cafe nearby
- **Wedding Cake Rock**: Instagram-famous (but now fenced for safety)
- **Audley**: Boatshed, picnic area, historic weir

**What to Bring**
- Plenty of water (2L+ per person)
- Sunscreen, hat
- Sturdy shoes for walking tracks
- Swimming gear
- Snacks/lunch (limited facilities)

---

### Day 7: Flexible Day

**Option A: Hunter Valley Wine Region**

**Distance**: 2 hours north of Sydney

**Getting There**
- **Guided Tour**: Recommended – includes tastings, transport. From $150-250 pp
- **Self-Drive**: Via M1/Hunter Expressway. Designate a driver!

**Hunter Valley Highlights**
- **120+ wineries** – Semillon and Shiraz specialties
- **Cellar doors**: Tyrrell's (est. 1858), Brokenwood, Audrey Wilkinson, Tulloch
- **Restaurants**: Margan, Bistro Molines, Muse Restaurant (all excellent)

**Sample Wine Tour Day**

| Time | Activity | Location |
|------|----------|----------|
| 9:00 | Depart Sydney | M1 north |
| 11:00 | First tasting | Tyrrell's or Tulloch |
| 12:00 | Second tasting | Audrey Wilkinson (views!) |
| 13:00 | Lunch | Muse Restaurant or Margan |
| 14:30 | Third tasting | Brokenwood |
| 15:30 | Fourth tasting | Peterson House |
| 17:00 | Return to Sydney | |

**Budget**: $200-400 pp including tastings, lunch, transport (if touring)

---

**Option B: Taronga Zoo Day**

**Getting There**: Ferry from Circular Quay (12 min)

| Time | Activity | Details | Cost |
|------|----------|---------|------|
| 9:15 | Ferry departs | Circular Quay | Opal |
| 9:30 | Arrive Taronga | Sky Safari to top | Incl. |
| 9:30-15:00 | Zoo exploration | Australian wildlife, views | $57 |
| 15:00 | Keeper talks | Various times | Incl. |
| 16:00 | Ferry back | Harbour views | Opal |

**Taronga Tips**
- Book online: save up to 20%
- Start at top (Sky Safari up), walk down
- Don't miss: Platypus, koala walkabout, harbour views
- **Wild Ropes**: Additional high ropes course. From $45

**Prices (2026)**
- Adult: $57 (online) / $71 (gate)
- Child (4-15): $35 / $45
- Under 4: Free

---

**Option C: Sydney Hidden Gems**

For repeat visitors or those wanting something different:

**Morning**: Barangaroo & The Bays
- Walk Barangaroo Reserve (headland park)
- Fish Market redevelopment (opening 2026)
- Blackwattle Bay precinct

**Afternoon**: Inner West Craft Beer Trail
- **Young Henrys** (Newtown) – brewery tours
- **Grifter Brewing** (Marrickville)
- **Wildflower Brewing** (Marrickville)
- **Sauce Brewing** (Marrickville)

**Evening**: Chinatown & Night Markets
- Paddy's Markets (Haymarket)
- Eating House food court
- Night Noodle Markets (seasonal)

---

## Special Interest Itineraries

### 🍷 Food & Wine Focus (3 Days)

**Day 1: Fine Dining & Harbour**

| Meal | Restaurant | Style | Budget |
|------|------------|-------|--------|
| Breakfast | Bills (Surry Hills) | Iconic Aussie breakfast | $30-45 |
| Lunch | Bennelong | Australian, Opera House | $120-180 |
| Dinner | Quay | Fine dining, harbour views | $250-350 |

**Day 2: Multicultural Eats**

| Meal | Restaurant | Style | Budget |
|------|------------|-------|--------|
| Breakfast | Ho Jiak | Malaysian roti, coffee | $20-30 |
| Lunch | Mr Wong | Cantonese, CBD | $50-80 |
| Dinner | Firedoor | Fire-cooked, Surry Hills | $180-250 |

**Day 3: Inner Suburbs Crawl**

| Time | Stop | What to Get |
|------|------|-------------|
| 9:00 | Reuben Hills (Surry Hills) | Specialty coffee |
| 10:30 | Bourke Street Bakery | Pastries, sausage roll |
| 12:00 | Ester (Chippendale) | Wood-fired lunch |
| 15:00 | Gelato Messina | Italian gelato |
| 17:00 | 10 William Street | Natural wine, snacks |
| 20:00 | Sixpenny (Stanmore) | 3-hat degustation |

**Book Ahead**
- Quay, Bennelong, Sixpenny: 4-6 weeks
- Firedoor, Saint Peter: 2-3 weeks
- Popular weekend brunches: Walk-in early or book

---

### 🏖️ Nature & Beaches (3 Days)

**Day 1: Eastern Beaches**
- Morning: Bondi Beach, swim at Icebergs Pool
- Midday: Bondi to Bronte walk
- Afternoon: Bronte Beach, rock pool
- Sunset: Tamarama Beach

**Day 2: Northern Beaches**
- Morning: Manly Beach, Shelly Beach snorkeling
- Midday: Freshwater Beach
- Afternoon: Curl Curl rock pools
- Evening: Ferry back, harbour views

**Day 3: Royal National Park**
- Morning: Coast Track from Bundeena
- Midday: Marley Beach picnic
- Afternoon: Wattamolla lagoon swim
- Evening: Bundeena ferry back via Cronulla

**What to Pack**
- Reef-safe sunscreen
- Snorkel gear (or hire)
- Rash vest (bluebottles possible in summer)
- Water shoes for rock pools
- Dry bag for valuables

---

### 🎨 Art & Culture (3 Days)

**Day 1: Major Institutions**

| Time | Venue | Highlights | Cost |
|------|-------|------------|------|
| 10:00 | Art Gallery of NSW | Free collection + Sydney Modern | Free |
| 13:00 | Museum of Contemporary Art | Rooftop, harbour art | Free |
| 15:00 | Sydney Opera House | Architecture tour | $47 |
| 19:00 | Performance | Opera, ballet, or concert | $70-300 |

**Day 2: Alternative Art Scene**

| Time | Venue | Location |
|------|-------|----------|
| 10:00 | Brett Whiteley Studio | Surry Hills |
| 12:00 | White Rabbit Gallery | Chippendale (Chinese contemporary) |
| 14:00 | Carriageworks | Redfern (arts precinct) |
| 16:00 | Newtown street art | Self-guided walk |
| 19:00 | Enmore Theatre | Live music/comedy |

**Day 3: Indigenous & History**

| Time | Venue | Focus |
|------|-------|-------|
| 10:00 | Australian Museum | First Nations galleries |
| 13:00 | The Rocks Discovery Museum | Colonial history |
| 15:00 | Dreamtime Aboriginal Tour | The Rocks |
| 17:00 | State Library NSW | Free exhibitions |

**Art Gallery of NSW** (Free entry)
- Open daily 10am-5pm, Wed until 10pm
- Sydney Modern extension – contemporary spaces
- Yiribana Gallery – largest Indigenous art collection

**Must-Book**
- Opera House performances: 2-8 weeks ahead
- Popular exhibitions: Check for timed entry

---

### 👨‍👩‍👧‍👦 Family with Kids (3 Days)

**Day 1: Harbour & Wildlife**

| Time | Activity | Ages | Cost |
|------|----------|------|------|
| 9:30 | Taronga Zoo ferry | All | $35-57 |
| 9:30-14:00 | Zoo (5 hours) | All | Incl. |
| 14:30 | Circular Quay | All | Free |
| 15:00 | The Rocks | All | Free |
| 16:00 | Ice cream break | All | $8-12 |
| 17:00 | Return to hotel | All | |

**Day 2: Darling Harbour**

| Time | Activity | Ages | Cost |
|------|----------|------|------|
| 10:00 | SEA LIFE Aquarium | All | $46-52 |
| 12:00 | Lunch at Darling Harbour | All | $40-60 |
| 13:30 | WILD LIFE Zoo | 3-12 | $42-48 |
| 15:30 | Kids Playground (Darling Quarter) | 2-12 | Free |
| 17:00 | Tumbalong Park | All | Free |

**Day 3: Beaches**

| Time | Activity | Ages | Tips |
|------|----------|------|------|
| 9:00 | Manly ferry | All | Kids love ferries! |
| 10:00 | Shelly Beach | All | Calm water, snorkeling |
| 12:00 | Fish & chips | All | The Boathouse |
| 14:00 | Manly main beach | 5+ | Flags only |
| 16:00 | The Corso shops | All | Ice cream, souvenirs |

**Family Tips**
- **Combo tickets**: SEA LIFE + WILD LIFE + Madame Tussauds saves ~30%
- **Opal**: Children under 4 travel free
- **Beaches**: Always swim between red and yellow flags
- **Prams**: Most attractions accessible, except some bush walks
- **Nappies/feeding**: Facilities at all major attractions

**Kid-Friendly Restaurants**
- **Pancakes on the Rocks** – all-day pancakes, kid portions
- **Coogee Pavilion** – rooftop playground while parents dine
- **Fish Market** – casual, pick your own
- **Gelato Messina** – 40+ flavours, kid-approved

---

### 📸 Photography Spots (Best Times)

**Sunrise (5:30-7:00am summer)**
| Location | What to Capture |
|----------|-----------------|
| Mrs Macquarie's Chair | Opera House + Bridge together |
| Bondi Beach | Golden light on cliffs |
| Bradleys Head | City skyline with Opera House |
| Manly (east side) | First light on beach |

**Golden Hour/Sunset (5:30-7:30pm summer)**
| Location | What to Capture |
|----------|-----------------|
| Opera Bar | Opera House lit up |
| Kirribilli | Classic harbour shot |
| Blues Point Reserve | Bridge + city |
| Dudley Page Reserve | Harbour panorama |
| The Rocks | Historic laneways |

**Night (8:00pm+)**
| Location | What to Capture |
|----------|-----------------|
| Circular Quay | Light trails, reflections |
| Milsons Point | Bridge + Luna Park |
| Observatory Hill | City lights |
| Darling Harbour | Reflections |

**Unique Shots**
- **Bondi Icebergs**: Ocean pool with waves crashing (early morning)
- **Watsons Bay**: Opera House through Gap cliffs (sunset)
- **Barangaroo Reserve**: Sandstone + modern architecture
- **Queen Victoria Building**: Historic interior (anytime)
- **The Grounds of Alexandria**: Photogenic cafe (morning light)

**Drone Rules** (Australia)
- Register if over 250g
- Not within 30m of people
- Not over beaches, crowds, or 5.5km from airports
- Check CASA website for current rules

---

## Booking Requirements Summary

### Book 4-6 Weeks Ahead
- BridgeClimb (especially sunset/dawn climbs)
- Fine dining: Quay, Bennelong, Sixpenny, Firedoor
- Sydney Opera House performances
- Hunter Valley overnight stays (weekends)

### Book 1-2 Weeks Ahead
- Popular restaurants (Saint Peter, Ester, Fred's)
- Opera House tours (especially weekends)
- Blue Mountains tours (in season)
- Taronga experiences (keeper encounters)

### Book Day Before or Walk-In
- Scenic World Blue Mountains
- Taronga Zoo general entry
- Casual dining most places
- Beach activities (surf lessons, kayak hire)

### No Booking Needed
- Bondi to Coogee walk
- All beaches
- The Rocks Markets (weekends)
- Art Gallery of NSW
- Most museum general entry
- Royal Botanic Garden

---

## Monthly Events & Timing

| Month | Events | Weather |
|-------|--------|---------|
| Jan | Sydney Festival, NYE recovery | Hot (25-30°C) |
| Feb | Sydney Mardi Gras (late Feb) | Hot, humid |
| Mar | Mardi Gras Parade | Warm (22-27°C) |
| Apr | Sydney Royal Easter Show | Mild (18-24°C) |
| May | Vivid Sydney starts | Cool (14-20°C) |
| Jun | Vivid Sydney | Cool, whale season starts |
| Jul | Winter, whale watching peak | Cool (10-17°C) |
| Aug | City2Surf fun run | Cool, whale watching |
| Sep | Sculpture by the Sea (Bondi) | Warming (15-22°C) |
| Oct | Jacaranda season starts | Warm (17-24°C) |
| Nov | Jacarandas peak | Warm (18-25°C) |
| Dec | Holiday crowds, beach season | Hot (22-28°C) |

**Best Times to Visit**
- **Mar-May**: Mild weather, fewer crowds, autumn colours
- **Sep-Nov**: Spring, jacarandas, whale watching ends
- **Avoid**: Dec 26-Jan 15 (school holidays, peak prices)

---

## Emergency & Practical Info

### Emergency Numbers
- **Emergency (police, fire, ambulance)**: 000
- **Non-emergency police**: 131 444
- **Surf Life Saving**: 1300 737 738

### Beach Safety
- Always swim between red and yellow flags
- Bluebottles common in summer – vinegar at lifeguard stations
- Rips: Don't fight current, swim parallel to beach
- Check conditions: beachsafe.org.au

### Health
- **Sunscreen**: Essential year-round, SPF 50+ recommended
- **Water**: Tap water safe and excellent
- **Pharmacies**: Chemist Warehouse (budget), Priceline common

### WiFi
- Free WiFi in CBD (CityofSydney WiFi)
- Most cafes offer free WiFi
- Telstra Air hotspots widespread

### Tipping
- Not expected in Australia
- 10% for exceptional service appreciated but never required

---

*Last updated: February 2026. Prices subject to change. Always verify current pricing and opening hours before visiting.*
