# Sydney Visitor Attractions

> Complete guide to Sydney's must-see attractions, hidden gems, and what to skip. Prices in AUD (February 2026).

---

## 🏛️ MUST-SEE ATTRACTIONS

### Sydney Opera House

**Address:** Bennelong Point, Sydney NSW 2000  
**Hours:** Tours daily 9am-5pm; performances vary  
**Website:** sydneyoperahouse.com

#### Tour Options

| Tour Type | Duration | Price | Best For |
|-----------|----------|-------|----------|
| **Opera House Tour** | 1 hour | $49 adult / $32 child | First-timers, general overview |
| **Backstage Tour** | 2 hours | $185 | Theatre enthusiasts, behind-the-scenes access |
| **Taste of Australia** | 2.5 hours | $215 | Foodies wanting tour + dining |
| **Junior Tour** | 1 hour | $28 | Families with kids 5-12 |

**Languages:** Tours available in English, Mandarin, Japanese, French, German, Spanish, Korean

#### Best Views of the Opera House
1. **Mrs Macquaries Chair** — Classic postcard shot with Opera House + Harbour Bridge together (FREE)
2. **Circular Quay East** — Close-up views from the waterfront promenade (FREE)
3. **Opera Bar** — Sunset drinks with Opera House backdrop (drinks $15-25)
4. **Cahill Expressway Lookout** — Elevated view, uncrowded
5. **Kirribilli/Milsons Point** — Ferry over for different angle (FREE with Opal)

#### Ticket Tips
- **Book online in advance** — Tours sell out, especially weekends and holidays
- **Attend a performance** — Often cheaper than tours, plus you see the interior properly. Check "Under $50" section on website
- **Free exterior access** — You can walk around Bennelong Point anytime for free
- **Sunset timing** — Late afternoon tours get best lighting for photos

#### Where to Eat
- **Opera Bar** — Waterfront drinks, casual ($$$)
- **Bennelong** — Peter Gilmore's fine dining under the sails ($$$$)
- **House Canteen** — Casual all-day dining ($$)

---

### Sydney Harbour Bridge

**Free access:** Pedestrian walkway 24/7 (eastern side)  
**Bike path:** Western side  

#### Climb Options Comparison

| Experience | Duration | Price Range | What You Get |
|------------|----------|-------------|--------------|
| **BridgeClimb Summit** | 3.5 hours | $294-$458 | Full climb to 134m summit |
| **BridgeClimb Express** | 2.5 hours | $218-$288 | Shorter route, inner arch |
| **BridgeClimb Sampler** | 1.5 hours | $174 | Intro experience, doesn't reach summit |
| **Burrawa (First Nations)** | 3.5 hours | $478+ | Indigenous storytelling at summit |
| **Pylon Lookout** | Self-paced | CLOSED until late 2026 | Museum + views at 87m |

**⚠️ Note:** Pylon Lookout is undergoing major renovations throughout 2026 — reopening late 2026 as immersive museum experience.

#### BridgeClimb Tips
- **Dawn/Twilight climbs** cost more but offer spectacular light
- **Midweek climbs** are cheaper than weekends
- **No loose items allowed** — everything attached or stored
- **Minimum age:** 8 years for Express, 10 years for Summit
- **Book 2-3 weeks ahead** in peak season (Dec-Feb)

#### Free Bridge Experiences
- **Walk across** — 30-40 mins each way, eastern pedestrian path
- **Cycle across** — Hire from Bonza Bikes (~$35/2hrs includes ride)
- **View from The Rocks** — Argyle Cut, Dawes Point Park
- **View from Kirribilli** — Take ferry, walk back via walkway

---

### Taronga Zoo

**Address:** Bradleys Head Rd, Mosman NSW 2088  
**Hours:** 9:30am - 5pm daily  
**Website:** taronga.org.au

#### Getting There
- **Ferry from Circular Quay** — 12 mins, $7.65 adult (Opal card)
- **Sky Safari cable car** from ferry wharf to top entrance — included with zoo entry
- **Bus 247** from Wynyard via Military Rd

#### Tickets

| Ticket Type | Adult | Child (4-15) | Notes |
|-------------|-------|--------------|-------|
| **General Entry** | $52 | $31 | Online price (save 20%) |
| **Gate Price** | $65 | $39 | Avoid if possible |
| **Zoo Friends Annual** | $120 | $72 | Pays off in 2-3 visits |

#### Highlights
- **Platypus House** — One of few places to see platypus
- **Seal Show** — Daily, free with entry
- **Giraffe encounter** — $95 extra, includes feeding
- **Koala Encounter** — $35 for photo with koala
- **Wild Ropes** — High ropes course, separate ticket ($49)

#### Pro Tips
- **Enter from TOP** (ferry + Sky Safari) — Zoo is on hillside, easier walking downhill
- **Arrive at opening (9:30am)** — Animals most active, less crowded
- **Keeper talks** throughout day — check app/website for schedule
- **Bring lunch** — Zoo food is expensive and average
- **Allow 4-5 hours** for full experience

#### Overnight Stays
- **Roar & Snore** — Safari tents, from $399/adult
- **Wildlife Retreat** — Eco-luxury lodges, from $850/night

---

### Bondi Beach

**Address:** Queen Elizabeth Dr, Bondi Beach NSW 2026  
**Access:** Bus 333 from Circular Quay (40 mins) or train to Bondi Junction + 380/381 bus

#### Best Times to Visit
| Season | Crowd Level | Water Temp | Notes |
|--------|-------------|------------|-------|
| **Summer (Dec-Feb)** | PACKED | 21-24°C | Avoid weekends if possible |
| **Autumn (Mar-May)** | Moderate | 19-22°C | Best balance of weather + space |
| **Winter (Jun-Aug)** | Quiet | 17-18°C | Locals only, great for walks |
| **Spring (Sep-Nov)** | Building | 18-21°C | Whale watching season |

**Best time of day:** Before 8am (locals exercising), or after 4pm (crowds leave)

#### Bondi to Coogee Coastal Walk

**Distance:** 6km one-way  
**Time:** 1.5-2 hours walking  
**Difficulty:** Easy-moderate (some stairs)  
**Cost:** FREE

**Route Highlights:**
1. **Bondi Beach** — Start at south end near Icebergs
2. **Icebergs Pool** — Famous ocean pool (swim entry $9)
3. **Tamarama Beach** — "Glamarama" — small, beautiful
4. **Bronte Beach** — Great cafe scene, rock pool
5. **Waverley Cemetery** — Clifftop graves, eerily beautiful
6. **Clovelly Beach** — Protected bay, great snorkeling
7. **Gordons Bay** — Underwater nature trail
8. **Coogee Beach** — End point, good restaurants

**Tips:**
- Walk **south to north** (Coogee to Bondi) for best photos (sun behind you in morning)
- **Sculpture by the Sea** (Oct-Nov) — Free outdoor art exhibition along route
- Bring water, sunscreen, hat — no shade on much of walk
- Can do partial walk (Bondi-Bronte is most scenic section)

#### Swimming Spots
- **North Bondi** — Less crowded, good for kids
- **South Bondi** — Near Icebergs, more experienced swimmers
- **Icebergs Pool** — Ocean pool, $9 entry, iconic photos

---

### The Rocks

**Address:** The Rocks, Sydney NSW 2000  
**Getting there:** Circular Quay station, 2-min walk

#### History
Australia's oldest European neighbourhood. First Fleet landed at nearby Sydney Cove in 1788. Was a notorious slum until 1970s redevelopment saved the heritage buildings.

#### The Rocks Markets

| Market | When | What |
|--------|------|------|
| **The Rocks Markets** | Sat-Sun 10am-5pm | 150+ stalls: art, craft, fashion, food |
| **The Rocks Foodie Market** | Fri 9am-3pm | Local produce, ready-to-eat food |
| **The Rocks Twilight Markets** | Selected summer Fridays | Evening food & entertainment |

**Best stalls:** Handmade jewelry, Aboriginal art, local honey

#### Best Pubs (Historic)
| Pub | Established | Vibe |
|-----|-------------|------|
| **The Lord Nelson** | 1841 | Oldest pub, brews own beer |
| **Fortune of War** | 1828 | Claims "oldest pub" title |
| **The Hero of Waterloo** | 1843 | Live music, underground tunnels |
| **The Glenmore** | 1921 | Rooftop with bridge views |
| **The Australian Heritage Hotel** | 1913 | 100+ beers, pizza with native toppings |

#### Free Activities
- **Wander cobblestone lanes** — Argyle Street, Nurses Walk, Suez Canal
- **Sydney Observatory views** — Great sunset spot (observatory tours extra)
- **Cadmans Cottage** — Oldest surviving house in Sydney (1816)

#### Walking Tours
- **The Rocks Walking Tours** — 90 mins, $35 adult, daily departures
- **Ghost tours** — Evening, $45, theatric exploration of convict history

---

### Royal Botanic Garden

**Address:** Mrs Macquaries Rd, Sydney NSW 2000  
**Hours:** 7am-sunset daily (varies by season)  
**Entry:** FREE

#### Highlights
- **Mrs Macquaries Chair** — Best combined Opera House + Bridge photo spot
- **The Calyx** — Stunning exhibition space with "living wall"
- **Herb Garden** — Near restaurants
- **Palm Grove** — Magnificent avenue of palms
- **Rose Garden** — Peak bloom Oct-Nov
- **Flying Fox colony** — Near duck pond (controversial but fascinating)

#### Tours
| Tour | Duration | Price |
|------|----------|-------|
| **Free Guided Walk** | 1.5 hours | FREE — daily at 10:30am |
| **Aboriginal Heritage Tour** | 1.5 hours | $49 | Learn Gadigal connection to plants |
| **Choo Choo Express** | 25 mins | $12 adult | Trackless train for tired legs |

#### Tips
- **Start from Opera House end** — Walk through to The Domain
- **Morning light** — Best photography 7-9am
- **BYO picnic** — Beautiful lawns throughout
- **Art Gallery of NSW** — Adjacent, also free entry
- **Watch for ibis** — They WILL steal your lunch

---

### Darling Harbour

**Location:** Western edge of CBD  
**Getting there:** Light rail, monorail, or 10-min walk from Town Hall

#### Worth It ✅

| Attraction | Price | Duration | Why |
|------------|-------|----------|-----|
| **SEA LIFE Sydney** | $44 online | 2-3 hrs | Great aquarium, dugongs |
| **WILD LIFE Sydney** | $44 online | 1.5 hrs | Native animals if skipping zoo |
| **Australian National Maritime Museum** | FREE (exhibitions extra) | 2 hrs | Ships, submarines to explore |
| **Chinese Garden of Friendship** | $6 | 1 hr | Peaceful escape |
| **Harbourside walking** | FREE | 1 hr | Evening atmosphere, fireworks Sat 9pm |

#### Tourist Traps ⚠️

| Avoid | Why |
|-------|-----|
| **Madame Tussauds** | $44 for wax figures, very skippable |
| **Darling Harbour restaurants** | Overpriced, mediocre food at most waterfront spots |
| **Monorail** | Defunct, was never worth it anyway |
| **Paddle boats** | $35/30min, waste of money |

#### Better Food Options
- **Sydney Fish Market** (10-min walk) — Fresh seafood, way better value
- **Barangaroo** (north end) — Quality restaurants
- **Haymarket/Chinatown** (east side) — Cheap, authentic Asian food

---

### Blue Mountains Day Trip

**Distance from Sydney:** 100km west (~1.5 hours by car/train)  
**Train:** Central to Katoomba, $8.50 Opal (2+ hours)

#### Must-See Essentials

**Three Sisters**
- **Address:** Echo Point Rd, Katoomba
- **Entry:** FREE
- **Best time:** Sunrise for fewer crowds, sunset for golden light
- **Giant Stairway** — 800+ steps down (free but challenging!)

**Scenic World**
- **Price:** $50 adult / $28 child (Discovery Pass, all 4 rides)
- **Rides:** Skyway, Cableway, Railway (world's steepest), Walkway
- **Time needed:** 2-3 hours
- **Book online** to save 10%

**Wentworth Falls**
- **Distance from car park:** 30-min walk
- **Entry:** FREE (national park)
- **Swimming:** Yes, at base of falls (check conditions)

**Leura Village**
- **What:** Cute town with cafes, antique shops
- **Distance:** 2km from Katoomba
- **Worth it:** Good lunch stop, gardens

#### Day Trip Itinerary
| Time | Activity |
|------|----------|
| 7:30am | Train from Central Station |
| 9:45am | Arrive Katoomba, walk to Echo Point |
| 10:00am | Three Sisters viewing + Giant Stairway |
| 12:00pm | Scenic World rides |
| 2:30pm | Lunch in Leura |
| 4:00pm | Wentworth Falls (optional) |
| 5:30pm | Train back to Sydney |

#### Tour vs DIY
| Method | Cost | Pros | Cons |
|--------|------|------|------|
| **DIY Train** | ~$25 total | Cheaper, flexible | Miss some spots |
| **Group Tour** | $120-180 | Includes transport, guide, Scenic World | Less time at sites |
| **Private Tour** | $400+ | Customized, door-to-door | Pricey |

**Verdict:** If short on time, take a tour. If flexible, DIY is rewarding.

---

## 💎 HIDDEN GEMS

### Barangaroo Reserve

**Address:** Barangaroo Reserve, Sydney NSW 2000  
**Entry:** FREE  
**Hours:** 24/7

An urban headland park built from scratch with 75,000 native plants. Named after a powerful Cammeraygal woman from First Fleet era.

**Highlights:**
- **Nawi Cove** — Harbour swimming enclosure (netted)
- **Marrinawi Cove** — Beach swimming spot
- **The Cutaway** — Underground arts/events space
- **Wulugul Walk** — Waterfront promenade to Darling Harbour

**Pro tip:** Catch sunset from the tip of the headland — spectacular views to Harbour Bridge without tourist crowds.

---

### Wendy's Secret Garden

**Address:** Lavender Street, Lavender Bay NSW 2060  
**Entry:** FREE  
**Hours:** Dawn to dusk

A magical hidden garden created by Wendy Whiteley (widow of artist Brett Whiteley) over 30+ years from an abandoned railway cutting.

**Getting there:** Train to Milsons Point, 5-min walk down Clark Road
**Best time:** Morning for light through trees
**Combine with:** Luna Park, Harbour Bridge walk

**Why locals love it:** Zero crowds, feels like discovering a secret, stunning harbour glimpses through foliage

---

### Watsons Bay

**Address:** Watsons Bay, NSW 2030  
**Getting there:** Ferry from Circular Quay (35 mins, $7.65 Opal)

Historic fishing village on South Head peninsula. Day trip feeling, 20 mins from city.

**Do:**
- **The Gap** — Dramatic clifftop lookout
- **South Head Heritage Trail** — Walk to Hornby Lighthouse
- **Camp Cove** — Protected harbour beach, calm water
- **Doyles on the Beach** — Fish & chips since 1885 ($$$)
- **Watsons Bay Beach Club** — Sunset beers, pub vibes

**Don't:** Skip the ferry — the journey IS the attraction

---

### Manly Beach & Surrounds

**Address:** Manly NSW 2095  
**Getting there:** Ferry from Circular Quay (30 mins)

**Not exactly hidden**, but far superior to Bondi for many reasons:
- Less pretentious, more local vibe
- Bigger beach, better waves
- Easy ferry access (no buses!)
- Quieter side beaches nearby

**Worth Exploring:**
| Spot | Walk from Ferry | Why |
|------|-----------------|-----|
| **Manly Beach** | 5 min via The Corso | Main event, 3km of sand |
| **Shelly Beach** | 20 min | Calm, great snorkeling |
| **Fairy Bower Pool** | 15 min | Ocean rock pool, kid-friendly |
| **Spit to Manly Walk** | Ends at ferry | 10km bushwalk with harbour views |
| **Store Beach** | Kayak only | Secret penguin beach |
| **North Head** | 30 min/bus | Historic military fortifications |

**Best day:** Ferry over, walk The Corso, swim, lunch at The Boathouse Shelly Beach, walk to Shelly Beach, ferry back

---

### Newtown

**Address:** King Street, Newtown NSW 2042  
**Getting there:** Train to Newtown station (10 mins from Central)  
**Entry:** FREE

Sydney's alternative heart. Graffiti, vintage shops, LGBTQ+ venues, incredible food diversity.

**Food Highlights:**
| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Colombo Social** | Sri Lankan fusion | $$ |
| **Mary's** | Burgers, dive bar | $$ |
| **Continental Deli** | Tinned fish, natural wine | $$$ |
| **Cairo Takeaway** | Egyptian street food | $ |
| **Thai Pothong** | Thai classics | $$ |

**Bars:**
- **Corridor** — Craft cocktails
- **Earl's Juke Joint** — Live music, whisky
- **Young Henrys Brewery** — Local craft beer, tours available
- **The Courthouse Hotel** — Classic Aussie pub garden

**Other:**
- **Gould's Book Arcade** — Massive secondhand bookstore, labyrinthine
- **Enmore Theatre** — Live music venue (check listings)
- **Street art walking** — Self-guided, throughout King Street

---

### Paddington Markets

**Address:** 395 Oxford Street, Paddington NSW 2021  
**When:** Saturday 10am-4pm only  
**Entry:** FREE

The original Sydney markets (since 1973). Handmade focus, less touristy than The Rocks.

**Why go:**
- **Local designers** — Jewelry, fashion, ceramics
- **Food stalls** — Quality not quantity
- **Paddington itself** — Victorian terrace houses, great cafes
- **Vibe** — More local, less "tourist market" feeling

**Combine with:**
- **Oxford Street shops** — Boutiques, not chains
- **Victoria Barracks** — Free tours Thursday 10am
- **Centennial Park** — 10-min walk, massive green space

---

### Camp Cove

**Address:** Victoria Street, Watsons Bay NSW 2030  
**Entry:** FREE  
**Getting there:** Ferry to Watsons Bay, 5-min walk

Small, sheltered harbour beach that feels secret but isn't hard to reach.

**Why visit:**
- **Calm water** — Great for kids and nervous swimmers
- **Views** — Harbour Bridge and Opera House in distance
- **Not crowded** — Even summer weekends manageable
- **Combine** with Watsons Bay lunch/walk to The Gap

**Nearby:** Lady Bay Beach (clothing optional) — 5 min further walk if adventurous

---

### Palm Beach (Summer Bay)

**Address:** Palm Beach NSW 2108  
**Getting there:** Bus L90 from Wynyard (75-90 mins)

The northern tip of Sydney's beaches. Yes, it's where Home and Away is filmed.

**Why go:**
- **Barrenjoey Lighthouse** — Hike or steep stairs, panoramic views
- **Ku-ring-gai Chase National Park** — Adjacent bushland
- **Two beaches** — Ocean side (surf), Pittwater side (calm)
- **Boat hire** — Explore Pittwater, picnic on islands
- **The Boathouse Palm Beach** — Famous waterfront restaurant

**Downsides:**
- Long commute (not worth it for half-day)
- Expensive area (bring your own food)

**Best as:** Full day trip, especially in autumn/spring

---

## 🚫 TOURIST TRAPS TO SKIP

### Overrated Spots

| Attraction | Why Skip | Better Alternative |
|------------|----------|-------------------|
| **Madame Tussauds** | $44 for wax figures. Why? | Any free gallery |
| **Sydney Tower Eye** | $30 for views. Expensive and commercial | Pylon Lookout (when open) or free lookouts |
| **Luna Park rides** | Tired carnival rides, $50+ passes | Just walk around for free, take photos |
| **Bondi on weekends** | Overcrowded, parking nightmare | Go weekday AM, or try Manly/Coogee |
| **Harbourside shopping** | Generic chains, tourist markup | QVB, Strand Arcade, Paddington |
| **Big Bus Tours** | $50+, slow, impersonal | Use public ferries, walk, way better |
| **Sydney Aquarium + Wildlife combo** | $80 for both, each is mediocre | Choose ONE, or just do Taronga Zoo |

### Overpriced Experiences

| Experience | Price | Reality Check |
|------------|-------|---------------|
| **Helicopter tours** | $250-600 | 15-30 mins, feels rushed |
| **Dinner cruises** | $100-200 | Food mediocre, better to eat on land |
| **Beach umbrellas rental** | $30-50/day | Bring from Kmart ($15) |
| **Bondi Icebergs entry** | $9 | Worth it once for photos, but pool is just a pool |
| **Segway tours** | $100+ | Walking is free and less embarrassing |

### When to Skip Attractions

| Attraction | Skip When |
|------------|-----------|
| **Bondi Beach** | Summer weekends, public holidays |
| **The Rocks Markets** | First hour (still setting up) |
| **Opera House tours** | Cruise ship days (check schedule) |
| **Taronga Zoo** | School holidays without booking |
| **Blue Mountains** | Rainy/foggy days (no views) |
| **Any ferry trip** | Peak commute times (7-9am, 5-7pm weekdays) |

---

## 📸 BEST PHOTO SPOTS

### Free Iconic Shots

| Location | Best Time | What You'll Get |
|----------|-----------|-----------------|
| **Mrs Macquaries Chair** | Sunrise | Opera House + Bridge together |
| **Milsons Point** | Golden hour | Opera House across water |
| **Dawes Point** | Any time | Under the Bridge looking to Opera House |
| **Blues Point Reserve** | Sunset | City skyline panorama |
| **Circular Quay East** | Evening | Opera House lit up |
| **North Head** | Morning | All of Sydney in one frame |

### Instagram Spots

| Location | The Shot |
|----------|----------|
| **Bondi Icebergs** | Pool with ocean backdrop |
| **Wendy's Secret Garden** | Whimsical greenery, harbour glimpses |
| **The Grounds of Alexandria** | Cafe interiors, flowers |
| **Angel Place** | Bird cages art installation (CBD laneway) |
| **QVB interior** | Victorian architecture |
| **Paddington terraces** | Rainbow houses on Gurner Street |

---

## 🆓 FREE ACTIVITIES

### Completely Free

- **Walk across Sydney Harbour Bridge** — Pedestrian path, any time
- **Royal Botanic Garden** — All day, guided tours at 10:30am
- **Art Gallery of NSW** — Permanent collection (some exhibitions ticketed)
- **Bondi to Coogee Walk** — 6km coastal track
- **The Rocks** — Wander historic streets, markets viewing
- **Museum of Contemporary Art** — Free entry, Circular Quay
- **Barangaroo Reserve** — Urban parkland, harbour swimming
- **Wendy's Secret Garden** — Hidden gem, Lavender Bay
- **Watch ferry traffic** — Circular Quay, surprisingly entertaining
- **Taronga Zoo views** — Ferry ride gives zoo views without entry
- **Sunday morning markets** — Glebe, Rozelle, Paddington (browsing free)

### Free Events (Check Schedules)

- **Vivid Sydney** (May-June) — Light installations throughout city
- **New Year's Eve fireworks** — Harbour foreshore (arrive EARLY)
- **Australia Day** (Jan 26) — Harbour events
- **Art After Hours** (Wed) — Art Gallery of NSW until 10pm
- **Outdoor cinema previews** — Sometimes free first screenings

---

## 💰 BUDGET TIPS

### Transport Savings

| Tip | Savings |
|-----|---------|
| **Get an Opal card** | Cheaper than single tickets |
| **$50 weekly cap** | After $50 spend, travel is free |
| **Sunday $2.90 cap** | Unlimited travel for $2.90 |
| **Walk between CBD attractions** | Opera House to The Rocks = 15 mins |
| **Use ferries** | Same price as bus, but scenic |

### Food Savings

| Strategy | Where |
|----------|-------|
| **Avoid Circular Quay restaurants** | Tourist pricing, mediocre food |
| **Chinatown for cheap eats** | $12-18 for filling meals |
| **Fish Market for seafood** | Cheaper than waterfront restaurants |
| **BYO restaurants** | Newtown, Surry Hills have many (save on drinks) |
| **Supermarket picnic** | Coles/Woolworths everywhere, eat in parks |
| **Happy hour drinks** | 4-6pm at most bars, half-price |

### Combo Deals & Passes

| Pass | Price | Includes | Worth It? |
|------|-------|----------|-----------|
| **Sydney Attractions Pass** | $149-229 | 3-4 attractions | Only if doing everything |
| **iVenture Card** | $145+ | Flexible credits | Maybe for families |
| **Taronga + Ferry combo** | ~$60 | Zoo + return ferry | Yes, small savings |

**General rule:** Most "combo deals" assume you'll visit EVERYTHING. Better to choose 2-3 things and pay individually.

---

## ⏰ OPENING HOURS PATTERNS

### Early Openers (7am-8am)
- Royal Botanic Garden
- Bondi Beach (lifeguards from 7am summer)
- Most beaches

### Standard (9:30am-10am)
- Taronga Zoo (9:30am)
- Opera House tours (9am)
- Most museums (10am)
- The Rocks Markets (10am)

### Late/Evening
- Art Gallery of NSW (Wed until 10pm)
- Darling Harbour restaurants (until 10-11pm)
- The Rocks pubs (until midnight+)

### Days to Note
- **Monday:** Many restaurants closed
- **Tuesday:** Some galleries closed (MCA)
- **Sunday:** Reduced hours, but markets active
- **Public holidays:** Check everything — hours vary wildly

---

## 🗺️ AREA QUICK REFERENCE

| Area | Getting There | Best For | Time Needed |
|------|---------------|----------|-------------|
| **Circular Quay** | Train/ferry | Opera House, ferries, The Rocks | 3-4 hours |
| **The Rocks** | Walk from Quay | History, markets, pubs | 2-3 hours |
| **Darling Harbour** | Light rail/walk | Aquarium, kids, waterfront dining | 2-4 hours |
| **Bondi** | Bus 333 | Beach, coastal walk | Half-full day |
| **Manly** | Ferry | Beach, laid-back vibes | Half-full day |
| **Newtown** | Train | Food, bars, alternative culture | Evening |
| **Surry Hills** | Walk from Central | Coffee, brunch, boutiques | 2-3 hours |
| **Paddington** | Bus from city | Markets (Sat), Victorian houses | 2-3 hours |
| **Blue Mountains** | Train | Nature, Three Sisters, bushwalks | Full day |

---

*Last updated: February 2026*
