# Australian Visas Guide
*For Sydney/Australia - Updated February 2026*

> ⚠️ **Always verify current rules at [immi.homeaffairs.gov.au](https://immi.homeaffairs.gov.au)** - visa rules change frequently.

---

## 1. Tourist/Visitor Visas

### ETA - Electronic Travel Authority (Subclass 601)
- **For:** US, Canada, Japan, South Korea, Singapore, Malaysia, Brunei, Hong Kong SAR
- **Apply:** Via Australian ETA app (smartphone only)
- **Cost:** AUD $20
- **Stay:** Up to 3 months per visit
- **Validity:** 12 months (multiple entries)
- **Processing:** Usually within minutes
- **Work:** ❌ Not permitted
- **Study:** Up to 3 months allowed

### eVisitor (Subclass 651)
- **For:** European citizens (EU + UK, Norway, Iceland, etc.)
- **Apply:** Online, free
- **Cost:** Free
- **Stay:** Up to 3 months per visit
- **Validity:** 12 months (multiple entries)
- **Processing:** 1-3 days typically
- **Work:** ❌ Not permitted (business activities OK)
- **Study:** Up to 3 months allowed

### Visitor Visa (Subclass 600)
- **For:** All other nationalities (or if 601/651 not available)
- **Streams:**
  - **Tourist Stream:** Holiday, visiting family
  - **Business Visitor:** Business meetings, conferences
  - **Sponsored Family:** Australian citizen/PR sponsors you
  - **Frequent Traveller:** Regular business visitors (by invitation)
- **Cost:** AUD $190-1,175 depending on stream
- **Stay:** 3, 6, or 12 months (some cases up to 10 years with 3-month stays)
- **Processing:** 1-4 weeks (can be longer)
- **Work:** ❌ Not permitted

**Key Point for Visitors:**
- Most Western countries → ETA or eVisitor (quick, cheap/free)
- Everyone else → Subclass 600 (more paperwork, longer wait)

---

## 2. Work Visas

### Temporary Skill Shortage (Subclass 482) - "TSS Visa"
**The main employer-sponsored work visa**

- **Streams:**
  - **Short-term:** Up to 2 years (some countries 4 years)
  - **Medium-term:** Up to 4 years, pathway to PR
  - **Labour Agreement:** Industry-specific arrangements
- **Requirements:**
  - Employer sponsors you
  - Job on Skilled Occupation List
  - Minimum 2 years relevant work experience
  - Skills assessment (for some occupations)
  - English: IELTS 5.0+ overall (varies by stream)
  - Minimum salary: AUD $73,150/year (2025 TSMIT threshold) ← *verify current amount*
- **Cost:** ~AUD $3,115 (worker) + sponsorship costs to employer
- **Path to PR:** Medium-term stream → eligible for 186 visa after 2-3 years
- **Processing:** 2-6 months typically

### Skilled Independent (Subclass 189)
**Points-tested, no sponsor needed, direct PR**

- **Key Features:**
  - Permanent residence immediately
  - No employer or state sponsor required
  - Invitation-based (submit EOI, wait for invite)
  - Must be under 45 at invite
- **Cost:** AUD $4,910 (+ partner/children fees)
- **Requirements:**
  - Skills assessment in occupation on MLTSSL
  - Competent English (IELTS 6.0+ each band minimum)
  - **Minimum 65 points** (realistically need 80-90+)
  - Age under 45
- **Processing:** 6-18 months after applying
- **Reality Check:** Very competitive. Tech, healthcare, engineering get invites. Many occupations rarely invited.

### Skilled Nominated (Subclass 190)
**State-sponsored, direct PR**

- **Key Features:**
  - Permanent residence immediately
  - State/territory nominates you
  - +5 points from state nomination
  - Must live in nominating state for 2 years
- **Cost:** AUD $4,910
- **Requirements:**
  - Same as 189 + state nomination
  - Occupation on state's nomination list
  - Meet state-specific requirements
  - **Minimum 65 points** (often 75-85+ competitive)
- **Processing:** 6-12 months typically
- **States:** NSW, VIC, QLD each have different priority occupations

### Skilled Work Regional (Subclass 491)
**Regional pathway to PR**

- **Key Features:**
  - 5-year provisional visa
  - Must live/work in regional Australia
  - +15 points (state nomination) or +15 points (family sponsorship)
  - Pathway to PR via 191 after 3 years
- **Regional Areas:** Everything except Sydney, Melbourne, Brisbane metro
- **Cost:** AUD $4,770
- **Requirements:**
  - Same points test as 189
  - State nomination OR eligible family sponsor in regional area
  - Occupation on regional lists
- **Processing:** 6-12 months
- **Path to PR:** Apply for 191 after 3 years + minimum income requirement

### Points System Explained

| Factor | Points |
|--------|--------|
| **Age** | |
| 18-24 | 25 |
| 25-32 | 30 |
| 33-39 | 25 |
| 40-44 | 15 |
| 45+ | 0 (ineligible for most skilled visas) |
| **English** | |
| Competent (IELTS 6.0) | 0 |
| Proficient (IELTS 7.0) | 10 |
| Superior (IELTS 8.0) | 20 |
| **Skilled Employment (in Australia)** | |
| 1-2 years | 5 |
| 3-4 years | 10 |
| 5-7 years | 15 |
| 8+ years | 20 |
| **Skilled Employment (overseas)** | |
| 3-4 years | 5 |
| 5-7 years | 10 |
| 8+ years | 15 |
| **Education** | |
| PhD | 20 |
| Bachelor's/Master's | 15 |
| Diploma/Trade | 10 |
| **Australian Study** | 5 |
| **Regional Study** | 5 |
| **Professional Year** | 5 |
| **NAATI Credentialing** | 5 |
| **State Nomination (190)** | 5 |
| **Regional Nomination (491)** | 15 |
| **Partner Skills** | 5-10 |
| **Single Applicant (no partner)** | 10 |

**Minimum:** 65 points to be eligible
**Reality:** Most invites go to 85-95+ points (highly competitive)

---

## 3. Working Holiday Visas

### Working Holiday (Subclass 417)
- **For:** Citizens of Belgium, Canada, Denmark, Estonia, Finland, France, Germany, Hong Kong SAR, Ireland, Italy, Japan, South Korea, Malta, Netherlands, Norway, Sweden, Taiwan, UK
- **Age:** 18-30 (35 for some countries: Canada, France, Ireland, Denmark)
- **Cost:** AUD $650
- **Stay:** 12 months initially

### Work and Holiday (Subclass 462)
- **For:** Argentina, Austria, Chile, China, Czech Republic, Ecuador, Greece, Hungary, Indonesia, Israel, Luxembourg, Malaysia, Peru, Poland, Portugal, San Marino, Singapore, Slovakia, Slovenia, Spain, Thailand, Turkey, Uruguay, USA, Vietnam
- **Age:** 18-30 (check specific country agreements)
- **Cost:** AUD $650
- **Extra:** Some countries require government letter of support

### Working Holiday Rules (Both)
- **Work:** Can work, but max 6 months with same employer
- **Study:** Up to 4 months allowed
- **Extensions:**
  - **2nd year:** Complete 88 days "specified work" (farm work, regional work, etc.)
  - **3rd year:** Complete additional 6 months specified work during 2nd year
- **Specified Work:** Regional farm work, hospitality in regional areas, bushfire recovery, construction in regional, etc.
- **Processing:** Usually 2-4 weeks
- **Apply:** From outside Australia

**Key Point:** Popular for young people to work in hospitality, fruit picking, etc. while traveling. Regional work = longer stay.

---

## 4. Student Visa (Subclass 500)

### Basic Requirements
- Enrolled in registered course (CRICOS)
- Genuine Temporary Entrant (GTE) requirement
- English proficiency (varies by course level)
- Health insurance (OSHC)
- Financial capacity (show funds or sponsor)

### Cost
- **Primary:** AUD $1,600
- **Partner:** AUD $1,600
- **Children:** AUD $405 each

### Work Rights

**Current Rules (as of mid-2024):**
- **During semester:** 48 hours per fortnight (increased from 40 hours)
- **During breaks:** Unlimited
- **Masters by Research/PhD:** Unlimited work

⚠️ **2024 Changes:** The 48-hour limit was made permanent after temporary COVID relaxations ended. Some sectors (aged care) may have special provisions.

### Post-Study Work Rights (Subclass 485)
After completing Australian study:

| Qualification | Duration |
|--------------|----------|
| Bachelor's | 2 years |
| Master's (Coursework) | 2 years |
| Master's (Research) | 3 years |
| PhD | 4 years |
| Priority occupations | +2 years bonus |
| Regional study | +1-2 years bonus |

**Requirements:**
- Completed 2+ years study in Australia
- Applied within 6 months of completing
- Under 50 years old
- Competent English

### Partner Rights
- Student visa primary holder can add partner
- Partner gets work rights (usually full-time)
- Masters/PhD students' partners: unlimited work
- Other levels: may have restricted hours (check conditions)

### Regional Study Benefits
- Study in regional area = extended post-study work rights
- Regional campuses count even if uni is in city

---

## 5. Partner & Family Visas

### Partner Visa (Subclass 820/801)
**For partners of Australian citizens/PRs**

- **Two stages:**
  - **820:** Temporary (immediate, allows work)
  - **801:** Permanent (after ~2 years together)
- **Relationship Proof:** Need extensive evidence (photos, financials, statutory declarations from friends/family)
- **De facto:** 12+ months cohabitation required (or registered relationship)
- **Cost:** AUD $9,095 ← *one of the most expensive visas*
- **Processing:** 
  - 820: 8-15 months (currently)
  - 801: 12-24 months after eligibility
- **Work:** Full rights while waiting

### Prospective Marriage (Subclass 300)
- For engaged couples
- Must marry within 9 months of arrival
- Then apply for 820/801 onshore

### Parent Visas

| Visa | Cost | Processing Time | Notes |
|------|------|-----------------|-------|
| **Parent (103)** | ~$5,000 | 29-50 YEARS | Not joking. Queue is decades. |
| **Aged Parent (804)** | ~$5,000 | 29-50 years | Must be in Australia |
| **Contributory Parent (143)** | ~$50,000+ | 5-8 years | Pay more, wait less |
| **Contributory Aged Parent (864)** | ~$50,000+ | 5-8 years | Must be in Australia |

**Reality Check:** Parent visas are either extremely expensive (~$50K each) OR extremely slow (decades). Many families choose tourist visas with multiple entries instead.

### Processing Times Reality
- Partner visas: Getting better (12-24 months typical now)
- Parent visas: Decades for standard, years for contributory
- Children visas: Relatively faster (6-12 months)

---

## 6. Permanent Residency (PR)

### Main Pathways to PR

| Current Visa | PR Pathway | Requirements |
|--------------|------------|--------------|
| 482 Medium-term | 186 (Employer Nom) | 2-3 years with employer |
| 491 Regional | 191 | 3 years + income threshold |
| 500 Student | 485 → 189/190 | Points + skills assessment |
| 820 Partner | 801 | 2 years relationship |
| 189/190 | Already PR | N/A |

### Points Requirements (Reality)
- **Minimum eligible:** 65 points
- **Competitive for 189:** 85-95+ points
- **Competitive for 190:** 75-85+ points (depends on state/occupation)
- **491 Regional:** 70-80+ points (depends on state)

### English Requirements

| Test | Competent | Proficient | Superior |
|------|-----------|------------|----------|
| IELTS | 6.0 each | 7.0 each | 8.0 each |
| PTE | 50 each | 65 each | 79 each |
| TOEFL iBT | L/R 12, W 21, S 18 | L/R 24, W 27, S 23 | L/R 28, W 30, S 26 |

**Exceptions:**
- UK, US, Canada, NZ, Ireland passport holders may not need test
- Some occupations require higher English

### Skills Assessment
Most skilled visas require assessment by relevant authority:

| Field | Assessing Authority |
|-------|---------------------|
| Engineering | Engineers Australia |
| IT | ACS (Australian Computer Society) |
| Accounting | CPA, CAANZ, IPA |
| Teaching | AITSL |
| Healthcare | AHPRA, ANMAC (nursing) |
| Trades | TRA |

Processing: 1-4 months depending on authority. Start this EARLY.

### Health & Character
- **Medical exam:** Required for most PR visas
- **Police clearances:** From all countries lived 12+ months since age 16
- **Character requirements:** No significant criminal record

---

## 7. Citizenship

### Eligibility Requirements
- **Residence:** 4 years in Australia (including 1 year as PR)
- **Presence:** Not absent more than 12 months total in 4 years, and not more than 90 days in final year
- **Good character:** Police check, no recent offenses
- **Age:** 18+ (children can be included in parent's application)

### Process
1. Check eligibility (residence calculator online)
2. Apply online
3. Citizenship test (if 18-59 years old)
4. Interview/approval
5. Attend ceremony (pledge of commitment)

### Citizenship Test
- 20 questions, multiple choice
- Pass mark: 75% (15/20)
- Topics: Australian values, history, government, symbols
- Study: Free official booklet "Australian Citizenship: Our Common Bond"
- Can retake if failed

### Dual Citizenship
- **Australia allows dual citizenship** ✅
- Check YOUR home country's rules (some don't allow dual)
- You can hold Australian passport + original passport

### Cost
- AUD $510 (adult)
- AUD $310 (child under 16)

### Processing Time
- Currently: 4-10 months typical
- Ceremony wait: 1-6 months after approval

### Benefits of Citizenship vs PR
| Benefit | PR | Citizen |
|---------|-----|---------|
| Live/work in Australia | ✅ | ✅ |
| Medicare | ✅ | ✅ |
| Vote | ❌ | ✅ (mandatory) |
| Australian passport | ❌ | ✅ |
| Government jobs | Limited | ✅ |
| Stand for parliament | ❌ | ✅ |
| Access to HECS | ✅ | ✅ |
| Can be deported | ✅ | ❌ |

---

## 8. Practical Tips

### Migration Agents

**MARA (Migration Agents Registration Authority)**
- All registered migration agents are on public register
- Search: [mara.gov.au](https://www.mara.gov.au/search-the-register-of-migration-agents/)
- **Only use MARA-registered agents** - it's illegal for unregistered people to give immigration advice for money

**DIY vs Agent:**

| DIY | Agent |
|-----|-------|
| Save $2,000-6,000+ | Experts handle complexity |
| Good for simple visas (visitor, WHV) | Good for skilled visas, refusals |
| You control timeline | They track deadlines |
| Risk missing requirements | Catch potential issues |

**Recommendation:**
- **Tourist/WHV:** DIY is fine
- **Student visa (straightforward):** DIY or education agent (often free)
- **Skilled visa first time:** Consider agent for skills assessment + EOI strategy
- **Refused before or complex case:** Get agent

### Processing Times Reality

**What the website says vs reality:**

| Visa | Official "75% processed in" | Reality |
|------|---------------------------|---------|
| 600 Tourist | 1-4 weeks | Usually accurate |
| 500 Student | 4-6 weeks | Can be 2-3 months |
| 482 Work | 2-4 months | Often 3-6 months |
| 189/190 | 6-12 months | 6-18 months |
| Partner | 12-24 months | Often 15-24 months |
| Parent (103) | 29 years | Not a typo. Decades. |

**Speed things up:**
- Submit complete application (no missing docs)
- Upload all evidence upfront
- Respond to requests within 14 days
- Correct medical/police clearances from start

### Bridging Visas

**What are they?**
- Temporary visas that let you stay legally while your real visa is processing

**Types:**
- **BVA:** Automatic when you apply for new visa while on another visa. Can't travel.
- **BVB:** Apply for this if you need to travel while on BVA
- **BVC:** For people in more complex situations

**Important:**
- BVA activates when your current visa expires
- Keep applying for BVB well before any travel
- Work rights depend on your underlying application

### Common Mistakes to Avoid

1. **Letting visa expire without applying for next one** - Don't become unlawful
2. **Not declaring health conditions** - Can cause visa cancellation later
3. **Overstaying** - Even 1 day = 3 year ban from most visas
4. **Working more than allowed hours** - Students: 48hrs/fortnight is serious
5. **Not meeting PR residency requirements** - Travel too much = lose PR
6. **Fake documents** - 10 year ban, possible lifetime ban
7. **Not checking condition codes** - Your visa conditions are online, check them!

### Useful Resources

| Resource | URL |
|----------|-----|
| Official visa finder | immi.homeaffairs.gov.au/visas |
| Visa processing times | immi.homeaffairs.gov.au/visas/getting-a-visa/visa-processing-times |
| Points calculator | immi.homeaffairs.gov.au/help-support/tools/points-calculator |
| Skills assessment | varies by profession |
| VEVO (check your visa) | immi.homeaffairs.gov.au/visas/already-have-a-visa/check-visa-details-and-conditions |
| MARA agent search | mara.gov.au |

### Budget Checklist for Visa Journey

| Item | Approx Cost AUD |
|------|-----------------|
| Skills assessment | $500-1,500 |
| English test (IELTS/PTE) | $400-500 |
| Police clearances | $50-200 per country |
| Medical exam | $300-500 |
| Migration agent | $2,000-8,000 |
| Visa application | $500-9,000 depending on type |
| Partner/children fees | Additional per person |
| **Total for skilled visa** | **$5,000-15,000+ per person** |

---

## Quick Decision Tree

```
Want to visit Australia?
├── From US, Japan, Canada, Singapore, etc? → ETA (601) - Quick, $20
├── From Europe? → eVisitor (651) - Free
└── Other? → Visitor (600) - $190+

Want to work in Australia?
├── Young (18-35) + want to travel? → Working Holiday (417/462)
├── Have job offer? → Employer sponsors you (482 → 186)
├── Want to immigrate yourself?
│   ├── High points (85+)? → 189 Independent
│   ├── Medium points? → 190 State Nominated
│   └── Lower points? → 491 Regional
└── Want to study first? → Student (500) → 485 → 189/190

In a relationship with Australian?
└── Partner visa (820/801) - ~$9K, 2 year wait to PR

Want citizenship?
└── Need PR first → then 4 years residence → test → ceremony
```

---

*Document compiled February 2026. Immigration law changes frequently - always verify at [immi.homeaffairs.gov.au](https://immi.homeaffairs.gov.au) before making decisions.*
