# Sydney Transport Guide (Feb 2026)

## 1. Opal Card System

### How to Get One
- **Airport**: Available at convenience stores in terminals and at train station ticket machines
- **Train/Metro Stations**: From Opal retailers at major stations or ticket machines (single trips only)
- **Shops**: Newsagents and convenience stores displaying the Opal logo (7-Eleven, etc.)
- **Online**: Order at opal.com.au (concession cards must be applied for online)
- **Cost**: The card itself is FREE - you just need to add value before travelling

### How It Works
1. **Tap on** at the start of your journey (reader glows green)
2. **Tap off** at the end (fare is calculated and deducted)
3. Fare is based on distance travelled
4. **Don't forget to tap off!** You'll be charged the maximum fare for that mode

### Caps & Discounts (Adult Fares, Feb 2026)

| Cap Type | Amount |
|----------|--------|
| **Weekly cap** | $50 |
| **Daily cap (Mon-Thu)** | $19.30 |
| **Daily cap (Fri/Sat/Sun/Public Holidays)** | $9.65 |

**Off-Peak Discount**: 30% discount when travelling:
- Fridays (all day)
- Weekends and public holidays
- Monday-Thursday: Outside 6:30-10am and 3-7pm

**Transfer Discount**: $2 off for each transfer between modes (metro/train, bus, ferry, light rail) within 60 minutes

**Opal Trip Advantage**: Multiple trips on the same mode within 60 minutes = one fare (based on total distance)

### Contactless Payment Alternative
You can tap on/off with:
- Credit/debit cards with contactless symbol
- Apple Pay, Google Pay, Samsung Pay

**Benefits**: Same fares and caps as Opal. Convenient if you don't want a separate card.

**Limitation**: Only adult fares; no concession rates.

---

## 2. Trains (Sydney Trains)

### Network Overview
- **169 stations** across metropolitan Sydney
- **9 lines** (T1-T9) covering suburbs from Berowra to Macarthur, Blue Mountains to Cronulla
- **Sydney Metro** (M1): Automated driverless metro - Tallawong to Sydenham (expanding to Bankstown in 2026)

### Key Lines

| Line | Route | Useful For |
|------|-------|------------|
| **T1** North Shore & Western | Berowra ↔ Richmond/Emu Plains via City | North Sydney, Chatswood, Parramatta |
| **T2** Leppington & Inner West | City Circle ↔ Parramatta/Leppington | Inner West, Southwest |
| **T3** Liverpool & Inner West | City Circle ↔ Liverpool | Bankstown, Liverpool |
| **T4** Eastern Suburbs & Illawarra | Bondi Junction ↔ Cronulla/Waterfall | Bondi Junction, Sutherland Shire |
| **T5** Cumberland | Schofields ↔ Leppington | Western Sydney connections |
| **T6** Lidcombe & Bankstown | Bankstown ↔ Lidcombe | Shuttle service |
| **T7** Olympic Park | Central/Lidcombe ↔ Olympic Park | Events, sports |
| **T8** Airport & South | City Circle ↔ Macarthur via Airport | **AIRPORT**, Wolli Creek, Revesby |
| **T9** Northern | Hornsby ↔ Gordon via City | Strathfield, Gordon |

**Sydney Metro M1**: Tallawong ↔ Sydenham
- Automated, driverless trains
- Every 4 minutes in peak
- Extends to Bankstown later in 2026

### Frequency & Reliability
- **Peak**: Every 3-10 minutes on most lines
- **Off-peak**: Every 10-15 minutes
- **After midnight**: NightRide buses replace trains (N-routes)
- Generally reliable; trackwork mainly on weekends (check alerts on app)

### ⚠️ Airport Line - EXPENSIVE!

The **T8 Airport & South Line** has a SEPARATE station access fee charged by the private Airport Link Company.

| Ticket Type | Station Access Fee | Weekly Cap |
|-------------|-------------------|------------|
| Adult Opal/Contactless | $17.92 | $36.36 |
| Opal Single Ticket | $18.30 | N/A |

**Total typical fare CBD ↔ Airport**: ~$20-22 (train fare + access fee)

**Important Notes**:
- Airport fee is NOT included in daily/weekly Opal caps
- No 60-minute transfer rule at airport stations
- Tap off → Tap on = 2 journeys + 2 fees

**Pro tip**: Take bus 420 or 350 instead - no station access fee, just normal Opal fare (~$3-5)!

---

## 3. Buses

### Coverage
Buses go where trains don't:
- **Eastern Suburbs**: Bondi Beach, Coogee, Bronte
- **Northern Beaches**: Manly to Palm Beach
- **Inner suburbs**: Newtown, Surry Hills, Paddington
- **Western Sydney**: areas between train lines

### Key Airport Bus Routes
- **Route 350**: Bondi Junction ↔ Domestic Terminal (via Mascot, Maroubra, Coogee) - every 10 min
- **Route 420**: Burwood ↔ Mascot (serves both terminals) - regular service

### Real-Time Apps
1. **TripView** (BEST) - $4.99, works offline, real-time tracking, most locals use this
2. **Opal Travel** (Free) - Official Transport NSW app
3. **Google Maps** - Good for planning, real-time tracking improving
4. **Citymapper** - Excellent for visitors

### Night Buses (NightRide)
- Run midnight to ~4:30am when trains stop
- Route numbers start with "N" (N10, N20, N30, etc.)
- Depart from Town Hall/CBD area
- Hourly-ish frequency, more on weekends
- **N20**: CBD ↔ Riverwood via International Airport Terminal

---

## 4. Ferries

### Overview
Sydney Ferries are **iconic** and a must-do! Part of the Opal network.
- 10 routes, all departing from Circular Quay (except F10)
- Operated by Transdev Sydney Ferries
- Opal card/contactless works on all ferries

### Key Routes

| Route | Destination | Journey Time | Why Take It |
|-------|-------------|--------------|-------------|
| **F1 Manly** | Manly | 30 min | ICONIC - best ferry ride, harbour views, Manly Beach |
| **F2 Taronga Zoo** | Taronga Zoo | 12 min | Zoo visit, stunning views |
| **F3 Parramatta River** | Parramatta | 60 min | Full harbour tour, stop at Cockatoo Island |
| **F4 Pyrmont Bay** | Darling Harbour/Pyrmont | 15 min | Easy harbour hop |
| **F7 Double Bay** | Double Bay | 15 min | Fancy suburbs |
| **F8 Cockatoo Island** | Historic island | 25 min | UNESCO site, old shipyard |
| **F9 Watsons Bay** | Watsons Bay | 25 min | The Gap, fish & chips |

### Best Ferry Rides for Tourists
1. **F1 to Manly** - THE classic Sydney experience. Harbour Bridge, Opera House, heads
2. **F3 to Parramatta** - Full harbour exploration, stop at Cockatoo Island
3. **F2 to Taronga** - Combine with zoo visit, Opera House from water
4. **F9 to Watsons Bay** - South Head views, the Gap, sunset drinks

### Fares
- Regular Opal fares apply (distance-based)
- Typically $6-8 one way depending on distance
- **Manly ferry**: 130-minute transfer window (not 60 min) due to length

---

## 5. Light Rail

### Lines

| Line | Route | Length |
|------|-------|--------|
| **L1 Dulwich Hill** | Central ↔ Dulwich Hill | 12.8 km |
| **L2 Randwick** | Circular Quay ↔ Randwick | 12 km |
| **L3 Kingsford** | Circular Quay ↔ Kingsford | 12 km |
| **L4 Parramatta** | Westmead ↔ Carlingford | 12 km |

### L1 - Inner West Line
- Connects Central Station → Pyrmont → Glebe → Leichhardt → Dulwich Hill
- Great for: Fish Market, Star Casino, Inner West pubs
- Runs along old goods rail corridor

### L2/L3 - CBD & South East
- Through George Street (pedestrian mall) → Surry Hills → Moore Park → Randwick/Kingsford
- Great for: Hospitals, UNSW, SCG/Allianz Stadium, Centennial Park
- Every 4-8 minutes

### L4 - Parramatta Light Rail (opened Dec 2024)
- Westmead Hospital → Parramatta CBD → Carlingford
- Useful for: Parramatta area, Western Sydney University

### Useful For?
- Getting around CBD without bus/metro
- SCG, Allianz Stadium events
- Sydney Uni/UNSW areas
- Inner West nightlife (L1)

---

## 6. Rideshare & Taxi

### Rideshare Apps
| App | Notes |
|-----|-------|
| **Uber** | Most popular, widest coverage |
| **Ola** | Often cheaper, good promos |
| **DiDi** | Chinese-owned, competitive pricing |

### Typical Rideshare Costs (Feb 2026 estimates)
| Trip | UberX Estimate |
|------|----------------|
| CBD ↔ Bondi Beach | $25-35 |
| CBD ↔ Airport | $40-55 |
| CBD ↔ Manly | $45-60 |
| Circular Quay ↔ Newtown | $20-30 |

**Surge pricing** applies during peak times, events, rain.

### Taxis
- **13cabs app** - Book and track taxis
- **Silver Service** - Premium taxis
- Taxis available at ranks throughout city

**⭐ Airport Flat Fare Trial (from Nov 2025)**:
- Sydney Airport → CBD: **$60 flat fare** (standard/wheelchair taxi)
- Maxi taxi (5+ people): **$80 flat fare**
- Includes tolls and taxes
- Must be uninterrupted trip to CBD zone

---

## 7. Cycling

### Bike Share
| Service | Type | Cost |
|---------|------|------|
| **Lime** | E-bikes & scooters | $1 unlock + $0.45/min |
| **Beam** | E-bikes & scooters | Similar pricing |
| **HelloRide** | E-bikes | In some areas |

- Find/unlock via each company's app
- Leave in designated parking areas
- Helmets required by law (carry your own or use provided)

### Cycling Paths
- **Sydney Harbour Bridge cycleway** - Iconic ride, access from Milsons Point
- **Bay Run** - 7km around Iron Cove, very popular
- **Centennial Park** - 3.8km loop, car-free, beautiful
- **Parramatta River** - Trail along river to Parramatta
- **Cooks River** - Flat, family-friendly

### ⚠️ The Hills Challenge
Sydney is **HILLY**. Key challenges:
- North Sydney/Kirribilli - steep hills everywhere
- Inner West - Balmain, Rozelle have brutal climbs
- Eastern Suburbs - Rose Bay to Double Bay
- CBD - mostly flat

**E-bikes recommended** for regular use. Regular bikes only if you're fit!

---

## 8. Airport Transfers

### Sydney Airport Basics
- **Terminal 1 (T1)**: International flights
- **Terminal 2 (T2)**: Domestic - Jetstar, Virgin
- **Terminal 3 (T3)**: Domestic - Qantas

T2 and T3 are connected by a walkway. T1 is separate (10 min drive/train).

### Option 1: Train (T8 Airport Line)
**Easiest but expensive**

| | Domestic Station | International Station |
|-|------------------|----------------------|
| Time to Central | 13 min | 15 min |
| Time to Circular Quay | 22 min | 24 min |
| Cost (Opal) | ~$20-22 total | ~$20-22 total |

Station access fee: **$17.92** + train fare

**Pros**: Fast, reliable, no traffic
**Cons**: Expensive, no weekly cap benefit on access fee

### Option 2: Shuttle Bus
Several shuttle services available:
- Pre-book online
- ~$20-25 per person to CBD hotels
- Can be slower with multiple stops
- Companies: Ready2Go, Con-X-ion

### Option 3: Bus (Budget Option)
**Route 350**: Domestic → Bondi Junction
**Route 420**: Both terminals → Burwood via CBD areas

- Regular Opal fare (~$3-5)
- Takes 45-60 min to CBD areas
- Runs frequently during day

### Option 4: Uber/Taxi

| Option | To CBD (estimate) |
|--------|-------------------|
| UberX | $40-55 |
| Taxi (flat fare) | $60 fixed |
| Maxi Taxi (flat fare) | $80 fixed |

Add $5-10 for Cross City Tunnel toll if going to eastern suburbs.

### Recommendation by Situation

| Situation | Best Option |
|-----------|-------------|
| Solo, light luggage | Train (fast, predictable) |
| Budget traveller | Bus 350/420 |
| Group of 3-4 | Uber/Taxi (split cost = cheaper than train per person) |
| Heavy luggage + tired | Taxi flat fare ($60) |
| Late night (midnight-5am) | Uber/Taxi only |
| Going to North Sydney/Chatswood | Train to Central, then T1 |
| Going to Bondi/Eastern Suburbs | Bus 350 direct |

---

## Quick Reference: Apps to Download

1. **Opal Travel** - Official app, trip planning, card balance
2. **TripView** ($4.99) - Best real-time tracking, offline capable
3. **Google Maps** - Backup navigation
4. **Uber** - Rideshare
5. **Lime** - E-bikes/scooters

## Key Prices Summary (Adult, Feb 2026)

| Item | Price |
|------|-------|
| Weekly Opal cap | $50 |
| Daily cap (Mon-Thu) | $19.30 |
| Daily cap (Fri-Sun) | $9.65 |
| Airport train (incl. access fee) | ~$20-22 |
| Airport taxi flat fare | $60 |
| Ferry to Manly | ~$8 |
| Off-peak discount | 30% |
| Transfer discount | $2 |

---

*Last updated: February 2026*
*Source: Transport for NSW (transportnsw.info)*
