# Moving to Sydney — Resident Guide

## 🏠 Finding a Rental

### Where to Search
| Platform | Best For | URL |
|----------|----------|-----|
| **Domain** | All listings, good filters | domain.com.au |
| **realestate.com.au** | Largest database | realestate.com.au |
| **Flatmates** | Shared accommodation | flatmates.com.au |
| **Fairy Floss** | Short-term/furnished | fairyfloss.com.au |
| **Facebook Marketplace** | Direct from owners, rooms | facebook.com/marketplace |

### The Inspection Process
1. **Book online** — Listings show open inspection times (usually Sat 10am-12pm)
2. **Turn up on time** — Sign in with your details (they use this to contact you)
3. **Inspect quickly** — Popular places have 20+ people in 15 minutes
4. **Apply immediately** — Don't wait, good places go same day

### Rental Application (100 Point ID)

You need **100 points** of identification:

| Document | Points |
|----------|--------|
| Australian Passport | 70 |
| Foreign Passport + Visa | 70 |
| Australian Driver's License | 40 |
| Birth Certificate | 70 |
| Medicare Card | 25 |
| Bank Statement | 25 |
| Utility Bill (your name) | 25 |

**What agents want:**
- ✅ Photo ID (passport)
- ✅ Visa status proof (if applicable)
- ✅ 3 recent payslips OR employment contract
- ✅ Bank statements (3 months showing savings)
- ✅ Rental history/references (or character references if first time)
- ✅ Completed application form (1Form, 2Apply, or Ignite)

### Competition Tips
- **Apply for multiple properties** — 5-10 applications is normal
- **Offer 6+ months upfront** if you have savings (common for newcomers)
- **Write a cover letter** — Stand out from other applicants
- **Apply within 1 hour** of inspection
- **Bring documents ready** — Pre-upload to 1Form/2Apply

### Bond & Costs
| Cost | Amount |
|------|--------|
| **Bond** | 4 weeks rent (held by NSW Fair Trading, refundable) |
| **Rent in advance** | 2 weeks minimum |
| **Application fee** | None (illegal to charge) |

**Bond lodging:** Agent must lodge with Rental Bonds Online within 10 days. You get a bond number — keep it!

---

## ⚡ Setting Up Utilities

### Electricity & Gas

| Provider | Notes |
|----------|-------|
| **AGL** | Largest, good app, bundle discounts |
| **Origin Energy** | Competitive, solar plans |
| **EnergyAustralia** | Easy signup, reliable |
| **Red Energy** | Often cheapest rates |
| **Amber Electric** | Wholesale rates (advanced) |

**Process:**
1. Call or signup online **before move-in day**
2. Need: Address, move-in date, ID
3. Takes 1-2 business days to connect
4. Compare rates at **energymadeeasy.gov.au** (government comparison)

### Internet (NBN)

**Check your address first:** nbnco.com.au/check-your-address

| Connection Type | Speed | Notes |
|-----------------|-------|-------|
| FTTP (Fibre to Premises) | Up to 1000 Mbps | Best, if available |
| FTTC (Fibre to Curb) | Up to 250 Mbps | Very good |
| FTTN (Fibre to Node) | Up to 100 Mbps | Depends on distance |
| HFC (Cable) | Up to 250 Mbps | Good option |

**Popular ISPs:**
| Provider | Strength | Price Range |
|----------|----------|-------------|
| **Aussie Broadband** | Best support, no throttling | $79-139/mo |
| **Superloop** | Great value, fast | $69-109/mo |
| **Telstra** | Coverage, bundles | $90-180/mo |
| **TPG** | Budget option | $60-90/mo |
| **Tangerine** | Cheap intro rates | $45-85/mo |

**Tip:** Aussie Broadband and Superloop consistently top speed tests. Avoid Optus/TPG in congested areas.

### Redirecting Mail
- **Australia Post redirect:** auspost.com.au/mail-redirect
- Costs ~$57 for 3 months (all mail forwarded to new address)
- Essential if expecting bank cards, TFN letters, etc.

---

## 📋 First Things To Do

### 1. Open a Bank Account

**Do this WITHIN 6 WEEKS of arrival** — after that, ID requirements become stricter.

| Bank | Best For | Notes |
|------|----------|-------|
| **Commonwealth Bank (CBA)** | Branches everywhere | Can open pre-arrival online |
| **Westpac** | Similar to CBA | Good international transfers |
| **NAB** | No monthly fees | Decent app |
| **ANZ** | International links | Good for APAC transfers |
| **Up Bank** | Best app, modern | Neobank (no branches) |
| **ING** | Fee-free ATMs | Rebates all ATM fees |

**Required:** Passport + visa + address (can use temporary address initially)

**Tip:** CBA lets you open an account **before arriving** and have a card waiting.

### 2. Get a Tax File Number (TFN)

**Essential for legal work.** Without it, you're taxed 47% on all earnings.

- **Apply online:** ato.gov.au/tfn
- **Who can apply:** Anyone with a valid visa allowing work
- **Processing:** 7-14 business days, arrives by post
- **Cost:** FREE

**Tip:** Apply immediately on arrival. Give TFN to employer within 28 days of starting work.

### 3. Medicare Card (if eligible)

**Eligible:** Australian citizens, permanent residents, some visa holders

**Reciprocal agreements (11 countries):**
- UK, Ireland, NZ, Belgium, Finland, Italy, Malta, Netherlands, Norway, Slovenia, Sweden

If your country has an agreement, you get basic Medicare while in Australia.

**Apply:**
1. Go to a Service NSW or Medicare office
2. Bring: Passport, visa, proof of enrollment/reciprocal eligibility
3. Get card in 2-3 weeks

### 4. Get an Opal Card

**Sydney's public transport card** — trains, buses, ferries, light rail.

**How to get one:**
- Buy at any newsagent, train station, or online
- Top up with cash or link to bank card
- Tap on/tap off every trip

**Or use contactless:** Your Visa/Mastercard works directly on readers (same price, less admin)

**Caps:**
- Daily cap: ~$17.80 (unlimited travel after that)
- Weekly cap: ~$50
- Sunday cap: $2.90 (all-day travel)

### 5. Council Registration?

**Not required** — Australia doesn't have mandatory resident registration like Europe.

However, you may want to:
- Register to vote (mandatory for citizens)
- Update electoral roll address
- Register pets with local council

---

## 👥 Building Community

### Expat Groups
| Group | Platform | Notes |
|-------|----------|-------|
| InterNations Sydney | App/Website | Events, networking |
| Expat.com Sydney | Forums | Q&A, advice |
| Internations | App | Professional networking |

### Meetup.com
Search by interest:
- "Sydney Newcomers"
- "Sydney Social"
- "[Your hobby] Sydney"
- "Sydney Language Exchange"

Highly active scene — tech, hiking, photography, board games, everything.

### Sports Clubs
| Sport | Where to Find |
|-------|---------------|
| Running | Parkrun (free Saturdays 7am), many locations |
| Soccer | Football NSW community leagues |
| Touch Rugby | Touch Football Australia |
| Cricket | Cricket NSW community |
| Tennis | Local clubs, Book a Court app |
| Swimming | Ocean pools (free!), local pools |
| Surfing | Bondi, Manly, Cronulla — lessons available |

### Facebook Groups by Nationality
Search: "[Nationality] in Sydney" or "[Country] Sydney Expats"

Popular ones:
- Brits in Sydney
- Germans in Sydney
- Españoles en Sydney
- French in Sydney
- Indians in Sydney
- Brasileiros em Sydney
- Italiani a Sydney

These are goldmines for:
- Finding flatmates from home country
- Job leads
- Selling/buying stuff
- Feeling less alone

---

## Quick Reference Card

| Task | When | Where |
|------|------|-------|
| Bank account | Day 1-2 | Any bank branch |
| TFN application | Day 1 | ato.gov.au (online) |
| Phone/SIM | Day 1 | Any supermarket or carrier store |
| Opal card | Day 1 | Train station or newsagent |
| Medicare | Week 1 | Service NSW / Medicare |
| Start rental search | 2-4 weeks before moving | Domain / realestate.com.au |
| Internet setup | 1 week before move-in | ISP website |
| Electricity | 2-3 days before move-in | Provider website/phone |

**Welcome to Sydney! 🦘**
