# Sydney Daily Life — Local Services Guide

## 🏦 Banking

### Big 4 Banks
| Bank | Pros | Cons | Monthly Fee |
|------|------|------|-------------|
| **CBA** (Commonwealth) | Most branches/ATMs, best app | Higher fees | $4 (waivable) |
| **Westpac** | Good international, solid app | Average service | $5 (waivable) |
| **NAB** | No monthly fee | Fewer branches | $0 |
| **ANZ** | APAC presence, Apple Pay early | Less modern app | $5 (waivable) |

**Fee waiver:** Usually waived if you deposit $2,000+/month

### Neobanks (Recommended)
| Bank | Best For | Notes |
|------|----------|-------|
| **Up Bank** | Best app, instant notifications | No branches, CBA ATMs free |
| **ING** | Fee-free ATMs Australia-wide | Rebates all ATM fees |
| **Macquarie** | Savings rate | Good interest, limited features |
| **86 400** | Budgeting features | Now part of NAB |

**Recommendation:** Open CBA for branches + Up Bank for daily use. Best of both worlds.

### What You Need to Open
- Passport
- Visa (if not citizen)
- Australian address (temp OK)
- Phone number

---

## 📱 Mobile / SIM Cards

### Major Carriers
| Carrier | Network | Pros | Cons |
|---------|---------|------|------|
| **Telstra** | Best coverage | Works everywhere, rural areas | Most expensive |
| **Optus** | Good coverage | Cheaper than Telstra | Outages occasionally |
| **Vodafone** | City coverage | Good value | Weak in rural |

### MVNOs (Budget Options on Same Networks)
| MVNO | Uses Network | Price Range | Notes |
|------|--------------|-------------|-------|
| **Boost** | Telstra | $20-50/mo | Full Telstra coverage |
| **Aldi Mobile** | Telstra | $15-35/mo | Great value |
| **Amaysim** | Optus | $10-40/mo | No lock-in |
| **Kogan** | Vodafone | $15-30/mo | Long expiry plans |
| **Lebara** | Vodafone | $10-30/mo | Great international calls |
| **Felix** | Vodafone | $35/mo flat | Unlimited everything |

**Recommendation:**
- City dweller → **Boost** or **Aldi Mobile** (Telstra network, half the price)
- Tight budget → **Amaysim** $10-15 plans
- Heavy user → **Felix** $35 unlimited

**Where to buy:** Woolworths, Coles, 7-Eleven, JB Hi-Fi, or carrier stores

---

## 🌐 Internet (NBN)

### Check Your Connection First
**nbnco.com.au/check-your-address** — See what's available at your address

### Speed Tiers
| Tier | Download | Upload | Good For |
|------|----------|--------|----------|
| NBN 25 | 25 Mbps | 5 Mbps | Light use, 1-2 people |
| NBN 50 | 50 Mbps | 20 Mbps | Streaming, WFH, 2-3 people |
| NBN 100 | 100 Mbps | 20 Mbps | Heavy use, 4K, gaming |
| NBN 250 | 250 Mbps | 25 Mbps | Power users |
| NBN 1000 | 1000 Mbps | 50 Mbps | If you need it, you know |

### Best ISPs (Speed & Reliability)
| Provider | NBN 50 Price | Strengths |
|----------|--------------|-----------|
| **Aussie Broadband** | $79/mo | Best support, no congestion |
| **Superloop** | $69/mo | Fast, good value |
| **Launtel** | $69/mo | No contract, flexible |
| **Tangerine** | $45-59/mo | Budget, intro deals |
| **Telstra** | $90/mo | Bundles, tech support |
| **TPG** | $60/mo | Budget (variable quality) |

**Avoid:** Very cheap resellers often have congestion at peak times (7-11pm)

**Tip:** Aussie Broadband has a congestion-free guarantee and Australian support. Worth the extra $10/mo.

---

## 📮 Post & Parcels

### Australia Post Services
| Service | What It Is |
|---------|------------|
| **Post Office** | Send/receive mail, banking services |
| **PO Box** | Permanent postal address ($120-250/year) |
| **Parcel Locker** | Free 24/7 parcel collection |
| **Parcel Collect** | Pick up at post office |

### Parcel Lockers (Free!)
- Sign up: **auspost.com.au/parcellocker**
- Get a unique address for online shopping
- Parcel goes to nearest locker, you get a code
- Collect anytime 24/7

**Highly recommended** — No missed deliveries, completely free.

### Useful Tips
- **Redirect mail:** $57/3 months (essential when moving)
- **Express Post:** Guaranteed next business day within network
- **International:** Expensive. Consider Sendle for cheaper options.

---

## 🏛️ Government Services

### Service NSW
Your one-stop for state government:
- Driver's license
- Working With Children check
- Seniors card
- Fines and payments
- Photo ID card

**Locations:** service.nsw.gov.au/service-centre/all
- Major ones: Sydney CBD, Parramatta, Bondi Junction, Chatswood
- Usually need to **book online** for popular services

### myGov (Federal)
Online portal linking:
- ATO (tax)
- Medicare
- Centrelink
- My Health Record
- Job Services

**Setup:** my.gov.au — link services using linking codes

### Key Government Contacts
| Service | Phone | Online |
|---------|-------|--------|
| Service NSW | 13 77 88 | service.nsw.gov.au |
| Medicare | 132 011 | my.gov.au |
| ATO (tax) | 13 28 61 | ato.gov.au |
| Centrelink | 13 24 68 | my.gov.au |
| Immigration | 131 881 | homeaffairs.gov.au |

---

## 📚 Libraries

**Sydney libraries are excellent and FREE:**
- Borrow books, audiobooks, e-books
- Free WiFi and computers
- Printing/scanning
- Meeting rooms
- Events, workshops, classes
- Kids programs

### Library Networks
| Council | Cards Valid At |
|---------|----------------|
| City of Sydney | All City of Sydney branches |
| NSW State Library | Anyone (free membership) |
| Most councils | Their local branches |

**State Library of NSW** (Macquarie Street, CBD):
- Free to all
- Beautiful heritage building
- Great study spaces
- Regular exhibitions and events

**E-resources:** Most libraries give access to:
- Libby/OverDrive (e-books)
- Kanopy (free movies)
- Lynda.com/LinkedIn Learning
- Newspapers/magazines

---

## 🏋️ Gyms

### Big Chains
| Gym | Price | Pros | Cons |
|-----|-------|------|------|
| **Fitness First** | $25-40/wk | Good facilities, classes | Expensive, contracts |
| **Anytime Fitness** | $15-20/wk | 24/7 access, everywhere | Smaller gyms |
| **Plus Fitness** | $12-15/wk | 24/7, budget | Basic equipment |
| **Jetts** | $10-15/wk | 24/7, no contract | Minimal classes |
| **Goodlife** | $20-30/wk | Great facilities | Limited locations |

### Budget Options
| Option | Price | Notes |
|--------|-------|-------|
| **Council gyms** | $5-10/visit | Cheaper memberships available |
| **Uni gyms** | $15-25/wk | If you're a student |
| **ClassPass** | Variable | Classes at many gyms |
| **Outdoor gyms** | FREE | Bondi, Centennial Park, many beaches |

### Avoiding Contract Traps
- Ask about **no lock-in** options (usually +$2-3/wk)
- Read cancellation terms carefully
- Avoid 12-24 month contracts
- Gyms legally must offer 14-day cooling-off period

---

## 🛒 Supermarkets

### Main Chains
| Store | Price | Quality | Notes |
|-------|-------|---------|-------|
| **Coles** | Mid | Good | Flybuys points |
| **Woolworths** | Mid | Good | Everyday Rewards |
| **Aldi** | Low | Good | Limited range, BYO bags |
| **IGA** | High | Variable | Local, convenience |
| **Harris Farm** | High | Premium | Fresh produce, deli |
| **Costco** | Low (bulk) | Good | Membership $65/year |

### Tips
- **Aldi** for staples and weekly shop — 30-40% cheaper
- **Woolworths/Coles** for variety and brands
- **Harris Farm** for quality produce and specialty items
- **Asian grocers** (Eastwood, Ashfield, Cabramatta) for huge savings

### Loyalty Programs
| Program | Store | Worth It? |
|---------|-------|-----------|
| Everyday Rewards | Woolworths | Yes — Qantas points option |
| Flybuys | Coles, Kmart | Yes — decent cash off |
| Aldi | None | N/A — always cheapest |

---

## 🏥 Doctors & Healthcare

### Bulk Billing vs Gap
| Type | Cost to You | What It Means |
|------|-------------|---------------|
| **Bulk billing** | $0 | Doctor bills Medicare directly |
| **Gap payment** | $20-80+ | You pay difference between Medicare rebate and fee |
| **Private** | Full cost | No Medicare (some specialists) |

### Finding Bulk Billing GPs
- **Hotdoc.com.au** — Filter by bulk billing
- **HealthEngine** — Similar, shows availability
- **Medical centres** often bulk bill more than private GPs

**Reality check:** Bulk billing becoming rarer. Many GPs now charge $40-80 gap. Factor this into budget.

### Useful Health Services
| Service | What | Cost |
|---------|------|------|
| **13HEALTH** | Phone health advice | Free |
| **Healthdirect** | Online symptom checker | Free |
| **Nurse on Call** | Phone nurse advice | Free |
| **Hospital ED** | Emergency | Free (long wait for non-urgent) |

### Specialists
- Usually need GP referral
- Often $150-400+ with partial Medicare rebate
- Waitlists can be long in public system

---

## 💊 Pharmacies

### Major Chains
| Chain | Strengths |
|-------|-----------|
| **Chemist Warehouse** | Cheapest prices, huge stores |
| **Priceline** | Good range, beauty products |
| **Terry White** | Quality service, advice |
| **Amcal** | Local community pharmacies |

### Tips
- **Chemist Warehouse** for cheapest OTC medicines and vitamins
- **Priceline Sister Club** — Good loyalty rewards
- **PBS (Pharmaceutical Benefits Scheme)** — Makes many prescriptions cheap ($7.70 concession, $31.60 general)
- **Scripts:** Can fill at ANY pharmacy — shop around for price

### After-Hours Pharmacies
Some Chemist Warehouse locations open late (8-9pm)
Search "24 hour pharmacy Sydney" for emergency needs

---

## Quick Reference

| Need | Go To |
|------|-------|
| Cheapest groceries | Aldi |
| Cheapest pharmacy | Chemist Warehouse |
| Cheapest mobile | Aldi Mobile / Boost prepaid |
| Best bank app | Up Bank |
| Best internet | Aussie Broadband |
| Free gym | Outdoor gyms (beaches, parks) |
| Free parcels | Australia Post Parcel Locker |
| Free doctor | Bulk billing GP (Hotdoc) |
| Free books/movies | Library (Libby, Kanopy) |

---

## Emergency Numbers

| Service | Number |
|---------|--------|
| **Police/Fire/Ambulance** | 000 |
| **Police (non-emergency)** | 131 444 |
| **Health advice** | 1800 022 222 |
| **Poisons Info** | 13 11 26 |
| **Mental Health** | 1800 011 511 |
| **Lifeline** | 13 11 14 |
| **SES (floods/storms)** | 132 500 |

**Text emergency:** If you can't speak, text 106 (only works if pre-registered)

---

*Last updated: February 2024*
