# Sydney Healthcare Guide
*Last updated: February 2026*

## 1. Medicare System

### Who's Eligible
Medicare is Australia's universal healthcare scheme. You're eligible if you're:
- **Australian citizen** (anywhere in the world)
- **Permanent resident** (PR visa holder)
- **New Zealand citizen** living in Australia
- **Applied for permanent residency** (interim Medicare)
- **Reciprocal Health Care Agreement (RHCA) country citizen** visiting Australia
- **Certain visa holders** covered by Ministerial Orders

**NOT eligible:** Most temporary visa holders (tourist, working holiday, most work visas), international students (must use OSHC instead).

### Getting Your Medicare Card
1. Visit a **Services Australia** office (many in Sydney CBD, Parramatta, etc.)
2. Bring: passport, visa evidence, proof of Australian address
3. Or enroll online via **myGov** account
4. Card arrives by mail in ~3 weeks; you get a number immediately

**Digital card:** Available in Medicare app or myGov — accepted everywhere.

### What Medicare Covers
| Covered ✅ | NOT Covered ❌ |
|-----------|---------------|
| GP visits | Dental (routine) |
| Specialist consultations | Physiotherapy |
| Public hospital (free as public patient) | Optical/glasses |
| Pathology tests & X-rays | Chiropractic |
| Mental health (with plan) | Cosmetic procedures |
| Most surgery (public hospital) | Ambulance (in most states) |
| PBS medications (subsidized) | Private hospital room |

### Bulk Billing vs Gap Payments
**Bulk billing** = The doctor accepts Medicare rebate as full payment. You pay **$0**.

**Gap payment** = Doctor charges more than Medicare rebate. You pay the difference.

**Current reality (Feb 2026):**
- Bulk billing has declined significantly since COVID
- In Sydney, ~40-50% of GP visits are bulk billed (varies by area)
- More bulk billing in: Western Sydney, outer suburbs
- Less bulk billing in: Eastern suburbs, North Shore, CBD
- Concession card holders more likely to get bulk billing

**Typical GP gap fees in Sydney:**
- Standard consultation: $20-60 gap
- Long consultation: $40-90 gap
- Some practices charge $80-150 total (you claim ~$40 back)

### Finding Bulk Billing Doctors
1. **HotDoc app** — Filter by "bulk billing"
2. **Healthengine app** — Same filter available
3. **healthdirect.gov.au/service-finder** — Government directory
4. **Ask when booking**: "Do you bulk bill?" or "Do you bulk bill concession card holders?"
5. **Medical centres in shopping malls** often bulk bill
6. **After-hours GP services** often bulk bill

---

## 2. Private Health Insurance

### Why Australians Get It
The government uses financial incentives (penalties) to push people toward private insurance:

**Medicare Levy Surcharge (MLS):**
If you earn over $93,000 (single) or $186,000 (family) and DON'T have private hospital cover, you pay an extra tax:

| Income (Single) | Income (Family) | MLS Rate |
|----------------|-----------------|----------|
| $93,000-108,000 | $186,000-216,000 | 1.0% |
| $108,001-144,000 | $216,001-288,000 | 1.25% |
| $144,001+ | $288,001+ | 1.5% |

**Lifetime Health Cover (LHC):**
If you don't get hospital cover by age 31, you pay 2% extra on premiums for every year you delay. Example: Join at 40 = 18% loading forever.

**The math:** Often cheaper to get basic hospital cover than pay MLS.

### Types of Cover

**Hospital Cover** (avoids MLS):
- Basic: Covers accidents, some surgeries
- Bronze: Limited elective surgery
- Silver: More procedures including some joint replacements
- Gold: Comprehensive — pregnancy, cardiac, etc.

**Extras Cover** (doesn't avoid MLS):
- Dental, optical, physio, chiro
- Usually 50-85% back up to annual limits
- Example: $200 dental limit, claim $150 back on $200 filling

**Combined:** Most people get hospital + extras together.

### Major Providers

| Provider | Reputation | Notes |
|----------|-----------|-------|
| **Medibank** | Largest, reliable | Government-owned until 2014, big network |
| **Bupa** | Global brand | Good for expats, international coverage |
| **HCF** | Not-for-profit | Good value, loyal following |
| **nib** | Tech-forward | Good app, decent prices |
| **AHM** | Budget-friendly | Owned by Medibank, simpler products |

### Typical Monthly Costs (Feb 2026)

**Singles:**
| Cover Type | Monthly Cost |
|------------|--------------|
| Basic hospital only | $80-120 |
| Mid hospital + basic extras | $140-180 |
| Top hospital + good extras | $200-280 |

**Couples/Families:**
| Cover Type | Monthly Cost |
|------------|--------------|
| Basic hospital only | $160-240 |
| Mid hospital + extras | $280-380 |
| Top hospital + good extras | $400-550 |

*Prices vary by state, age, and excess chosen. Higher excess = lower premium.*

### Waiting Periods
Standard waiting periods before you can claim:

| Service | Waiting Period |
|---------|---------------|
| Accidents | None (covered immediately) |
| Ambulance | Usually 1-2 days |
| General dental, optical | 2 months |
| Major dental | 12 months |
| Pre-existing conditions | 12 months |
| Pregnancy | 12 months |
| Joint replacements | 12 months |
| Psychiatric | 2 months |

**Tip:** If switching funds, waiting periods you've already served transfer.

### For Visa Holders
- **Working visas (482, etc.):** Private health insurance often mandatory for visa conditions — NOT OSHC
- **Student visas:** Must have OSHC (see Section 7)
- **PR applicants:** Can often get Medicare; private cover optional but recommended

---

## 3. Finding Healthcare

### Finding a GP
**Apps (most popular):**
- **HotDoc** — 13+ million Australians use it, book 24/7
- **HealthEngine** — Similar, also shows wait times

**What to look for:**
- Bulk billing (if budget matters)
- Open hours (many close at 5pm)
- Online booking available
- Reviews/ratings

**Registration:** You can be a "patient" at multiple clinics. No formal registration required.

### Specialists
**How it works:**
1. See a GP first
2. GP writes a **referral** to specialist
3. Referral valid for 12 months (or indefinitely for chronic conditions)
4. Without referral = no Medicare rebate = full cost

**Wait times (public):**
- Dermatology: 3-12 months
- Orthopaedics: 6-18 months
- Psychiatry: 2-6 months

**Private:** Usually 1-4 weeks, but higher out-of-pocket costs ($150-400 gap typical).

### Emergency: When to Go Where

**Call 000 (ambulance) for:**
- Chest pain, difficulty breathing
- Severe bleeding
- Unconsciousness
- Suspected stroke

**Go to Emergency Department for:**
- Broken bones
- Deep cuts needing stitches
- High fever with severe symptoms
- Serious allergic reactions

**Go to GP or After-Hours Clinic for:**
- Infections (UTI, ear, throat)
- Minor injuries
- Persistent but not severe symptoms
- Prescription refills (urgent)

**Telehealth first:**
- Mild symptoms, need advice
- Prescription renewals
- Mental health check-ins

### After-Hours Options
1. **13SICK (137425)** — National home doctor service, bulk billed
2. **After-hours medical centres** — Many in shopping centres
3. **Hospital EDs** — Always open but long waits for non-urgent
4. **healthdirect helpline: 1800 022 222** — 24/7 nurse advice

### Telehealth
Since COVID, telehealth is mainstream:
- Most GPs offer phone/video consults
- Medicare rebates apply (same as in-person)
- Book via HotDoc, Healthengine, or call clinic
- Good for: prescriptions, follow-ups, mental health, minor issues

---

## 4. Hospitals

### Public vs Private

| Aspect | Public Hospital | Private Hospital |
|--------|-----------------|------------------|
| Cost | Free (as public patient) | Insurance + gap fees |
| Doctor choice | No choice — assigned | Choose your surgeon |
| Room | Shared ward | Usually private room |
| Wait for elective surgery | Months to years | Days to weeks |
| Emergency care | Full access, triaged | Many don't have ED |
| Quality of care | Excellent | Excellent |

### Major Sydney Hospitals

**CBD/Inner:**
- **Royal Prince Alfred (RPA)** — Camperdown, major trauma centre
- **St Vincent's** — Darlinghurst, heart/lung specialist
- **Sydney Eye Hospital** — Self-explanatory

**North:**
- **Royal North Shore** — St Leonards, major hospital
- **Mater Hospital** — North Sydney (private)

**West:**
- **Westmead Hospital** — Huge, major teaching hospital
- **Blacktown Hospital** — Growing, serves Western Sydney

**South:**
- **St George Hospital** — Kogarah, major centre
- **Liverpool Hospital** — Major trauma centre

**Private hospitals:** Mater, St Vincent's Private, North Shore Private, Prince of Wales Private

### Emergency Wait Times (Reality Check)
**Triage categories:**
| Category | Target Wait | Typical Reality |
|----------|-------------|-----------------|
| 1 - Resuscitation | Immediate | Immediate |
| 2 - Emergency | 10 mins | Usually met |
| 3 - Urgent | 30 mins | 30-90 mins |
| 4 - Semi-urgent | 60 mins | 2-6 hours |
| 5 - Non-urgent | 120 mins | 4-12+ hours |

**Tips:**
- Go early morning (4-8am) for shorter waits
- Weekend nights are worst
- Minor injuries: consider after-hours GP instead
- If in doubt, call healthdirect first: 1800 022 222

---

## 5. Pharmacy (PBS)

### Pharmaceutical Benefits Scheme
The PBS subsidizes most prescription medications. As of **January 2026**:

| Patient Type | Max Cost Per Script |
|--------------|---------------------|
| General | $25.00 |
| Concession card holder | $7.70 |

**Safety Net:** After spending a threshold in a year, scripts become cheaper/free:
- General: After ~$1,692.40/year → pay $0 per script
- Concession: After ~$262.80/year → pay $0 per script

### Chemist Warehouse
The "Costco of pharmacies" — dramatically cheaper for:
- Over-the-counter medications
- Vitamins and supplements
- Beauty products
- Some prescriptions (within PBS limits)

**Tips:**
- PBS medications: Same price everywhere (regulated)
- OTC medications: Shop around — CW often 30-50% cheaper
- Compare generic vs brand — pharmacist can substitute

### What You Can Buy OTC (No Prescription)
- Paracetamol, ibuprofen
- Antihistamines
- Cold & flu medications
- Basic skin creams
- Vitamins and supplements
- First aid supplies

**Behind the counter (ask pharmacist, no script needed):**
- Codeine-free pain relief
- Pseudoephedrine (cold meds) — need ID
- Emergency contraception
- Some stronger antihistamines

**Prescription required:**
- Antibiotics
- Strong painkillers
- Sleeping pills
- Most chronic disease medications

---

## 6. Mental Health

### Mental Health Care Plan
Under the **Better Access Initiative**, Medicare subsidizes psychology sessions:

**How to get one:**
1. Book a **long appointment** with your GP (~30-40 mins)
2. GP assesses and creates the plan
3. GP gives referral to psychologist/mental health professional
4. You get **10 individual + 10 group sessions per calendar year**

**Costs:**
- Medicare rebate: ~$93 per session (2026)
- Psychologist fees: $180-280 typically
- **Gap payment: $80-180 per session**
- Some psychologists bulk bill (rare, long waits)

**Finding a bulk billing psychologist:**
- Community health centres
- University clinics
- Long waiting lists (2-6 months)

### Psychologists vs Psychiatrists

| | Psychologist | Psychiatrist |
|--|-------------|-------------|
| Qualification | Psychology degree + registration | Medical doctor + specialist training |
| Can prescribe? | No | Yes |
| Medicare access | Mental Health Care Plan | GP referral |
| Best for | Therapy, counseling, CBT | Medication, complex conditions |
| Typical gap | $80-180/session | $150-300/session |

### Crisis Support Lines
**Free, 24/7:**
- **Lifeline:** 13 11 14 (crisis support)
- **Beyond Blue:** 1300 22 4636 (anxiety, depression)
- **Suicide Call Back Service:** 1300 659 467
- **Kids Helpline:** 1800 55 1800 (under 25s)
- **13YARN:** 13 92 76 (First Nations crisis support)

**In emergency:** Call 000 or go to hospital ED

### Online Resources
- **Beyond Blue** (beyondblue.org.au) — Information, forums, online chat
- **Headspace** (headspace.org.au) — Youth mental health (12-25)
- **Head to Health** (headtohealth.gov.au) — Government resource hub
- **This Way Up** — Online CBT programs

---

## 7. For Visitors & Students

### Travel Insurance (Essential!)
If you're visiting Australia without Medicare eligibility, **travel insurance is critical**.

**Without it:**
- GP visit: $80-150
- Emergency department: $500-1,500 minimum
- Hospital admission: $1,500-3,000+ per day
- Surgery: $10,000-50,000+
- Ambulance: $400-1,200 in NSW

**Good travel insurance covers:**
- Medical emergencies
- Hospital stays
- Emergency evacuation
- Repatriation

### Reciprocal Health Care Agreements (RHCA)
Citizens of these countries get limited Medicare access when visiting:

**Full RHCA (similar to Australian residents):**
- United Kingdom
- Ireland
- New Zealand
- Sweden
- Netherlands
- Finland
- Belgium
- Norway
- Slovenia
- Italy
- Malta

**What's covered:**
- Essential medical treatment
- PBS medications
- Public hospital as public patient

**NOT covered:**
- Pre-existing conditions (usually)
- Elective procedures
- Ambulance (varies)
- Repatriation home

**To access:** Show passport at GP/hospital + Medicare office for RHCA card

### OSHC (Overseas Student Health Cover)

**Mandatory** for all student visa holders.

**What it covers:**
- GP visits (usually full rebate)
- Hospital (public, as private patient)
- Some specialist services
- PBS medications
- Ambulance
- Some mental health

**NOT covered:**
- Dental, optical
- Pre-existing conditions (first 12 months)
- Pregnancy (first 12 months)

**Major OSHC providers:**
| Provider | Monthly Cost (approx) |
|----------|----------------------|
| Medibank OSHC | $50-60 |
| Allianz OSHC | $45-55 |
| Bupa OSHC | $50-60 |
| nib OSHC | $45-55 |
| ahm OSHC | $45-55 |

**Costs:** ~$550-700/year for singles (2026 rates)

**Tips:**
- Must maintain OSHC for entire visa period
- Compare prices — same minimum coverage required
- Can add extras (dental, optical) for more
- University often arranges bulk deals

---

## Quick Reference

### Emergency Numbers
- **Emergency (ambulance, fire, police):** 000
- **Poisons Information:** 13 11 26
- **healthdirect (nurse advice):** 1800 022 222
- **Mental health crisis:** 13 11 14 (Lifeline)

### Useful Apps
- **HotDoc** — Book GP appointments
- **HealthEngine** — Book appointments, compare
- **Medicare (myGov)** — Claims, digital card
- **First Aid (St John)** — Emergency guidance

### Key Websites
- **servicesaustralia.gov.au/medicare** — Medicare info
- **healthdirect.gov.au** — Health information, service finder
- **pbs.gov.au** — Medicine costs and information
- **privatehealth.gov.au** — Compare insurance policies

---

*This guide reflects information current as of February 2026. Healthcare policies and costs change regularly. Always verify with official sources for the most up-to-date information.*
