# Sydney Food Practical Guide

*Last updated: February 2026*

---

## 1. Dietary Requirements

### Vegetarian & Vegan Scene

Sydney has one of Australia's best vegan scenes, with **Newtown** and **Surry Hills** being the epicenters.

**Top Vegan/Vegetarian Spots:**

| Restaurant | Location | Style | Price |
|------------|----------|-------|-------|
| **Yellow** | Potts Point | Fine dining, tasting menus | $$$$ |
| **Shift Eatery** | Surry Hills | All-day café, comfort food | $$ |
| **Gigi Pizzeria** | Newtown | 100% vegan Neapolitan pizza | $$ |
| **Yulli's** | Surry Hills | Brewpub with vegan food | $$ |
| **Golden Lotus** | Newtown | Vietnamese vegan | $ |
| **Little Turtle** | Enmore | Japanese-inspired | $$ |
| **Vandal Taqueria** | Multiple | Vegan Mexican | $$ |
| **The Chippo Hotel (Mama B's)** | Chippendale | Australia's first fully vegan pub | $$ |
| **Bodhi Restaurant** | CBD (Cook + Phillip Park) | Vegan yum cha | $$$ |
| **Towzen Sydney** | CBD | Vegan ramen | $$ |

**Neighborhoods for Vegan:**
- **Newtown** — The vegan capital; King St has 10+ dedicated options
- **Surry Hills** — Trendy cafés with extensive vegan menus
- **Bondi** — Health-conscious beach cafés (Speedo's Cafe)
- **Enmore/Marrickville** — Emerging scene

**Finding Options:** Download **HappyCow** app — Sydney has 500+ listings.

---

### Gluten-Free Availability

**Generally good awareness.** Most restaurants offer GF options or can adapt dishes.

**Key points:**
- **Thai & Vietnamese** restaurants often naturally GF (rice noodles, no wheat)
- **Italian** restaurants usually have GF pasta on request
- **Dedicated GF bakeries:** Bread & Butter Project, Breadbox Bakery
- **Supermarkets:** Coles/Woolworths have extensive "Free From" sections
- **Chain cafés:** All major chains (Bourke Street Bakery, etc.) have GF options

**Tips:**
- Always mention "coeliac" if severe — staff understand this better than "gluten-free preference"
- Asian restaurants may use soy sauce (contains wheat) — ask about tamari substitution

---

### Halal Options by Area

Sydney has a significant Muslim population, making halal food widely available.

**Halal Hubs:**

| Area | Style | Notable Spots |
|------|-------|---------------|
| **Lakemba** | Lebanese, Yemeni, Pakistani | El-Manara, Yemen Gate, Jasmin Lebanese |
| **Auburn** | Middle Eastern, Turkish | Jasmin1 Lebanese, New Star Kebab |
| **Bankstown** | Diverse Middle Eastern | Volcano's Steakhouse (halal wagyu) |
| **Punchbowl** | Lebanese | Multiple bakeries & grills |
| **Harris Park** | Indian/Pakistani | Multiple curry houses |

**CBD/Inner City Halal Fine Dining:**
- **NOUR** (Surry Hills) — Modern Middle Eastern, $$$$
- **Aalia Restaurant** (CBD) — Upscale halal, $$$$

**Resource:** Follow **@_tastyhalal_** on Instagram (54k+ followers) for Sydney halal recommendations.

**Chains:** Many McDonald's, KFC, and Subway locations in Western Sydney are halal-certified (not all — check before ordering).

---

### Kosher Options

Sydney's kosher scene is **limited** compared to other dietary categories.

**Main Areas:**
- **Bondi** — Largest Jewish community
- **Dover Heights/Rose Bay** — Some kosher delis

**Known Kosher Restaurants:**
- **Katzy's** (Bondi) — Deli/café
- **Savion** (Bondi Junction) — Israeli
- Various bakeries in Bondi area

**Tips:**
- Most kosher restaurants close Friday evening through Saturday (Shabbat)
- For strict kosher, contact **Sydney Kashrut Authority** for certified restaurants
- Self-catering: Kosher section at Woolworths Double Bay, specific kosher stores in Bondi

---

### Allergy Awareness

**Legally required:** Australian Food Standards Code mandates restaurants declare 10 major allergens (peanuts, tree nuts, milk, egg, wheat, soy, fish, shellfish, sesame, lupin).

**In practice:**
- **Most restaurants** have allergy menus or can provide info on request
- **Staff training** is generally good in mid-to-high-end restaurants
- **Chain restaurants** often have online allergen guides

**Tips:**
- Say "I have an allergy" not "I don't like" — triggers different kitchen protocols
- **Anaphylaxis:** Carry your EpiPen; mention severity to staff
- **Asian restaurants:** High cross-contamination risk for nut allergies (shared woks)

---

## 2. Alcohol

### Licensing Laws & RSA

**RSA (Responsible Service of Alcohol):**
- All staff serving alcohol must have RSA certification
- Mandatory to refuse service to intoxicated persons
- Can be asked for ID if you look under 25

**Venue Types:**
- **Hotel/Pub** — Full liquor license, can drink without food
- **Restaurant** — Often on-premises license, must serve with food
- **BYO** — Can bring your own alcohol (usually wine only)
- **Small bar** — Max 60 patrons, no gaming, often best cocktails

**Lockout Laws History:**
Sydney's controversial 2014 **lockout laws** (1:30am lockout, 3am last drinks in CBD/Kings Cross) were **removed in 2021** for most of Sydney CBD. Now:
- **No lockouts** in Sydney CBD
- 3:30am standard closing for many venues
- Some 24-hour liquor licenses exist
- Oxford Street/Darlinghurst has extended trading

---

### BYO Restaurants

BYO (Bring Your Own) is a beloved Sydney institution — especially for wine lovers wanting to drink quality bottles affordably.

**Typical Corkage Fees (2025-26):**

| Range | Fee | Examples |
|-------|-----|----------|
| Budget | $2-5/person | Bar Reggio ($2.50), Mami's Bondi ($4) |
| Mid-range | $7-15/bottle | MacLeay St Bistro ($14), Hojiak ($25) |
| Fine dining | $20-35/bottle | OTTO ($35), Sean's ($35), Loulou ($20) |

**BYO Rules:**
- Usually **wine only** (no beer/spirits)
- Some places limit to 750ml bottles
- Some offer free corkage on certain days (Sunday common)
- Always call ahead to confirm BYO policy

**Classic BYO Spots:**
- **Bar Reggio** (Darlinghurst) — Italian, absurdly cheap corkage
- **Bill & Toni's** (Darlinghurst) — Old-school Italian
- **Spice I Am** (Surry Hills) — Thai
- **Emma's Snack Bar** (Enmore) — Mediterranean
- **Two Chaps** (Marrickville) — Café/bistro

**Pro tip:** Buy wine from nearby bottle shops (BWS, Dan Murphy's) or boutique wine stores in the same suburb.

---

### Natural Wine Scene

Sydney has embraced natural wine enthusiastically. The **Inner West** is the epicenter.

**Top Natural Wine Bars:**
- **P&V Wine + Liquor Merchants** (Newtown) — Shop + bar
- **Monopole** (Potts Point) — Restaurant + excellent wine list
- **10 William St** (Paddington) — Italian, all-natural list
- **Love, Tilly Devine** (Darlinghurst) — Intimate wine bar
- **Poly** (Surry Hills) — Restaurant with great natty list

**Bottle Shops:**
- **P&V Wine** (Newtown)
- **Drnks** (Surry Hills)
- **Wines Unbottled** (Marrickville)

---

### Craft Beer

Sydney's craft beer scene exploded in the 2010s, centered on the **Inner West**.

**Breweries with Taprooms:**

| Brewery | Location | Known For |
|---------|----------|-----------|
| **Young Henrys** | Newtown | The OG Sydney craft brewery (since 2012), also serves natural wine & gin |
| **Batch Brewing Co.** | Marrickville | American-style ales, great taproom |
| **Wayward Brewing** | Camperdown | Sours, barrel-aged beers |
| **The Grifter** | Marrickville | IPAs, lively venue |
| **Sauce Brewing** | Marrickville | Hazy IPAs |
| **Akasha Brewing** | Five Dock | West Sydney option |
| **Willie the Boatman** | St Peters | Industrial setting |
| **One Drop Brewing** | Botany | Modern IPAs |

**Inner West Ale Trail:** Self-guided brewery crawl — most are walkable or short train rides from each other in Marrickville/Newtown.

**Craft Beer Bars (not breweries):**
- **The Local Taphouse** (Darlinghurst) — 20+ rotating taps
- **Bitter Phew** (Darlinghurst) — Intimate, great selection
- **Frankie's Pizza** (CBD) — Rock bar, good beer

---

### Cocktail Bars

**CBD:**
- **Maybe Sammy** — Art deco glamour, consistently ranked among world's best
- **Bulletin Place** — Tiny, ever-changing menu
- **PS40** — Creative, playful
- **Palmer & Co.** — Speakeasy vibes

**Surry Hills:**
- **Eau de Vie** — Speakeasy, exceptional
- **Shady Pines Saloon** — Country & western theme

**Kings Cross/Potts Point:**
- **Jangling Jack's** — Late night (until 1am Thu-Sat)
- **The Roosevelt** — Classic cocktails

**Newtown:**
- **Earl's Juke Joint** — Bourbon focus

---

### Wine Bars

- **10 William St** (Paddington) — Italian wines
- **Love, Tilly Devine** (Darlinghurst) — Intimate
- **Dear Sainte Éloise** (Potts Point) — French-focused
- **Monopole** (Potts Point) — Australian/European

---

### Late Night Drinking

After lockout repeal, options are better but Sydney still isn't a 24-hour city.

**Open Late (2-3am+):**
- **Frankie's Pizza** (CBD) — Until 3am
- **Midnight Shift** (Oxford St) — LGBTQ+ venue
- **The Star Casino** — 24 hours
- Various Kings Cross/Potts Point bars

---

## 3. Coffee Culture

### Flat White vs Latte

Both originated in Australia/New Zealand. The key differences:

| | Flat White | Latte |
|--|-----------|-------|
| **Milk texture** | Microfoam, velvety | More froth on top |
| **Coffee ratio** | Higher coffee-to-milk | More milk |
| **Serving** | Smaller (150-180ml) | Larger (200-250ml) |
| **Strength** | Stronger coffee flavor | Milder |

**Ordering guide:**
- **"Flat white"** — Default strong, milky coffee
- **"Long black"** — Espresso over hot water (like Americano but different order)
- **"Short black"** — Straight espresso
- **"Piccolo"** — Mini latte, single shot
- **"Magic"** — Melbourne invention (double ristretto with milk), increasingly available
- **"Iced long black"** — Common in summer

**Milk alternatives:** All good cafés offer oat, almond, soy — often no extra charge at specialty places.

---

### Best Roasters

Sydney has world-class coffee. In 2025, **Toby's Estate (Chippendale)** was crowned #1 coffee shop globally.

**Top Roasters:**

| Roaster | Location | Notes |
|---------|----------|-------|
| **Toby's Estate** | Chippendale | World's Best Coffee Shop 2025 |
| **Single O** | Surry Hills | Ranked 53rd globally (2026), innovative |
| **Mecca Coffee** | CBD/Alexandria | Consistently excellent |
| **Campos Coffee** | Newtown | Pioneer of Sydney specialty coffee |
| **Gumption by Coffee Alchemy** | CBD | Tiny, exceptional |
| **Edition Coffee Roasters** | Darlinghurst | Beautiful space |
| **Industry Beans** | CBD | Melbourne transplant |
| **Paramount Coffee Project** | Surry Hills | Trendy, great food too |
| **Only Coffee Project** | CBD | Ranked 4th globally (2026) |

---

### Coffee Neighborhoods

**Surry Hills:**
- Highest concentration of specialty cafés
- Single O, Paramount, Reuben Hills, Artificer

**Newtown:**
- Alternative vibe
- Campos, Brewtown Newtown

**CBD:**
- Hidden gems in laneways
- Gumption, Skittle Lane, Industry Beans

**Bondi:**
- Beach-café culture
- Porch & Parlour, Gertrude & Alice

---

### Ordering Guide

**Basics:**
- Queue at counter, order, pay, wait for your number
- Coffee averages **$4.50-5.50** for flat white/latte
- **No tipping** expected at coffee shops
- Many specialty places are cash-free

**Terminology:**
- "Takeaway" not "to-go"
- "Regular" is standard size (often only size available)
- "Strong" = extra shot
- "Weak" = less coffee

---

## 4. Tipping & Service

### The Basics

**Tipping is NOT expected in Australia.** Staff earn minimum wage ($24.10/hour as of 2025 for casual hospitality workers).

**Guidelines:**

| Situation | Tip? |
|-----------|------|
| Café/coffee | No |
| Casual restaurant | No |
| Fine dining, exceptional service | 5-10% appreciated but not expected |
| Taxi/rideshare | Rounding up common, tipping rare |
| Hotel porter | $2-5 optional |
| Bar | No (maybe round up) |

### Recent Changes (2025)

**Automatic service charges** are emerging at some high-end restaurants:
- Some venues (e.g., Tilda) add 7-10% "service charge"
- **Legally must be disclosed beforehand**
- **You can request removal**
- Controversial — seen as Americanization

### Credit Card Surcharges

**Currently legal** but:
- Can only charge actual processing costs (typically 1-2%)
- **RBA proposes banning** all card surcharges from July 2026
- Many restaurants add 1.5% for card payments
- Some smaller venues are cash-free anyway

### Splitting Bills

**Australians split bills constantly.** Unlike some countries, this is completely normal.

- **"Separate bills"** — Ask at start of meal
- **"Split evenly"** — Most venues happy to do this
- **Payment apps:** Most people use bank transfers or apps like **Up, Beem It** for splitting after
- Tap-and-go (contactless) is ubiquitous

---

## 5. Opening Hours

### General Patterns

**Cafés:** 7am-3pm typical (some all-day until 4-5pm)
**Restaurants:** Lunch 12-3pm, Dinner 6-10pm (11pm weekends)
**Pubs:** 10am-midnight (later licenses exist)

### Sunday Trading

**Historical restrictions largely gone.** Most restaurants/cafés now open Sunday with normal hours. Some small independent places close Sunday-Monday.

### Late Night Food (After 10pm)

**24-Hour Options:**
- **City Extra** (Circular Quay) — Diner-style, open 24/7
- **Pancakes on the Rocks** (The Rocks, Darling Square) — 24/7 or very late
- **Café Hernandez** (Potts Point) — 24 hours

**Late Night (until midnight-2am):**
- **Chinatown** — Many restaurants until 11pm-midnight
  - Golden Century (Haymarket)
  - Chinese Noodle King
  - Dae Jang Kum (Korean, until late)
- **Mamak** (Haymarket) — Malaysian, until late
- **Gumshara Ramen** (Haymarket) — Cult ramen
- **Jangling Jack's** (Potts Point) — Until 1am Thu-Sat

**Western Sydney late night:** El Jannah (Lebanese chicken) locations open late.

### Early Breakfast

Most cafés open 7am. For earlier:
- **Bourke Street Bakery** — Some locations from 6:30am
- **City Extra** — 24 hours
- **Bills** (various) — From 7am
- **Hotel restaurants** — Often from 6:30am

---

## 6. Food Delivery

### Apps Available

| App | Coverage | Notes |
|-----|----------|-------|
| **Uber Eats** | Best coverage | Most restaurants, highest fees |
| **DoorDash** | Wide coverage | Includes groceries |
| **Menulog** | Wide coverage | Owned by Just Eat; may close Australia operations |
| **Deliveroo** | Limited | Smaller presence in Australia |

### Typical Fees

**Delivery apps inflate prices significantly (36%+ more than in-store on average).**

**Fee breakdown:**
- **Menu markup:** 15-30% higher than in-restaurant
- **Delivery fee:** $0.99-10+ (varies by distance, demand)
- **Service fee:** ~5-10% of order
- **Total:** A $40 in-store meal often costs **$54+** via apps

### Ghost Kitchens

**Dark kitchens** (delivery-only operations) are common:
- **MrBeast Burger** — Operated out of existing kitchens
- **Virtual brands** — Many restaurants run multiple delivery-only brands from one kitchen

**How to spot:** Very generic names, suspiciously similar menus to other brands, no physical storefront if you search.

### Tips for Delivery

- **Order direct:** Many restaurants offer pickup/delivery via their own website — often cheaper
- **Pickup discounts:** 10-15% off for pickup on apps
- **Subscriptions:** Uber One ($9.99/month) offers $0 delivery fees on eligible orders
- **Compare:** Same restaurant prices can differ between apps

---

## Quick Reference

### Emergency Contacts
- **Ambulance/Police/Fire:** 000
- **Food poisoning reports:** NSW Food Authority 1300 552 406

### Useful Apps
- **HappyCow** — Vegan/vegetarian finder
- **Beanhunter** — Coffee shop reviews
- **Dimmi/The Fork** — Restaurant bookings
- **Google Maps** — Real-time opening hours

### Price Guide (AUD)
- **Coffee:** $4.50-5.50
- **Casual lunch:** $18-25
- **Mid-range dinner:** $40-70 pp
- **Fine dining:** $150-300+ pp
- **Beer (pint):** $10-14
- **Wine (glass):** $12-18

---

*Sydney's food scene rewards exploration. Don't stick to the tourist zones — the best eating is in the Inner West (Newtown, Marrickville), Eastern Suburbs (Surry Hills, Paddington), and ethnic enclaves (Lakemba, Auburn, Cabramatta). Ask locals for recommendations — Sydneysiders love talking about food.*
