# Sydney International Food Guide

Sydney is one of the world's most multicultural cities, and its food scene reflects this beautifully. From authentic Cantonese yum cha to Lebanese feasts in the suburbs, here's your guide to Sydney's international cuisines.

---

## 🥢 Chinese Cuisine

### Chinatown (Haymarket)
Sydney's Chinatown, centred around Dixon Street and Hay Street, is Australia's largest. What started as a Chinese enclave in the 1850s gold rush is now a vibrant Asian precinct.

**Top Picks:**
| Restaurant | Known For | Price |
|------------|-----------|-------|
| **The Eight** (Market City, Level 3) | Traditional yum cha with trolley service, massive 300+ seat venue | $$-$$$ |
| **Emperor's Garden** (96-100 Hay St) | Classic Cantonese since 1979, 350 seats, BBQ meats | $-$$ |
| **Royal Palace Seafood** (393-399 Sussex St) | Former Golden Century site, live seafood tanks, late-night dining until 3am | $$-$$$ |
| **Gumshara** (Eating World food court) | Legendary tonkotsu ramen, 300kg of pork bones daily | $ |
| **Nanjing Dumpling** | Duck, dumplings, flaky sesame rolls | $ |
| **Beijing Impression** | Peking duck, north-eastern Chinese specialties | $$-$$$ |
| **Spicy Joint** | Sichuan numbing hotpot, fiery flavours | $$ |
| **Spice World** | Futuristic hotpot with robot servers | $$ |
| **Xi'an Cuisine** | No-frills, dishes around $10, ancient flavours | $ |

### Chatswood
The north shore's Chinese food hub, particularly for Cantonese cuisine.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Star Capital Seafood** (399 Victoria Ave) | Premier yum cha, massive selection, RecipeTin Eats approved | $$-$$$ |
| **Canton 8 Seafood** | Regional Chinese specialties | $$ |
| **BBQ King** | Cantonese BBQ meats | $$ |

### Burwood
Known for Shanghainese and northern Chinese cuisines.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **New Shanghai** | Xiao long bao, pan-fried dumplings | $-$$ |
| **Taste of Shanghai** | Shanghainese classics, soup dumplings | $-$$ |

### Hurstville
Sydney's southern Chinese hub, particularly strong in Cantonese.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Golden Sands** | Leading yum cha destination | $$-$$$ |
| **Marigold Seafood** | Cantonese banquet style | $$-$$$ |

---

## 🍜 Vietnamese Cuisine

### Marrickville
The Inner West's Vietnamese heartland. Illawarra Road is lined with restaurants and bakeries.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Pho Pasteur** | Pho, rice paper rolls | $ |
| **Marrickville Pork Roll** | Iconic banh mi, queue-worthy | $ |
| **Eat Fuh** | Modern Vietnamese, pho variations | $-$$ |
| **An Restaurant** | Family-style Vietnamese | $$ |
| **Thanh Binh** | Traditional Vietnamese, great vermicelli bowls | $ |

### Cabramatta
"Little Saigon" – Sydney's most authentic Vietnamese area, 30km southwest of CBD. The real deal.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Hai Au Lang Nuong** | BBQ meats, engaging all senses (14/20 Good Food rating) | $-$$ |
| **Pho Tau Bay** | Legendary pho since 1982 | $ |
| **Tan Viet** | Broken rice, grilled meats | $ |
| **Cabramatta BBQ** | Roasted meats, rice dishes | $ |
| **Freedom Plaza** | Multiple food stalls, bánh cuốn, sugar cane juice | $ |

**Cabramatta Tips:**
- Go on weekend mornings for the full experience
- Freedom Plaza and the main strip on John Street are food heaven
- Try bánh mì from multiple bakeries – each has their signature

---

## 🌶️ Thai Cuisine

### Key Venues
| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Spice I Am** | Surry Hills | Fiery authentic Thai, cult following | $-$$ |
| **Chat Thai** | Multiple (Haymarket original) | Street food staples, late-night | $ |
| **Porkfat** | Chinatown | Long Chim alumnus, punchy street food, coconut ice cream | $$ |
| **Dodee Paidang** | Haymarket | Northern Thai, serious chilli heat | $-$$ |
| **Longrain** | Surry Hills | Upscale Thai, communal tables | $$$ |
| **Chin Chin** | Surry Hills | Modern Thai-inspired, buzzy atmosphere | $$-$$$ |

**Thai Town:** Campbell Street in Haymarket has the highest concentration of Thai restaurants in Sydney.

---

## 🍣 Japanese Cuisine

### Ramen
| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Gumshara** | Haymarket | Sydney's thickest, most intense tonkotsu | $ |
| **Ippudo** | CBD, Westfield | Consistently excellent tonkotsu from Fukuoka chain | $$ |
| **Ramen Zundo** | Multiple | Rich pork bone broth | $ |
| **Menya Noodle Bar** | CBD | Variety of ramen styles | $ |

### Sushi & Sashimi
| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Sokyo** | The Star | High-end Japanese, celebrity chef | $$$$ |
| **Sashimi Shinsengumi** | Crows Nest | Fresh sashimi platters | $$ |
| **Sushi-e** | CBD | Premium omakase | $$$$ |
| **Japasu by Sang** | Zetland | Elegant sushi without formality (15/20 Good Food) | $$$ |

### Izakaya
| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Yebisu Izakaya** | CBD | Authentic pub food, extensive sake | $$ |
| **Toko** | Surry Hills | Late-night, cocktails + Japanese | $$-$$$ |
| **Izakaya Fujiyama** | Crows Nest | Traditional izakaya dishes | $$ |

---

## 🥩 Korean Cuisine

### Strathfield
Sydney's Koreatown, particularly along The Boulevarde.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **678 Korean BBQ** | Premium meats, late-night | $$-$$$ |
| **Madang** | Traditional Korean, banchan variety | $$ |
| **Butcher's Kitchen** | BBQ, quality cuts | $$$ |

### CBD
| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Kogi** (Haymarket) | Modern Korean BBQ in Market City | $$-$$$ |
| **Sydney Madang** | Popular CBD Korean BBQ | $$-$$$ |
| **Mapo Korean** | Fried chicken, traditional dishes | $$ |

---

## 🍝 Italian Cuisine

### Leichhardt & Haberfield
Sydney's "Little Italy" – Norton Street is the heart.

| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Bar Italia** | Leichhardt | Classic Italian cafe culture | $ |
| **Cafe Gioia** | Leichhardt | Traditional pasta, family recipes | $$ |
| **La Disfida** | Haberfield | Wood-fired pizza, gelato | $$ |
| **Zanetti** | Haberfield | Coffee institution, pastries | $ |
| **Pasticceria Papa** | Multiple | Italian bakery, cannoli | $ |

**Norton Street Tips:**
- Great for a leisurely walk with coffee and pastries
- Multiple gelato options – Leichhardt is gelato central
- Many family-run restaurants with decades of history

---

## 🫒 Greek Cuisine

### Marrickville & Earlwood
Traditional Greek community areas.

| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Steki Taverna** | Marrickville | Family-style Greek, lamb | $$ |
| **Perama** | Marrickville | Traditional taverna atmosphere | $$ |
| **The Apollo** | Potts Point | Modern Greek, celebrity chef | $$$ |
| **Alpha Restaurant** | CBD | Contemporary Greek, Middle Eastern influence | $$$ |

---

## 🧆 Lebanese & Middle Eastern

### Lakemba, Bankstown & Auburn
Sydney's Middle Eastern heartland, particularly strong Lebanese and Turkish.

| Area | What to Find |
|------|--------------|
| **Lakemba** | Haldon Street has Lebanese bakeries, restaurants, sweet shops |
| **Bankstown** | Lebanese restaurants, charcoal chicken, sweets |
| **Auburn** | Turkish restaurants, Afghan cuisine, multicultural mix |

**Key Spots:**
| Restaurant | Location | Known For | Price |
|------------|----------|-----------|-------|
| **Jasmin 1** | Lakemba | Lebanese banquet feasts | $-$$ |
| **Al Aseel** | Multiple | Charcoal chicken chain, Lebanese | $ |
| **Almustafa** | Lakemba | Traditional Lebanese sweets | $ |
| **El Jannah** | Multiple | Cult-favourite charcoal chicken | $ |

---

## 🍛 Indian Cuisine

### Harris Park ("Little India")
Western Sydney's Indian hub, 23km from CBD. Wigram Street is the main strip.

| Restaurant | Known For | Price |
|------------|-----------|-------|
| **Chatkazz** | South Indian street food, dosas | $ |
| **Billu's** | North Indian, tandoori, curries | $-$$ |
| **Punjab Sweets** | Sweets, chaat, vegetarian | $ |
| **Taste of Kerala** | South Indian, banana leaf meals | $$ |

**Harris Park Tips:**
- Go hungry – portions are generous
- Try street snacks: pani puri, dahi puri, chaat
- Many purely vegetarian options
- Best on weekend evenings when it's buzzing

---

## 🍽️ Fine Dining

Sydney's restaurant scene competes globally. These are the city's most acclaimed restaurants.

### Top-Tier Fine Dining
| Restaurant | Location | Cuisine | Price | Notes |
|------------|----------|---------|-------|-------|
| **Quay** | The Rocks | Modern Australian | $$$$ | Peter Gilmore's flagship, harbour views, 3 hats |
| **Bennelong** | Opera House | Modern Australian | $$$$ | Inside the Opera House, Peter Gilmore | 
| **Aria** | Circular Quay | Modern Australian | $$$$ | Matt Moran's flagship, harbour views |
| **Tetsuya's** | CBD | Japanese-French | $$$$ | Legendary omakase, Tetsuya Wakuda |
| **Oncore by Clare Smyth** | Crown Sydney | Modern British | $$$$ | UK's first female 3-Michelin star chef |
| **LuMi** | Pyrmont | Italian-Japanese | $$$$ | 3 hats, Federico Zanellato |
| **Sixpenny** | Stanmore | Modern Australian | $$$$ | Dan Puskas, garden-to-plate |
| **Yellow** | Potts Point | Vegetarian | $$$ | Fine dining, vegetarian-focused |
| **Firedoor** | Surry Hills | Fire cooking | $$$$ | Lennox Hastie, all wood-fire |
| **Saint Peter** | Paddington | Seafood | $$$$ | Josh Niland, nose-to-tail fish |

---

## 🎩 The Hat System Explained

The **Good Food Guide** (published by Sydney Morning Herald) rates Australian restaurants using a "hat" system – Australia's equivalent of Michelin stars.

### How Hats Work
| Rating | What It Means |
|--------|---------------|
| **No Hat** | Good restaurant, but not exceptional |
| **One Hat** | A very good restaurant |
| **Two Hats** | Excellent restaurant |
| **Three Hats** | Outstanding restaurant (only a handful nationally) |

### Scoring
Restaurants are scored out of 20:
- **15-15.5**: One Hat
- **16-16.5**: Two Hats  
- **17-17.5**: Three Hats
- **18+**: Exceptional (rare)

### Current Sydney Three-Hat Restaurants (2025)
- **Quay** (The Rocks)
- **Oncore by Clare Smyth** (Crown Sydney)
- **LuMi** (Pyrmont)
- **Tetsuya's** (CBD)

### Notable Two-Hat Restaurants
Aria, Bennelong, Firedoor, Saint Peter, Sixpenny, Yellow, The Apollo, Mr Wong, Automata, Ormeggio, Pilu at Freshwater

**Tips:**
- Hats are awarded annually in September/October
- A hat is a significant achievement – only ~15% of reviewed restaurants earn one
- Some excellent restaurants don't have hats (not reviewed, or new)
- Price doesn't guarantee hats; value is considered

---

## Quick Neighbourhood Summary

| Cuisine | Go To |
|---------|-------|
| Chinese (Cantonese) | Haymarket, Chatswood, Hurstville |
| Chinese (Regional) | Burwood, Ashfield |
| Vietnamese | Marrickville, Cabramatta |
| Thai | Surry Hills, Haymarket |
| Japanese | CBD, Crows Nest |
| Korean | Strathfield, CBD |
| Italian | Leichhardt, Haberfield |
| Greek | Marrickville, Earlwood |
| Lebanese | Lakemba, Bankstown |
| Indian | Harris Park |
| Fine Dining | CBD, Circular Quay, The Rocks |
