# Sydney Education Guide

## 1. Schools Overview

### Public Schools (Government)
- **Free** for Australian citizens and permanent residents
- Operated by NSW Department of Education
- Follow the NSW curriculum
- Enrolment based on **catchment areas** (your address determines your local school)
- Check your catchment: [schoolfinder.education.nsw.gov.au](https://schoolfinder.education.nsw.gov.au/)
- Quality varies significantly by suburb (Eastern suburbs, North Shore generally ranked higher)

### Catholic Schools
- Run by Catholic Education Diocese of Sydney/Parramatta
- ~20% of NSW students attend Catholic schools
- Don't need to be Catholic (priority given to Catholic families)
- Lower fees than independent schools
- Strong values-based education

### Independent (Private) Schools
- Self-governing, funded by fees + some government subsidies
- Often affiliated with religious denominations (Anglican, Uniting, Jewish, etc.)
- Wide range of fees from affordable to extremely expensive
- Many have long waitlists—some families register at birth

### Selective Schools
- **Academically selective** public schools (free!)
- Entry via **Selective High School Placement Test** (Year 7 entry)
- Highly competitive—top 4-5% of students
- Major selective schools:
  - James Ruse Agricultural High (consistently #1 in HSC)
  - Sydney Boys High / Sydney Girls High
  - North Sydney Boys / North Sydney Girls
  - Baulkham Hills High
  - Hornsby Girls High
- Test includes: reading, mathematical reasoning, thinking skills, writing
- Many students do tutoring for 1-2 years to prepare

---

## 2. School Costs

### Public Schools
| Item | Cost |
|------|------|
| Tuition | **Free** |
| Voluntary contributions | $50-200/year |
| Subject fees (materials) | $100-400/year |
| Uniforms | $200-400 |
| Excursions/camps | $100-500/year |
| **Total typical** | **$500-1,000/year** |

### Catholic Schools
| Level | Annual Fees |
|-------|-------------|
| Primary | $2,000-4,000 |
| Secondary | $4,000-8,000 |
| **Plus:** uniforms, excursions, levies | +$500-1,000 |

### Independent (Private) Schools
| Tier | Annual Fees |
|------|-------------|
| Lower-range independent | $15,000-25,000 |
| Mid-range independent | $25,000-35,000 |
| Elite private | $35,000-45,000+ |

### Top Private Schools (2024-25 fees)
| School | Annual Fee (Year 12) | Notes |
|--------|---------------------|-------|
| **Sydney Grammar** | ~$42,000 | Day school, boys |
| **SCEGGS Darlinghurst** | ~$38,000 | Girls, Anglican |
| **Knox Grammar** | ~$40,000 | Boys, Presbyterian |
| **Cranbrook** | ~$44,000 | Boys, Anglican |
| **Ascham** | ~$38,000 | Girls |
| **Kambala** | ~$36,000 | Girls |
| **The King's School** | ~$45,000 | Boys, boarding available |
| **SHORE** | ~$38,000 | Co-ed senior, Uniting |

**💡 Reality check:**
- Fees increase 3-5% yearly
- Add $2,000-5,000 for uniforms, camps, excursions, levies
- Boarding adds $25,000-35,000/year
- Building funds/capital levies: $500-2,000/year additional
- Sibling discounts: typically 5-20% for 2nd+ child

---

## 3. School Quality Indicators

### NAPLAN (National Assessment Program)
- Standardised testing in Years 3, 5, 7, 9
- Tests: reading, writing, conventions (spelling/grammar), numeracy
- Results available on **MySchool** website
- Compare your school to similar schools nationwide
- Results moved to online testing (2023+)

### HSC Results
- Higher School Certificate (final Year 12 exams)
- ATAR (Australian Tertiary Admission Rank) derived from HSC
- School rankings published annually in media
- Top 10 typically dominated by selective schools
- **Warning:** Raw rankings don't account for student intake—check "value added"

### MySchool Website
- **[myschool.edu.au](https://myschool.edu.au)**
- Compare any Australian school
- Data includes:
  - NAPLAN results
  - Financial information
  - Student demographics
  - Index of Community Socio-Educational Advantage (ICSEA)
- Look at schools similar to yours (ICSEA comparison)

### Selective School Entry
- **Test date:** Usually March for Year 7 entry following year
- Register via education.nsw.gov.au (usually opens October)
- Test components weighted differently by school preference
- Results: May/June
- Offers: July
- **Tutoring industry:** Multi-million dollar industry exists around selective entry

---

## 4. Universities

### Group of Eight (Go8)
Australia's research-intensive universities (equivalent to "Ivy League"):

| University | World Ranking* | Strengths |
|------------|----------------|-----------|
| **University of Sydney (USYD)** | #18 | Law, Medicine, Arts, Business |
| **UNSW Sydney** | #19 | Engineering, Computer Science, Business, Medicine |

*QS World Rankings 2024 - both consistently top 50 globally

### Other Major Sydney Universities
| University | Ranking | Known For |
|------------|---------|-----------|
| **UTS (University of Technology Sydney)** | Top 100 | Tech, Design, Business, Nursing |
| **Macquarie University** | Top 150 | Business, Psychology, Linguistics |
| **Western Sydney University (WSU)** | Top 250 | Nursing, Education, accessible admissions |

### Costs for Domestic Students (Citizens/PR)

**HECS-HELP** (Government loan scheme):
- You DON'T pay upfront
- Loan repaid through tax once earning above threshold (~$54,435/year in 2024)
- Repayment rates: 1-10% of income based on earnings
- No interest, but indexed to inflation (CPI)
- **You essentially never pay if you never earn above threshold**

**Annual tuition (2024 Commonwealth Supported Places):**
| Field | Annual Fee |
|-------|------------|
| Humanities, Education, Nursing | $4,000-8,000 |
| Science, Engineering | $8,000-12,000 |
| Law, Business | $11,000-15,000 |
| Medicine, Dentistry | $12,000-15,000 |

### Costs for International Students
| Degree Type | Annual Tuition |
|-------------|----------------|
| Undergraduate | $25,000-50,000 |
| Postgraduate coursework | $30,000-50,000 |
| MBA | $45,000-90,000 |
| Medicine | $70,000-80,000 |

**Total cost for international student (4-year degree):**
- Tuition: $100,000-200,000
- Living costs: $100,000-140,000
- **Total: $200,000-340,000+**

---

## 5. International Students

### Student Visa (Subclass 500)
- Required for full-time study in Australia
- Apply through ImmiAccount online
- Processing: 1-4 months
- Cost: ~$710 (2024)

**Requirements:**
- Confirmation of Enrolment (CoE) from registered institution
- Genuine Temporary Entrant (GTE) statement
- English proficiency (IELTS 5.5-7.0 depending on course)
- Financial capacity proof (~$24,505/year living costs + tuition + travel)
- Overseas Student Health Cover (OSHC)
- Health examinations if required

### Work Rights
- **20 hours/week** during semester (was unlimited during COVID, reverted)
- **Unlimited hours** during scheduled breaks
- Partner visa (subclass 500 dependent) also gets work rights

### OSHC (Overseas Student Health Cover)
- **Mandatory** for student visa
- Cost: ~$500-700/year single, ~$3,000-4,000/year family
- Providers: Medibank, Allianz, Bupa, CBHS, ahm
- Covers hospital, medical, some extras
- **NOT Medicare**—separate system

### Pathway Programs
If you don't meet direct entry requirements:

| Program | Purpose | Duration |
|---------|---------|----------|
| **Foundation Studies** | Bridge Year 12 to university | 8-12 months |
| **Diploma programs** | Fast-track to Year 2 of degree | 8-16 months |
| **English language (ELICOS)** | Improve English to meet requirements | 5-50 weeks |
| **University pathway colleges** | Navitas, Kaplan, Study Group | Varies |

**Popular pathway colleges:**
- Taylors College (USYD foundation)
- UNSW Global
- UTS:INSEARCH
- Macquarie University International College

---

## 6. Childcare

### ⚠️ The Real Talk on Sydney Childcare
- **Extremely expensive**
- **Waitlists are LONG** (6-18 months is normal)
- Put your name on lists **as soon as pregnant** for good centres

### Types of Childcare

| Type | Ages | Hours | Cost/Day |
|------|------|-------|----------|
| **Long Day Care (LDC)** | 0-5 years | 7am-6pm, 5 days | $100-180 |
| **Family Day Care** | 0-5 years | Flexible | $80-130 |
| **Preschool/Kindergarten** | 3-5 years | Limited hours (9am-3pm) | $50-100 |
| **Occasional Care** | 0-5 years | Casual sessions | $15-20/hour |
| **Outside School Hours Care (OSHC)** | 5-12 years | Before/after school | $20-35/session |

### Actual Costs (Sydney 2024-25)
| Area | Daily Rate (LDC) |
|------|------------------|
| Inner West | $140-170 |
| Eastern Suburbs | $150-180 |
| North Shore | $140-175 |
| Northern Beaches | $135-160 |
| Western Sydney | $100-140 |
| **Sydney average** | **~$140-150/day** |

**Annual cost before subsidy:** ~$35,000-45,000 for 5 days/week

### Childcare Subsidy (CCS)
Federal government subsidy based on:
1. **Family income**
2. **Activity level** (work/study hours)
3. **Type of care**

| Family Income | Subsidy Rate |
|---------------|--------------|
| <$80,000 | 90% |
| $80,000-$530,000 | 90% sliding to 0% |
| >$530,000 | 0% |

**Hourly rate cap (2024):** ~$13.73/hour (centre-based)
- Subsidy only applies up to cap
- If centre charges $18/hour, you pay the gap

**Example calculation:**
- Daily fee: $150 (10 hours)
- Hourly: $15
- Income: $150,000 → ~65% subsidy
- CCS pays: ~$89
- **Out of pocket: ~$61/day**

**Annual out of pocket (typical dual income family):** $15,000-25,000

### Waitlist Reality
- **Inner city/Eastern suburbs:** 12-24 month waitlists
- **Northern beaches/North Shore:** 12-18 months
- **Western Sydney:** 3-12 months
- **New developments:** Can be shorter

**Tips:**
- Register at multiple centres
- Registration fees: $20-50 each
- Visit centres to get priority
- Ask about sibling priority if you have older kids
- Company-sponsored centres may have shorter waits

---

## 7. Adult Education

### TAFE NSW (Technical and Further Education)
- **Vocational education and training (VET)**
- Practical, job-ready skills
- Certificates I-IV, Diplomas, Advanced Diplomas
- Much cheaper than university
- Often leads directly to employment

**Popular courses:**
- Aged Care / Disability Support
- Early Childhood Education
- Business Administration
- IT / Cybersecurity
- Building & Construction
- Hospitality / Commercial Cookery
- Hair & Beauty

**Costs:**
- Smart and Skilled subsidised: $1,000-5,000 for full diploma
- Fee-free TAFE (eligible courses): $0
- Full fee: $5,000-20,000 depending on course
- VET Student Loans available for diploma+ level

### English Language Schools (ELICOS)
For non-native speakers needing to improve English:

| Type | Cost/Week | Duration |
|------|-----------|----------|
| General English | $250-400 | 5-50 weeks |
| Academic English | $300-450 | 10-20 weeks |
| IELTS Preparation | $300-450 | 4-12 weeks |

**Popular schools:**
- Navitas English
- UNSW Institute of Languages
- University of Sydney CET
- Kaplan International
- ILSC Sydney

### Professional Development
| Provider | Focus |
|----------|-------|
| **General Assembly** | Tech bootcamps (coding, UX, data) |
| **Academy Xi** | Digital skills, 12-week intensives |
| **AICD** | Company Directors courses |
| **CPA/CA** | Accounting qualifications |
| **Industry associations** | Sector-specific CPD |

### Skills NSW Programs
- **Fee-Free TAFE:** Various priority courses at no cost
- **Smart and Skilled:** Subsidised training for NSW residents
- **Apprenticeships:** Earn while you learn (3-4 years)
- **Traineeships:** Shorter on-job training (1-2 years)

---

## Quick Reference: Education Costs Summary

| Stage | Free/Public | Mid-Range | Premium |
|-------|-------------|-----------|---------|
| **Childcare** | Subsidised ~$15k/year | $20-25k/year | $35-45k/year |
| **Primary** | ~$500-1k/year | $3-8k/year | $25-35k/year |
| **Secondary** | ~$800-1.5k/year | $5-12k/year | $35-45k/year |
| **University** | HECS (pay later) | - | Full fee $25-50k/year |

---

## Key Websites

| Resource | URL |
|----------|-----|
| MySchool | myschool.edu.au |
| School Finder (Catchments) | schoolfinder.education.nsw.gov.au |
| Selective Schools | education.nsw.gov.au/schooling/selective-schools |
| NESA (NSW Education Standards) | educationstandards.nsw.edu.au |
| Study Australia | studyaustralia.gov.au |
| Services Australia (CCS) | servicesaustralia.gov.au/child-care-subsidy |
| TAFE NSW | tafensw.edu.au |
| UAC (University Admissions) | uac.edu.au |

---

*Last updated: February 2026*
