# Driving in Sydney 🚗

A practical guide for newcomers on cars, licenses, costs, and road culture.

---

## 1. Do You Need a Car?

### Quick Decision by Area

| Area | Need Car? | Why |
|------|-----------|-----|
| **Inner city** (CBD, Surry Hills, Newtown, Pyrmont) | ❌ No | Excellent trains, buses, light rail. Parking nightmare |
| **Inner West** (Marrickville, Leichhardt, Ashfield) | 🤔 Maybe | Good transport but car helps for IKEA runs |
| **Eastern suburbs** (Bondi, Coogee, Randwick) | 🤔 Maybe | Buses good, but beaches + shopping easier with car |
| **Northern Beaches** (Manly, Dee Why, Newport) | ✅ Yes | Limited bus service, spread-out suburbs |
| **North Shore** (Chatswood, St Leonards) | 🤔 Maybe | Train line good, but depends on exact location |
| **Western suburbs** (Parramatta, Penrith, Blacktown) | ✅ Yes | Car-dependent, spread out, big shopping centers |
| **Southern suburbs** (Hurstville, Sutherland) | ✅ Yes | Train exists but car makes life much easier |

### Decision Framework

**Get a car if:**
- You live 15+ min walk from a train station
- You work in a different suburb than you live
- You have kids (school runs, activities)
- You want to explore NSW (beaches, mountains, wine regions)
- Your job requires driving (tradies, sales, etc.)

**Skip the car if:**
- You live and work near train lines
- You're happy using rideshare (Uber/DiDi/Ola)
- You're in Sydney short-term (<6 months)
- Budget is tight (cars are expensive to run)

**Alternative:** Many people use GoGet (car share) or rent occasionally for trips.

---

## 2. Getting Licensed

### International License (Visitors)

**Rules for tourists/visitors:**
- Your overseas license is valid in NSW **while you're a visitor**
- Must carry the physical license + English translation (if not in English)
- NAATI-certified translation required
- Valid as long as your visa allows you to be a visitor

**Rules for new residents:**
- Once you become a permanent resident or have been in Australia 3+ months, you should convert your license
- Temporary visa holders: Check specific visa conditions, but generally 3-6 months grace period

### Converting an Overseas License

This varies SIGNIFICANTLY by country. NSW has "recognised countries" with easier conversion.

**Recognised Countries (no driving test required):**
- USA, Canada, UK, Ireland
- Most EU countries (Germany, France, Spain, Italy, etc.)
- Japan, South Korea, Singapore, Hong Kong
- New Zealand
- Switzerland, Norway

**Process for recognised countries:**
1. Book appointment at Service NSW
2. Bring: passport, visa, overseas license, translation (if needed), proof of address
3. Pass eyesight test
4. Pay fee (~$60-80)
5. Get NSW license on the spot

**Non-recognised countries:**
- Must pass **driving test** (practical driving assessment)
- May need to pass **knowledge test** (DKT)
- Book through Service NSW
- Cost: ~$50 DKT + ~$65 driving test + license fee

### NSW License Classes

| Class | Description |
|-------|-------------|
| **C** | Car license (standard) |
| **LR** | Light Rigid (trucks up to 8 tonnes) |
| **MR** | Medium Rigid |
| **HR** | Heavy Rigid |
| **HC** | Heavy Combination |
| **MC** | Multi-Combination |
| **R** | Motorcycle |
| **RE** | Motorcycle (restricted) |

Most people need **Class C**. Motorcycle requires separate license.

### Getting NSW License From Scratch

If you don't have an overseas license (or it's not recognised):

**Step 1: Learner License (Ls)**
- Pass Driver Knowledge Test (DKT) - 45 questions
- Pay ~$30 for DKT + ~$30 for Ls
- Restrictions: Must drive with licensed supervisor, L plates displayed, 0% alcohol
- Under 25s: Must complete **120 hours** of logged driving (including 20 hours at night)

**Step 2: Provisional P1 License (Red Ps)**
- Hold Ls for 12 months (if under 25) or 3 months (25+)
- Pass driving test (~$65)
- Restrictions: 90 km/h max, 1 passenger under 21 (11pm-5am), no hands-free phone, 0% alcohol
- Hold for 12 months minimum

**Step 3: Provisional P2 License (Green Ps)**
- Pass Hazard Perception Test (~$25)
- Restrictions: 100 km/h max, 0% alcohol
- Hold for 24 months minimum (or until 20 if you're under 20)

**Step 4: Full License**
- Pass Driver Qualification Test (~$25)
- No restrictions

**Total time from Ls to Full License: 4+ years if under 25**

---

## 3. Buying a Car

### New vs Used

**New cars:**
- ✅ Warranty (3-7 years depending on brand)
- ✅ Latest safety features
- ✅ Financing deals available
- ❌ Depreciation (loses 20-30% value in first year)
- ❌ More expensive

**Used cars (recommended for newcomers):**
- ✅ Much cheaper
- ✅ Depreciation already absorbed
- ✅ Lower insurance costs
- ❌ Potential hidden problems
- ❌ Shorter/no warranty

### Where to Buy

**Dealers:**
- ✅ Statutory warranty (3 months or 5,000km for cars under 10 years and <160,000km)
- ✅ Can finance through dealer
- ❌ Higher prices (10-20% markup)
- ❌ Pressure sales tactics

**Private Sale:**
- ✅ Cheaper (no dealer margin)
- ✅ Can negotiate directly
- ❌ No statutory warranty (sold "as is")
- ❌ Must do your own due diligence
- ❌ Scam risk

**Where to Find:**
- **Carsales.com.au** - Largest marketplace (dealers + private)
- **Facebook Marketplace** - Growing, more private sellers
- **Gumtree** - Mixed quality, be careful of scams
- **CarSales dealer sites** - Specific dealer inventory
- **Pickles/Manheim** - Auctions (for experienced buyers)

### PPSR Check (CRITICAL!)

**Before buying ANY used car, do a PPSR check:**
- Website: **ppsr.gov.au**
- Cost: ~$2-4 per search
- Reveals: 
  - Money owing on the car (encumbrance)
  - Stolen vehicle status
  - Written-off status
  - Previous registration details

**If there's money owing:** The finance company can repossess the car even after you've bought it. NEVER skip this check.

### What to Check When Buying

**Documents:**
- [ ] Registration papers match the seller
- [ ] Service history (logbook stamps)
- [ ] PPSR certificate (no money owing)
- [ ] Roadworthy certificate (pink slip/blue slip)

**Physical inspection:**
- [ ] Matching VIN (dashboard, door jamb, engine bay)
- [ ] Even panel gaps (no accident repairs)
- [ ] Tyre wear (even across all 4)
- [ ] Engine sounds smooth (no knocking)
- [ ] Test all electrics (windows, AC, lights)
- [ ] Check for rust (wheel arches, undercarriage)
- [ ] Inspect under the oil cap (no white gunk = good)
- [ ] Test drive on highway if possible

**Consider:** Pre-purchase inspection from NRMA or a mechanic (~$150-300). Worth it for peace of mind.

### Price Guide (Popular Models)

*Approximate prices for used cars in good condition, 2024-2025:*

| Car | Age | Km | Price Range |
|-----|-----|-----|-------------|
| **Toyota Corolla** | 3-5 years | 50-80k | $18,000-25,000 |
| **Toyota Corolla** | 7-10 years | 100-150k | $10,000-16,000 |
| **Mazda 3** | 3-5 years | 50-80k | $18,000-26,000 |
| **Mazda CX-5** | 3-5 years | 50-80k | $28,000-38,000 |
| **Hyundai i30** | 3-5 years | 50-80k | $16,000-22,000 |
| **Kia Cerato** | 3-5 years | 50-80k | $15,000-21,000 |
| **Toyota RAV4** | 3-5 years | 50-80k | $30,000-42,000 |
| **Mitsubishi ASX** | 3-5 years | 50-80k | $18,000-24,000 |

**Best value picks for newcomers:**
- **Toyota Corolla/Camry** - Bulletproof reliability, cheap to service
- **Mazda 3** - Fun to drive, good quality
- **Hyundai i30/Kia Cerato** - Great value, long warranty if buying recent used

---

## 4. Ongoing Costs

### Registration (Rego)

**What it includes:**
- Registration fee
- Motor vehicle tax
- CTP insurance (see below)

**Cost breakdown (standard car, petrol, Sydney metro):**

| Component | Cost (approx) |
|-----------|---------------|
| Registration | ~$80 |
| Motor vehicle tax | ~$300-500 (based on weight) |
| **Total rego portion** | **~$400-600/year** |

**When:** Renew annually or half-yearly (6-month option available)

### CTP Insurance (Greenslip)

**Compulsory for all registered vehicles. Covers injury to others in accidents.**

**Providers:** NRMA, QBE, Allianz, GIO, AAMI, Youi

**Cost factors:**
- Your age (young drivers pay more)
- Car type
- Where you live (postcode rating)
- Driving history

**Typical costs:**
- Over 30, good history: $400-600/year
- Under 25: $700-1,200/year

**Tip:** Compare on **greenslips.nsw.gov.au** - prices vary significantly

### Comprehensive Insurance (Optional but Recommended)

**What it covers:** Damage to YOUR car (theft, accident, fire, hail)

**Cost range:** $800-2,500/year depending on:
- Car value
- Your age
- Where you park (street vs garage)
- Excess amount you choose
- Claims history

**Cheaper options:**
- Higher excess (pay more if you claim)
- Third-party property only (~$300-500/year) - covers damage to OTHER cars, not yours

**Tip:** Get quotes from Budget Direct, Bingle, Youi, AAMI. Online-only insurers often cheaper.

### Fuel Costs

**Current Sydney prices (2024-2025):**
- Unleaded 91: $1.70-2.10/L (varies weekly)
- Premium 95/98: $1.85-2.30/L
- Diesel: $1.75-2.15/L

**Fuel cycle:** Sydney has a weekly price cycle. Cheapest usually Tuesday/Wednesday, most expensive Friday-Sunday.

**Apps to find cheap fuel:**
- **PetrolSpy** - User-reported prices
- **MotorMouth** - Price tracking
- **7-Eleven Fuel Lock** - Lock in cheap prices

**Monthly fuel budget (average driver, 1,000km/month):**
- Small car (7L/100km): ~$140-170/month
- Medium SUV (9L/100km): ~$180-210/month
- Large SUV (11L/100km): ~$220-260/month

### Servicing

**Typical service intervals:** Every 10,000-15,000 km or 12 months

| Service Type | Cost |
|--------------|------|
| **Minor service** (oil, filter, check) | $150-300 |
| **Major service** (plugs, brakes check, fluids) | $400-700 |
| **Tyres** (set of 4, mid-range) | $400-800 |
| **Brake pads** (front) | $200-400 |
| **Battery replacement** | $150-300 |

**Where to service:**
- **Dealer:** More expensive, keeps warranty valid
- **Independent mechanic:** Cheaper, good for older cars
- **Ultratune/Midas/Kmart Tyre:** Budget option, basic services

### Total Annual Cost Estimate

**Budget for owning a mid-range car in Sydney:**

| Item | Cost/Year |
|------|-----------|
| Registration | ~$500 |
| CTP (Greenslip) | ~$550 |
| Comprehensive insurance | ~$1,000 |
| Fuel | ~$2,000 |
| Servicing/repairs | ~$800 |
| **TOTAL** | **~$4,850/year** |

*Plus parking, tolls, and any loan repayments*

---

## 5. Parking

### CBD Parking

**It's expensive. Very expensive.**

| Option | Cost |
|--------|------|
| **Street parking (metered)** | $7-8/hour, 2-hour max |
| **Wilson/Secure Parking** | $50-80/day, $350-600/month |
| **Early bird** (in before 9am) | $25-40/day |

**Tips:**
- Park at a train station and take public transport in
- Use **Wilson Parking app** or **Secure Parking app** for pre-booking
- Check **Parkopedia** for cheaper options nearby

### Street Parking Rules

**Signs are confusing but important:**

- **1P, 2P, 4P** = 1 hour, 2 hour, 4 hour max parking
- **Ticket** = Pay at meter
- **Permit holders excepted** = Residents with permits can park longer
- **No stopping** = Don't even think about it
- **No parking** = Can stop briefly to drop off/pick up
- **Clearway** = No stopping during times shown (towed immediately)
- **Loading zone** = Commercial vehicles only during times shown

**Fines are harsh:**
- Overtime parking: $130
- No parking zone: $280
- Clearway: $400+ and towing (~$500 to get car back)

### Residential Parking Permits

If you live in a permit area:
- Apply through your local council
- Cost: $50-150/year depending on council
- Allows parking in resident zones without time limits
- Usually limited to 2 permits per household

### Beach Parking

**Summer = nightmare**

- **Bondi Beach:** Arrive before 8am or forget it. $8/hour metered
- **Coogee:** Slightly better, but fills fast. Street parking limited
- **Manly:** Ferry in is easier than parking. Wilson lot $50+/day in summer
- **Northern Beaches:** Easier parking but still busy on hot days

**Tips:**
- Go early (before 8am) or late (after 4pm)
- Weekdays much better than weekends
- Consider parking 15-20 min walk away in residential streets (check signs!)
- Use public transport if possible

---

## 6. Tolls

### Sydney's Toll Road Network

Sydney has one of the most extensive toll networks in the world. It adds up fast.

**Toll roads:**
- **Sydney Harbour Bridge** ($4-5)
- **Sydney Harbour Tunnel** ($4-5)
- **Eastern Distributor** ($8)
- **Cross City Tunnel** ($6)
- **Lane Cove Tunnel** ($4)
- **M2** (Hills Motorway) (up to $8)
- **M5** (South-West Motorway) (up to $7)
- **M7** (WestLink) (up to $10, distance-based)
- **WestConnex** (M4/M5/M8) (up to $10)
- **NorthConnex** (up to $8)

*Prices are approximate and vary by time of day*

### E-Tag Setup

**You need an e-tag or account to use toll roads. Otherwise: big fines.**

**Providers:**
- **Linkt** (most common) - linkt.com.au
- **E-Toll** (NSW Government) - myetoll.nsw.gov.au

**Cost:**
- Account: Free
- E-tag (device): Free from Linkt
- Admin fee: ~$1.50/month
- Just use the app/website, no physical tag needed for most modern systems

**Tip:** Set up an account BEFORE you drive on toll roads. If you drive without one, you have 3 days to pay online (no penalty). After that: fines stack up.

### Toll Cost Examples

**Daily commute costs (each way):**

| Route | Toll (approx) |
|-------|---------------|
| Parramatta → CBD via M4/WestConnex | $8-10 |
| Northern Beaches → CBD via M2/Tunnel | $10-12 |
| Sutherland → CBD via M5/Cross City | $10-12 |
| Hornsby → CBD via NorthConnex/Harbour | $10-14 |

**Monthly toll budget for regular commuter: $200-500**

**Toll-free alternatives:** Surface roads exist but add 20-40 min to most trips. Many people pay tolls for time savings.

---

## 7. Driving Culture

### Left Side of the Road

**Australia drives on the LEFT.** 
- Steering wheel on the RIGHT
- Give way to the RIGHT at roundabouts and intersections
- Overtake on the RIGHT (passing on the left = illegal on single lanes)

**If you're from a right-side country:** Take it slow for the first few days. Turning is where you'll make mistakes.

### Speed Limits (Strictly Enforced)

| Zone | Limit |
|------|-------|
| School zones (8-9:30am, 2:30-4pm) | 40 km/h |
| Residential streets | 50 km/h |
| Main roads | 60-80 km/h |
| Highways | 100-110 km/h |

**Tolerances are TINY:** 
- Fixed cameras: Trigger at ~3 km/h over
- Mobile cameras: Same
- Police: May give warning for 1-5 over, but don't count on it

**Fines:**
- 1-10 km/h over: ~$130 + 1 demerit point
- 10-20 km/h over: ~$300 + 3 points
- 20-30 km/h over: ~$500 + 4 points
- 30-45 km/h over: ~$950 + 5 points + license suspension
- 45+ over: Court, massive fines, long suspension

### Mobile Speed Cameras

**Unmarked cars with cameras inside.** They park on roadsides, in medians, on overpasses.

- **No warning signs** (NSW removed mandatory signage)
- Can be anywhere, anytime
- Use Waze app for community reports (not guaranteed)

**Just stick to the limit.** It's not worth it.

### Roundabout Rules

1. **Give way to vehicles already in the roundabout** (to your right when entering)
2. **Signal:** Left = exiting now. Right = going more than halfway around
3. **Multi-lane roundabouts:** Left lane for left/straight. Right lane for right/U-turn
4. **Keep your lane** through the roundabout

### Merging Etiquette ("Zipper Merge")

**When lanes merge:**
- Alternate one car from each lane ("zipper")
- Don't speed up to block people
- Don't cut in at the last second (technically legal but very rude)

**Hook turns (Melbourne thing, not Sydney):** Not required in Sydney

### Mobile Phone Rules

**Extremely strict in NSW:**
- **No touching phone AT ALL while driving** (even at red lights)
- Must be in a cradle if using GPS/music
- Only fully hands-free calls allowed
- P-platers: NO phone use at all, even hands-free

**Fines:** $400-500 + 5 demerit points. Cameras now detect phone use automatically.

### Alcohol Limits

| License Type | Limit |
|--------------|-------|
| **Full license** | 0.05 BAC |
| **P1/P2 (provisional)** | 0.00 BAC |
| **Learners** | 0.00 BAC |

**Random breath testing (RBT):** Very common. Police set up checkpoints on major roads, especially weekends/holidays.

---

## 8. Electric Vehicles (EVs)

### The Market

EVs are growing fast in Australia but still a small percentage of sales. Charging infrastructure is improving but not yet comprehensive.

**Popular EVs in Australia:**
- **Tesla Model 3/Y** (most common)
- **BYD Atto 3** (good value)
- **Hyundai Ioniq 5/6**
- **Kia EV6**
- **MG ZS EV** (budget option)
- **Polestar 2**

### NSW Incentives

**As of 2024-2025:**
- **Stamp duty exemption** for EVs under $78,000 (saves $2,000-5,000)
- **$250 rebate** on charging equipment installation
- **Free rego** for EVs (first year)
- **No road user charge yet** (but coming)

**Federal:**
- No import tariffs on EVs = cheaper prices
- FBT exemption for salary-sacrificed EVs (big benefit if employer offers)

### Charging

**Types:**
- **Level 1 (home plug):** 3-5 km of range per hour. Overnight charging
- **Level 2 (home charger/public):** 30-50 km of range per hour. 4-8 hours for full charge
- **Level 3 (DC fast charging):** 200-400 km per 30 min. Road trips/emergencies

**Networks:**
- **Tesla Superchargers** (now open to non-Tesla)
- **Chargefox** - Largest Australian network
- **Evie** - Growing network
- **NRMA** - Free charging at some locations (for members)
- **Ampol/BP Pulse** - At petrol stations

**Apps:**
- **PlugShare** - Find all chargers
- **Chargefox app** - Pay for Chargefox chargers
- **A Better Route Planner** - Plan EV road trips

### Cost Comparison

| | Petrol Car | Electric |
|-|------------|----------|
| Fuel cost per km | ~$0.15 | ~$0.04 (home charging) |
| Monthly fuel/charging (1,000km) | ~$150 | ~$40 |
| Servicing | Higher (oil, filters, etc.) | Lower (no oil, fewer parts) |
| Upfront cost | Lower | Higher (but dropping) |

**Break-even:** Usually 3-5 years if comparing similar cars

### Practical Considerations

**Good for EV:**
- You can charge at home (house/garage)
- Daily driving under 200km
- Mostly city/suburban driving
- You want lower running costs

**Challenging for EV:**
- No home charging (apartment)
- Regular long road trips
- Remote area driving
- Towing (range drops significantly)

---

## Quick Reference Card

### First Month Checklist

- [ ] Decide if you need a car
- [ ] Check license requirements (convert or test?)
- [ ] Set up Linkt/E-Toll account
- [ ] Download: Waze, PetrolSpy, PlugShare (if EV), Opal Travel
- [ ] Understand parking signs in your area
- [ ] Know your area's permit parking rules

### Key Numbers

| Item | Cost |
|------|------|
| License conversion | ~$60-80 |
| DKT test | ~$30 |
| Driving test | ~$65 |
| Rego (annual) | ~$500 |
| CTP (annual) | ~$500-700 |
| Insurance (annual) | ~$800-1,500 |
| PPSR check | ~$4 |

### Emergency Contacts

- **Police/Ambulance/Fire:** 000
- **NRMA Roadside:** 132 132
- **Report traffic incidents:** 131 444
- **Report road hazards:** Transport for NSW app

---

*Last updated: February 2026*
*Prices are approximate and subject to change. Always check official sources for current fees and regulations.*
