# Starting a Business in Sydney, Australia

> **Last Updated:** February 2026  
> Practical guide for setting up a business in Sydney/NSW

---

## 1. Business Structures

### Sole Trader
- **Best for:** Freelancers, single-person businesses, testing ideas
- **Cost:** FREE (just ABN registration)
- **Liability:** Unlimited personal liability
- **Tax:** Personal income tax rates (19-45%)
- **Pros:** Simplest structure, cheapest, easy to set up
- **Cons:** Personally liable for all debts, harder to raise investment

**Setup time:** Same day (ABN instant in most cases)

### Partnership
- **Best for:** Two or more people running a business together
- **Cost:** FREE (just ABN) + partnership agreement (recommended: ~$500-2,000 for lawyer-drafted)
- **Liability:** Each partner personally liable for business debts
- **Tax:** Profits distributed to partners, taxed at individual rates
- **Pros:** Share workload and capital, flexible
- **Cons:** Partners liable for each other's actions, disputes can destroy the business

**Recommendation:** Always have a written partnership agreement.

### Company (Pty Ltd)
- **Best for:** Startups seeking investment, businesses wanting limited liability
- **Cost:** 
  - ASIC registration: **$597** (standard) or **$538** (reduced, if eligible)
  - Annual review fee: **$310/year**
  - Optional: Company constitution drafting (~$500-3,000)
- **Liability:** Limited to company assets (personal assets protected)
- **Tax:** Flat 25% corporate tax rate (small business entities)
- **Pros:** Limited liability, easier to raise investment, professional image
- **Cons:** More compliance, annual fees, director obligations

**Requirements:**
- At least 1 director (must be Australian resident)
- At least 1 shareholder
- Director ID required before registration (free via ABRS)
- Registered office address in Australia
- Principal place of business address

**Setup time:** 1-3 business days via Business Registration Service

---

## 2. Registration Requirements

### ABN (Australian Business Number)
- **Cost:** FREE
- **Required for:** All businesses operating in Australia
- **Apply at:** [register.business.gov.au](https://register.business.gov.au)
- **Processing:** Usually instant online, sometimes reviewed (1-20 days)

**You MUST have an ABN to:**
- Invoice other businesses (avoid 47% withholding tax)
- Register for GST
- Apply for a business name

### ACN (Australian Company Number)
- **Cost:** Included in company registration ($597)
- **Required for:** Companies (Pty Ltd) only
- **Automatic:** Given when you register a company
- **Format:** 9 digits (e.g., 123 456 789)

### Business Name Registration
- **Cost:** 
  - 1 year: **$44**
  - 3 years: **$102**
- **Required if:** Trading under a name other than your own legal name or company name
- **NOT required if:** 
  - Sole trader using "John Smith" (your actual name)
  - Company using registered company name (e.g., "ABC Pty Ltd" trading as "ABC")

**Check availability:** [ASIC Connect](https://connectonline.asic.gov.au/RegistrySearch)

### GST Registration
- **Cost:** FREE
- **MANDATORY if:** Annual turnover > $75,000 (or $150,000 for non-profits)
- **Optional if:** Turnover below threshold
- **What it means:** Charge 10% GST on sales, claim GST credits on purchases
- **Reporting:** BAS (Business Activity Statement) quarterly or monthly

**Consider registering early if:**
- You mainly sell B2B (they can claim GST back)
- Your costs have significant GST (you can claim credits)

### Other Tax Registrations
| Registration | When Required |
|--------------|---------------|
| PAYG Withholding | Hiring employees |
| FBT (Fringe Benefits Tax) | Providing benefits to employees (cars, etc.) |
| TFN (Tax File Number) | All businesses (separate from ABN) |

---

## 3. Legal Requirements for Employers

### Superannuation (Pension)
- **Rate:** **11.5%** of ordinary time earnings (2024-25)
- **Increasing to:** 12% from 1 July 2025
- **Required when:** Employee earns $450+/month
- **Payment:** Quarterly (28th of month after quarter ends)
- **Platform:** Use a compliant super fund or clearing house

**Key dates:**
- Q1 (Jul-Sep): Due 28 October
- Q2 (Oct-Dec): Due 28 January
- Q3 (Jan-Mar): Due 28 April
- Q4 (Apr-Jun): Due 28 July

### Workers Compensation Insurance
- **Required:** YES, in NSW (all employers)
- **Provider:** iCare NSW or approved insurers
- **Cost:** Varies by industry (0.5%-10%+ of wages)
- **Apply:** Before your first employee starts

### Fair Work Compliance
- **National Employment Standards (NES):** 11 minimum entitlements
- **Modern Awards:** Industry-specific minimum conditions
- **Minimum wage:** $24.10/hour (from July 2024)

**Key obligations:**
- Written employment contracts (or letter of offer)
- Payslips within 1 day of payment
- Leave entitlements (4 weeks annual, 10 days sick)
- Notice periods and redundancy
- Unfair dismissal protection

**Resources:** [fairwork.gov.au](https://www.fairwork.gov.au)

### Tax Obligations Summary
| Tax | Frequency | Due Date |
|-----|-----------|----------|
| BAS/GST | Quarterly | 28th after quarter |
| PAYG Withholding | With BAS | 28th after quarter |
| Company Tax | Annual | Within 5 months of year end |
| Superannuation | Quarterly | 28th after quarter |

---

## 4. Banking & Payments

### Business Bank Accounts

| Bank | Monthly Fee | Features |
|------|-------------|----------|
| **Up Business** | $0 | Modern app, instant payments, no minimums |
| **Xero-integrated banks** | $0-15 | Direct accounting integration |
| **CommBank** | $10-30 | Wide branch network, established |
| **ANZ** | $10-25 | Good for larger businesses |
| **Westpac** | $10-20 | Strong business tools |
| **NAB** | $10-20 | No monthly fee plans available |

**Recommendation for startups:** Up Business or neo-banks (Judo, Alex Bank) for zero fees.

### Payment Processing

| Provider | Card Rate | Online | Best For |
|----------|-----------|--------|----------|
| **Square** | 1.6% in-person, 2.2% online | Yes | Retail, markets, simple invoicing |
| **Stripe** | 1.75% + $0.30 | Yes | Online businesses, SaaS, developers |
| **Tyro** | 0.7%-1.5% | Yes | High-volume retail, hospitality |
| **Airwallex** | 1.0-2.9% | Yes | International payments, multi-currency |
| **PayPal** | 2.6% + $0.30 | Yes | Marketplace sellers, international buyers |

**Tips:**
- Square: Best for face-to-face, easy setup, free POS hardware options
- Stripe: Best for tech startups, excellent API, subscription billing
- For B2B: Bank transfers (free) still common in Australia

---

## 5. Office Space & Co-working

### Sydney Co-working Costs by Area

| Area | Hot Desk | Dedicated Desk | Private Office (2-4 pax) |
|------|----------|----------------|--------------------------|
| **CBD (Core)** | $400-700/mo | $700-1,100/mo | $2,500-5,000/mo |
| **Surry Hills** | $350-550/mo | $550-850/mo | $1,800-3,500/mo |
| **Pyrmont** | $350-500/mo | $500-800/mo | $1,500-3,000/mo |
| **North Sydney** | $300-500/mo | $500-800/mo | $1,500-3,000/mo |
| **Parramatta** | $250-400/mo | $400-600/mo | $1,200-2,500/mo |
| **Bondi/East** | $400-600/mo | $600-900/mo | $2,000-4,000/mo |

### Top Co-working Spaces

**For Startups:**
- **Fishburners** (Ultimo) - Startup-focused, from ~$349/mo for "Passport" membership
- **Stone & Chalk** (CBD) - Fintech focus, strong industry connections
- **Tank Stream Labs** (CBD) - Tech startup community

**General:**
- **WeWork** - Multiple locations, professional, higher-end
- **Hub Australia** - Multiple Sydney locations, good facilities
- **Spaces** (by IWG) - Modern, corporate-friendly

### Traditional Office Leases
- **Lease terms:** 2-5 years typical (negotiable)
- **Rent:** $700-1,200/sqm/year (CBD), $400-700/sqm (suburban)
- **Outgoings:** Add 20-30% for building costs
- **Make good:** You pay to restore at lease end
- **Bank guarantee:** Usually 3-6 months rent

**For early-stage:** Stick with co-working until you have 10+ employees and predictable revenue.

---

## 6. Professional Services

### Finding an Accountant

**What to look for:**
- Experience with startups/small business
- BAS agent registered
- Familiar with your industry
- Cloud accounting (Xero, MYOB, QuickBooks)

**Cost ranges:**
| Service | Cost |
|---------|------|
| Bookkeeping | $50-100/hour or $200-800/mo |
| BAS Preparation | $150-400/quarter |
| Annual Tax Return (Sole Trader) | $300-800 |
| Annual Tax Return (Company) | $800-2,500 |
| Tax Planning | $150-300/hour |
| Startup package (setup + first year) | $2,000-5,000 |

**Recommended for startups:**
- Hnry (for sole traders/contractors)
- Pilot (tech startup specialists)
- Standard Ledger (startup-focused)
- Link Advisors
- Local accountants via Xero advisor directory

### Legal Services

**When you need a lawyer:**
- Shareholders agreement (if co-founders)
- Employment contracts (template ~$500, custom ~$1,500+)
- Commercial lease review ($500-1,500)
- IP/trademark issues
- Investment/SAFE notes

**Cost ranges:**
| Service | Cost |
|---------|------|
| Shareholders Agreement | $2,000-5,000 |
| Employment Contract (template) | $300-800 |
| Terms & Conditions | $500-2,000 |
| Privacy Policy | $300-1,000 |
| Commercial Lease Review | $800-2,000 |
| Hourly rate (mid-tier) | $300-500/hour |
| Hourly rate (top-tier) | $500-1,000/hour |

**Startup-friendly firms:**
- LegalVision (fixed-fee, online-first)
- Sprintlaw (tech-focused, fixed pricing)
- Hall & Wilcox (startup program)
- Gilbert + Tobin (for funded startups)

**DIY Options:**
- Cleardocs (templates)
- LawPath (affordable templates + lawyer review)
- Airtree Open Source (free startup templates): [airtree.vc/open-source-vc](https://www.airtree.vc/open-source-vc)

---

## Quick Setup Checklist

### Day 1-3: Foundation
- [ ] Decide business structure
- [ ] Register ABN (free, instant)
- [ ] Get Director ID if forming company (free)
- [ ] Register company if Pty Ltd ($597)
- [ ] Register business name if needed ($44-102)

### Week 1-2: Operations
- [ ] Open business bank account
- [ ] Set up accounting software (Xero/MYOB)
- [ ] Register for GST if >$75K expected
- [ ] Set up payment processing (Square/Stripe)
- [ ] Get business insurance quotes

### Before First Employee
- [ ] Register for PAYG Withholding
- [ ] Set up workers comp insurance
- [ ] Choose super fund/clearing house
- [ ] Prepare employment contracts
- [ ] Understand Fair Work obligations

---

## Useful Links

- **Business Registration Service:** [register.business.gov.au](https://register.business.gov.au)
- **ASIC (Companies/Business Names):** [asic.gov.au](https://www.asic.gov.au)
- **ATO (Tax):** [ato.gov.au](https://www.ato.gov.au)
- **Fair Work:** [fairwork.gov.au](https://www.fairwork.gov.au)
- **NSW Business Licences:** [service.nsw.gov.au/campaign/small-business](https://www.service.nsw.gov.au)
- **Business.gov.au:** [business.gov.au](https://business.gov.au)
