---
name: Swedish
description: Write Swedish that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Swedish is technically correct but sounds off. Too formal. Too rigid. Natives write more casually, with particles and understated tone. Match that.

## Formality Default

Default register is too high. Swedish is notably informal. Unless explicitly formal: lean casual. "Hej" not "God dag". "Okej" not "Ja, det är bra". "Tja" among friends.

## Du-Reform

Sweden had a "du-reform" - almost everyone uses du:
- Du: universal default, even strangers
- Ni: very rare, can sound sarcastic or old
- Just use du unless specifically formal context

## Particles & Softeners

These make Swedish natural:
- Ju: shared knowledge ("Det vet du ju")
- Väl: uncertainty/hope ("Du kommer väl?")
- Nog: "probably" ("Det går nog bra")
- La/Då: emphasis ("Gör det då!")
- Visst: confirmation seeking

## Fillers & Flow

Real Swedish has fillers:
- Typ, liksom, asså (alltså)
- Eh, öh, mm
- Ja/Nej as fillers, not just yes/no
- I alla fall, hur som helst

## Sentence Fragments

Swedes are concise:
- "Kommer du?" "Aa" (yes)
- "Läget?" "Bra" 
- Short answers are natural
- Over-complete sentences feel stiff

## Expressiveness

Don't pick the safe word:
- Bra → Grymt, Fett, Najs, Asball
- Dåligt → Kasst, Skit, Drygt
- Mycket → Jätte-, As-, Mega-
- Prefix intensifiers are very Swedish

## Common Expressions

Natural expressions:
- Lugnt, Ingen fara, Inga problem
- Vad schysst!, Kul!, Nice!
- Skönt, Härligt
- Orka (can't be bothered)

## Reactions

React naturally:
- Vad?, Serröst?, Menar du allvar?
- Oj!, Herregud!, Fan!
- Haha, lol in text
- Skön!, Najs!, Fett!

## Lagom Concept

Swedish understatement is cultural:
- "Inte så dumt" = actually good
- "Helt okej" = pretty good
- Enthusiasm is more muted
- Over-enthusiasm can seem fake

## English Mixing

Swedes mix English naturally:
- "Det var så awkward"
- "Super nice!"
- Common in casual speech
- Natural, not forced

## The "Native Test"

Before sending: would a Swede screenshot this as "AI-generated"? If yes—too formal, missing particles, too enthusiastic. Tone down, add "typ".
