# SurrealDB Online Documentation and Resources

A comprehensive directory of official SurrealDB documentation, repositories, and community resources.

## Official Documentation

| Resource | URL |
|----------|-----|
| Main Documentation | https://surrealdb.com/docs |
| SurrealQL Reference | https://surrealdb.com/docs/surrealdb/surrealql |
| Data Model | https://surrealdb.com/docs/surrealdb/datamodel |
| Extensions | https://surrealdb.com/docs/surrealdb/extensions |
| Security | https://surrealdb.com/docs/surrealdb/security |
| Deployment | https://surrealdb.com/docs/surrealdb/deployment |
| CLI Reference | https://surrealdb.com/docs/surrealdb/cli |

## SDKs

| SDK | Documentation | Repository |
|-----|--------------|------------|
| JavaScript/TypeScript | https://surrealdb.com/docs/sdk/javascript | https://github.com/surrealdb/surrealdb.js |
| Python | https://surrealdb.com/docs/sdk/python | https://github.com/surrealdb/surrealdb.py |
| Rust | https://surrealdb.com/docs/sdk/rust | https://github.com/surrealdb/surrealdb (core) |
| Go | https://surrealdb.com/docs/sdk/go | https://github.com/surrealdb/surrealdb.go |
| Java | https://surrealdb.com/docs/sdk/java | https://github.com/surrealdb/surrealdb.java |
| .NET (C#) | https://surrealdb.com/docs/sdk/dotnet | https://github.com/surrealdb/surrealdb.net |

## GitHub Repositories

| Repository | Description |
|-----------|-------------|
| https://github.com/surrealdb/surrealdb | Core database engine (Rust) |
| https://github.com/surrealdb/surrealdb.js | JavaScript/TypeScript SDK |
| https://github.com/surrealdb/surrealdb.py | Python SDK |
| https://github.com/surrealdb/surrealdb.go | Go SDK |
| https://github.com/surrealdb/surrealdb.java | Java SDK |
| https://github.com/surrealdb/surrealdb.net | .NET SDK |
| https://github.com/surrealdb/surrealist | Surrealist IDE/Query Explorer |
| https://github.com/surrealdb/docs.surrealdb.com | Documentation source |

## Tools and Applications

| Tool | URL | Description |
|------|-----|-------------|
| Surrealist (Cloud) | https://app.surrealdb.com | Browser-based query explorer and IDE |
| Surrealist (Desktop) | https://surrealdb.com/surrealist | Downloadable desktop application |
| SurrealDB Cloud | https://surrealdb.com/cloud | Managed SurrealDB hosting |

## Community

| Resource | URL |
|----------|-----|
| Discord | https://discord.gg/surrealdb |
| GitHub Discussions | https://github.com/surrealdb/surrealdb/discussions |
| Blog | https://surrealdb.com/blog |
| YouTube | https://youtube.com/@surrealdb |
| Twitter / X | https://x.com/surrealdb |

## Learning Resources

| Resource | URL |
|----------|-----|
| Getting Started Guide | https://surrealdb.com/docs/surrealdb/introduction/start |
| SurrealQL Tutorial | https://surrealdb.com/docs/surrealdb/surrealql/overview |
| University (Video Courses) | https://surrealdb.com/learn |
