---
name: surge
description: Blazing fast TUI download manager with multi-connection downloads. Use when: (1) Fast downloads with parallel connections, (2) Queue management, (3) Server/daemon mode for headless downloads, (4) Beautiful TUI interface, (5) Multiple mirror support.
version: 1.0.1
metadata:
  openclaw:
    requires:
      bins:
        - surge
    emoji: "⚡"
    homepage: https://github.com/surge-downloader/Surge
---

# Surge

Blazing fast TUI download manager built in Go for power users.

## Install

```bash
# macOS
brew install surge-downloader/tap/surge

# Go
go install github.com/surge-downloader/surge@latest

# Or download binary from releases
```

## Features

- Multi-connection downloads (up to 32 parallel connections)
- Beautiful Terminal UI (TUI)
- Server mode for headless/daemon operation
- Multiple mirrors with automatic failover
- Sequential/streaming download for preview
- Queue management via CLI

## Basic Usage

```bash
# Start server (daemon)
surge server

# Add download via CLI
surge add "https://example.com/file.zip"

# List downloads
surge ls

# Queue with output folder
surge add "URL" -o /path/to/folder
```

## Commands

| Command | Description |
|---------|-------------|
| `surge server` | Start headless daemon |
| `surge add <url>` | Add download to queue |
| `surge ls` | List downloads |
| `surge pause <id>` | Pause download |
| `surge resume <id>` | Resume download |
| `surge rm <id>` | Remove download |
| `surge token` | Get API token |

## Options

| Flag | Description |
|------|-------------|
| `-o, --output PATH` | Output directory |
| `-b, --batch FILE` | Batch file with URLs |
| `--exit-when-done` | Exit when downloads complete |
| `--host HOST` | Target server |
| `--token TOKEN` | API token |

## Server Mode

```bash
# Start server
surge server

# Add downloads to running server
surge add "https://file1.zip"
surge add "https://file2.zip" -o /other/folder

# Check status
surge ls
```

## Examples

```bash
# Download file
surge add "https://example.com/file.zip" -o ~/Downloads

# Batch download
surge add -b urls.txt -o ./downloads

# Server mode with output
surge server -o /tmp/downloads
surge add "https://url.com/file.zip"
```

## Performance

Benchmarks show Surge is 1.38× faster than aria2, 2× faster than curl/wget.
