# Universal Capability Types Reference

This document defines the standard capability types used for task decomposition and skill matching.

## Capability Taxonomy

### 1. Browser Automation (`browser_automation`)

**Description:** Automated interaction with web pages including navigation, clicking, form filling, and data extraction.

**Common Use Cases:**
- Login to websites
- Fill and submit forms
- Extract data from web pages
- Take screenshots
- Automate repetitive web tasks

**Search Keywords:**
```
browser, selenium, puppeteer, playwright, scrape, automation, web, navigate, click, form
```

**Example Search Queries:**
```bash
npx skills find browser automation
npx skills find web scraping
npx skills find puppeteer
```

---

### 2. Web Search (`web_search`)

**Description:** Search the internet for information using search engines.

**Common Use Cases:**
- Find documentation
- Research topics
- Get current news
- Find resources and links

**Search Keywords:**
```
search, google, bing, duckduckgo, web search, internet, query
```

**Example Search Queries:**
```bash
npx skills find web search
npx skills find duckduckgo
npx skills find search engine
```

---

### 3. API Integration (`api_integration`)

**Description:** Communicate with third-party services via REST, GraphQL, or other APIs.

**Common Use Cases:**
- GitHub operations
- Notion database management
- Cloud service integration
- SaaS platform automation

**Search Keywords:**
```
api, rest, graphql, webhook, integration, {service-name}
```

**Example Search Queries:**
```bash
npx skills find github api
npx skills find notion integration
npx skills find stripe
npx skills find twitter api
```

---

### 4. Data Extraction (`data_extraction`)

**Description:** Parse and extract structured data from various sources.

**Common Use Cases:**
- PDF text extraction
- HTML parsing
- OCR from images
- JSON/XML parsing

**Search Keywords:**
```
parse, extract, scrape, ocr, pdf, html, xml, json, regex
```

**Example Search Queries:**
```bash
npx skills find pdf extract
npx skills find ocr
npx skills find html parser
```

---

### 5. Data Transformation (`data_transformation`)

**Description:** Convert, clean, and transform data between formats.

**Common Use Cases:**
- Format conversion (CSV to JSON)
- Data cleaning and normalization
- Schema transformation
- ETL operations

**Search Keywords:**
```
transform, convert, format, clean, etl, migrate, normalize
```

**Example Search Queries:**
```bash
npx skills find data transform
npx skills find csv json
npx skills find etl
```

---

### 6. Content Generation (`content_generation`)

**Description:** Create text, images, or other content. Often handled by LLM natively.

**Common Use Cases:**
- Text summarization
- Translation
- Writing assistance
- Image generation

**Search Keywords:**
```
generate, write, create, summarize, translate, content, ai
```

**Note:** Most content generation is handled by the agent's native LLM capabilities. Search for skills only when specialized generation is needed.

---

### 7. File Operations (`file_operations`)

**Description:** Read, write, and manipulate files in various formats.

**Common Use Cases:**
- Read/write text files
- Process CSV/Excel files
- Handle JSON/YAML configuration
- File compression/decompression

**Search Keywords:**
```
file, read, write, csv, excel, json, yaml, zip, compress
```

**Example Search Queries:**
```bash
npx skills find excel
npx skills find csv process
npx skills find file management
```

---

### 8. Message Delivery (`message_delivery`)

**Description:** Send notifications or messages to external services.

**Common Use Cases:**
- Slack notifications
- Email sending
- Discord messages
- SMS/push notifications

**Search Keywords:**
```
notify, send, email, slack, discord, telegram, sms, push, message
```

**Example Search Queries:**
```bash
npx skills find slack notification
npx skills find discord bot
npx skills find email send
npx skills find telegram
```

---

### 9. Scheduling (`scheduling`)

**Description:** Configure time-based task execution.

**Common Use Cases:**
- Daily scheduled tasks
- Periodic automation
- Cron job configuration
- Timer-based triggers

**Search Keywords:**
```
schedule, cron, timer, daily, weekly, periodic, automation
```

**Note:** Scheduling is typically handled by system-level tools (cron, Task Scheduler). Skills may provide wrapper functionality.

---

### 10. Authentication (`authentication`)

**Description:** Handle identity verification and access management.

**Common Use Cases:**
- OAuth flows
- API key management
- Session handling
- Credential storage

**Search Keywords:**
```
auth, oauth, login, token, credentials, sso, identity
```

**Example Search Queries:**
```bash
npx skills find oauth
npx skills find authentication
```

---

### 11. Database Operations (`database_operations`)

**Description:** Interact with databases for data storage and retrieval.

**Common Use Cases:**
- SQL queries
- NoSQL operations
- Data persistence
- Database migrations

**Search Keywords:**
```
database, sql, mysql, postgres, mongodb, redis, query, storage
```

**Example Search Queries:**
```bash
npx skills find database
npx skills find mongodb
npx skills find sql
```

---

### 12. Code Execution (`code_execution`)

**Description:** Execute scripts, programs, or shell commands.

**Common Use Cases:**
- Run Python scripts
- Execute shell commands
- Process automation
- Build operations

**Search Keywords:**
```
execute, run, script, shell, python, node, bash
```

**Note:** Basic code execution is a built-in capability. Skills provide specialized runtime environments.

---

### 13. Version Control (`version_control`)

**Description:** Manage code repositories and version control operations.

**Common Use Cases:**
- Git operations
- PR/MR management
- Code review automation
- Repository management

**Search Keywords:**
```
git, github, gitlab, bitbucket, commit, pr, merge, review
```

**Example Search Queries:**
```bash
npx skills find github
npx skills find git automation
npx skills find pr review
```

---

### 14. Testing (`testing`)

**Description:** Automated testing and quality assurance.

**Common Use Cases:**
- Unit testing
- Integration testing
- E2E testing
- Test generation

**Search Keywords:**
```
test, jest, pytest, playwright, cypress, e2e, unit, qa
```

**Example Search Queries:**
```bash
npx skills find testing
npx skills find playwright
npx skills find e2e
```

---

### 15. Deployment (`deployment`)

**Description:** Application deployment and CI/CD operations.

**Common Use Cases:**
- Docker operations
- Cloud deployment
- CI/CD pipelines
- Release management

**Search Keywords:**
```
deploy, docker, kubernetes, k8s, ci-cd, aws, vercel, release
```

**Example Search Queries:**
```bash
npx skills find deploy
npx skills find docker
npx skills find vercel
```

---

### 16. Monitoring (`monitoring`)

**Description:** System and application monitoring and alerting.

**Common Use Cases:**
- Health checks
- Log analysis
- Performance monitoring
- Alert configuration

**Search Keywords:**
```
monitor, alert, log, metrics, health, observability, apm
```

**Example Search Queries:**
```bash
npx skills find monitoring
npx skills find alerts
npx skills find logging
```

---

## Built-in vs Skill-Required Capabilities

### Built-in Capabilities (No Skill Needed)

These capabilities are typically handled by the agent's native abilities:

| Capability | Native Support |
|------------|----------------|
| `content_generation` | LLM text generation |
| `data_transformation` | Code-based manipulation |
| `code_execution` | Direct script execution |
| `scheduling` | System cron/scheduler |

### Usually Requires Skills

| Capability | Why Skill Needed |
|------------|------------------|
| `browser_automation` | Requires browser driver |
| `api_integration` | Service-specific logic |
| `data_extraction` | Format-specific parsers |
| `message_delivery` | Platform authentication |

---

## Capability Mapping Examples

### Email Digest to Slack

```yaml
Tasks:
  - Access emails → browser_automation
  - Extract content → data_extraction (built-in)
  - Generate summary → content_generation (built-in)
  - Send to Slack → message_delivery
```

### GitHub Issue Monitor

```yaml
Tasks:
  - Poll GitHub API → api_integration
  - Parse issue data → data_extraction (built-in)
  - Generate summary → content_generation (built-in)
  - Post notification → message_delivery
  - Schedule polling → scheduling (built-in)
```

### PDF Report Generator

```yaml
Tasks:
  - Extract PDF text → data_extraction
  - Transform data → data_transformation (built-in)
  - Generate report → content_generation (built-in)
  - Save to database → database_operations
```

---

## Search Strategy

### 1. Direct Capability Search
```bash
npx skills find {capability_keyword}
```

### 2. Service-Specific Search
```bash
npx skills find {service_name}
```

### 3. Combined Search
```bash
npx skills find {capability} {domain}
# Example: npx skills find automation email
```

### 4. Browse Categories at skills.sh
Visit https://skills.sh/ to browse available skills by category.
