# Super Research

**The ultimate AI research system.** Combines the best of 8 top-rated research skills into one powerful framework.

---

## Why This Skill?

This skill handles any research task from quick lookups to deep academic analysis. It knows when to use which approach.

---

## Core Features

### 1. Research Classification
Determine research type and pick right approach:
- **Quick lookup** - Fast web search
- **Deep research** - Multi-source exhaustive analysis
- **Academic** - Scholarly sources, citations
- **Parallel** - Multiple topics simultaneously

### 2. Source Types (from research-engine)
- Web search
- News
- GitHub
- Academic papers
- Developer documentation

### 3. Quality Hierarchy (from deep-research-pro)
Priority order:
1. Academic / Official / Reputable news
2. Technical blogs
3. Forums / Discussions

### 4. Output Formats
- Executive summary
- Key findings with sources
- Actionable insights
- Trend analysis
- Development plans (short/medium/long)

---

## Usage

### Quick Research
```
Search for: "OpenCode vs Cursor 2026 comparison"
```

### Deep Research
```
Research topic: "AI agents in software development"
Depth: Executive summary + technical deep-dive
Format: Report with sources
```

### Academic Research
```
Theme: Impact of AI on developer productivity
Key questions:
- What studies exist?
- Methodology?
- Results?
Format: Literature review
```

---

## Workflow

1. **Classify** - Quick or deep?
2. **Plan** - Keywords, sources, angle
3. **Search** - Use multiple sources
4. **Analyze** - Extract key points
5. **Synthesize** - Combine into report
6. **Cite** - Include sources

---

## Best Sources

| Type | Source |
|------|--------|
| Web | Google, Bing |
| News | Tech news sites |
| Code | GitHub |
| Academic | arXiv, papers |
| Docs | MDN, Dev docs |

---

## Merged From

| Skill | Rating |
|-------|--------|
| academic-deep-research | 3.431 |
| deep-research-pro | 3.420 |
| parallel-ai-research | 3.379 |
| research-engine | 3.376 |
| research-cog | 3.373 |
| research-tracker | 3.368 |
| parallel-deep-research | 3.360 |
| in-depth-research | 3.354 |

---

## Version

v1.0.0 - Initial release
