# Super GitHub

**The ultimate GitHub automation framework.** Combines the best of GitHub skills for issues, PRs, releases, and more.

---

## Why This Skill?

Complete GitHub management - issues, PRs, releases, automation - all in one skill.

---

## Core Features

### 1. Issues Automation
- Create issues (with labels, assignees)
- List issues (filter by status, labels)
- Update issues (title, body, labels)
- Auto-categorization and label suggestions

### 2. PR Review Assistant
- PR summary analysis
- File change statistics
- Review checklist generation
- Conflict detection

### 3. Release Automation
- Create releases
- Auto-generate changelogs
- Tag management

### 4. Repository Management
- List repos
- Get/set secrets
- Manage workflows

---

## Usage

### Create Issue
```
gh issue create --title "Bug in login" --body "Description" --label bug
```

### PR Review
```
gh pr review --summary --stats --checklist
```

### Create Release
```
gh release create v1.0.0 --generate-notes
```

---

## Merged From

| Skill | Rating |
|-------|--------|
| openclaw-github-assistant | 3.470 |
| github-automation-pro | 3.266 |
| github-mcp | 3.180 |

---

## Version

v1.0.0 - Initial release
