---
name: supalytics
description: Query web analytics data using the Supalytics CLI. Use when the user wants to check pageviews, visitors, top pages, traffic sources, referrers, countries, revenue metrics, conversions, funnels, events, or realtime visitors.
metadata: {"openclaw":{"emoji":"📊","requires":{"bins":["supalytics"]},"homepage":"https://supalytics.co"}}
---

# Supalytics CLI

Query web analytics data from [Supalytics](https://supalytics.co) - simple, fast, GDPR-compliant analytics with revenue attribution.

## Installation

**Requires [Bun](https://bun.sh) runtime** (not Node.js):

```bash
# Install Bun first
curl -fsSL https://bun.sh/install | bash
export PATH="$HOME/.bun/bin:$PATH"

# Install Supalytics CLI
bun add -g @supalytics/cli
```

## Authentication

### Important: OAuth in Agent Contexts

The `supalytics login` command uses OAuth device flow which requires user interaction in a browser. In agent contexts (OpenClaw, etc.), the process may be killed before OAuth completes.

**Solution for OpenClaw:** Use `background: true` mode:

```javascript
await exec({
  command: 'supalytics login',
  background: true,
  yieldMs: 2000  // Wait 2s to capture the verification URL
});
```

The agent should:
1. Run login in background mode
2. Extract and present the verification URL to the user
3. Wait for user to complete browser authorization
4. Poll background session to check completion

### Quick Setup

```bash
supalytics init    # Opens browser, creates site, shows tracking snippet
```

### Manual Setup

```bash
supalytics login        # Opens browser for OAuth
supalytics sites add    # Create a new site
```

## Commands

### Quick Stats

```bash
supalytics stats              # Last 30 days (default)
supalytics stats today        # Today only
supalytics stats yesterday    # Yesterday
supalytics stats week         # This week
supalytics stats month        # This month
supalytics stats 7d           # Last 7 days
supalytics stats --all        # Include breakdowns (pages, referrers, countries, etc.)
```

### Realtime Visitors

```bash
supalytics realtime           # Current visitors on site
supalytics realtime --watch   # Auto-refresh every 30s
```

### Trend (Time Series)

```bash
supalytics trend              # Daily visitor trend with bar chart
supalytics trend --period 7d  # Last 7 days
supalytics trend --compact    # Sparkline only
```

### Breakdowns

```bash
supalytics pages              # Top pages by visitors
supalytics referrers          # Top referrers
supalytics countries          # Traffic by country
```

### Events

```bash
supalytics events                          # List all custom events
supalytics events signup                   # Properties for specific event
supalytics events signup --property plan   # Breakdown by property value
```

### Custom Queries

The `query` command is the most flexible:

```bash
# Top pages with revenue
supalytics query -d page -m visitors,revenue

# Traffic by country and device
supalytics query -d country,device -m visitors

# Blog traffic from US only
supalytics query -d page -f "page:contains:/blog" -f "country:is:US"

# Hourly breakdown
supalytics query -d hour -m visitors -p 7d

# UTM campaign performance
supalytics query -d utm_source,utm_campaign -m visitors,revenue

# Sort by revenue descending
supalytics query -d page --sort revenue:desc

# Pages visited by users who signed up
supalytics query -d page -f "event:is:signup"

# Filter by event property
supalytics query -d country -f "event_property:is:plan:premium"
```

**Available metrics:** `visitors`, `pageviews`, `bounce_rate`, `avg_session_duration`, `revenue`, `conversions`, `conversion_rate`

**Available dimensions:** `page`, `referrer`, `country`, `region`, `city`, `browser`, `os`, `device`, `date`, `hour`, `event`, `utm_source`, `utm_medium`, `utm_campaign`, `utm_term`, `utm_content`

### Site Management

```bash
supalytics sites                              # List all sites
supalytics sites add example.com              # Create site
supalytics sites update my-site -d example.com  # Update domain
supalytics default example.com                # Set default site
supalytics remove example.com                 # Remove site
```

## Global Options

All analytics commands support:

| Option | Description |
|--------|-------------|
| `-s, --site <domain>` | Query specific site (otherwise uses default) |
| `-p, --period <period>` | Time period: `7d`, `14d`, `30d`, `90d`, `12mo`, `all` |
| `--start <date>` | Start date (YYYY-MM-DD) |
| `--end <date>` | End date (YYYY-MM-DD) |
| `-f, --filter <filter>` | Filter: `field:operator:value` |
| `--json` | Output raw JSON (for programmatic use) |
| `--no-revenue` | Exclude revenue metrics |
| `-t, --test` | Query localhost/test data |

## Filter Syntax

Format: `field:operator:value`

**Operators:** `is`, `is_not`, `contains`, `not_contains`, `starts_with`

**Examples:**
```bash
-f "country:is:US"
-f "page:contains:/blog"
-f "device:is:mobile"
-f "referrer:is:twitter.com"
-f "utm_source:is:newsletter"
-f "event:is:signup"
-f "event_property:is:plan:premium"
```

## Output Formats

**Human-readable (default):** Formatted tables with colors

**JSON (`--json`):** Raw JSON for parsing - use this when you need to process the data programmatically:

```bash
supalytics stats --json | jq '.data[0].metrics.visitors'
supalytics query -d page -m visitors --json
```

## Examples by Use Case

### "How's my site doing?"
```bash
supalytics stats
```

### "What are my top traffic sources?"
```bash
supalytics referrers
# or with revenue
supalytics query -d referrer -m visitors,revenue
```

### "Which pages generate the most revenue?"
```bash
supalytics query -d page -m revenue --sort revenue:desc
```

### "How's my newsletter campaign performing?"
```bash
supalytics query -d utm_campaign -f "utm_source:is:newsletter" -m visitors,conversions,revenue
```

### "Who's on my site right now?"
```bash
supalytics realtime
```

### "Show me the visitor trend this week"
```bash
supalytics trend --period 7d
```

## Troubleshooting

| Issue | Solution |
|-------|----------|
| `command not found: supalytics` | Ensure Bun is installed and `~/.bun/bin` is in PATH, or symlink to system path (see below) |
| `No site specified` | Run `supalytics default <domain>` to set default site |
| `Unauthorized` | Run `supalytics login` to re-authenticate |
| No data returned | Check site has tracking installed, try `-t` for test mode |

### OpenClaw / Daemon Usage

Bun installs to `~/.bun/bin` which isn't in PATH for daemon processes like OpenClaw. After installation, symlink to system path:

```bash
sudo ln -sf ~/.bun/bin/bun /usr/local/bin/bun
sudo ln -sf ~/.bun/bin/supalytics /usr/local/bin/supalytics
```
