# Lyrics Guide — Suno

## Structure Tags

Suno recognizes these section markers:

```
[Verse]
[Verse 1], [Verse 2], etc.
[Chorus]
[Pre-Chorus]
[Bridge]
[Outro]
[Intro]
[Hook]
[Instrumental]
[Break]
```

## Basic Song Structure

### Pop/Rock Standard
```
[Verse 1]
4-6 lines

[Chorus]
2-4 lines (repeat hook)

[Verse 2]
4-6 lines

[Chorus]
2-4 lines

[Bridge]
2-4 lines (contrast)

[Chorus]
Final chorus

[Outro]
2 lines (fade)
```

### Verse-Heavy (Folk/Hip Hop)
```
[Verse 1]
8-12 lines (storytelling)

[Chorus]
2-4 lines

[Verse 2]
8-12 lines

[Chorus]
2-4 lines

[Verse 3]
8-12 lines

[Chorus]
Final
```

### EDM/Dance
```
[Intro]
2 lines or [Instrumental]

[Verse]
4 lines

[Build]
2 lines (building energy)

[Drop]
2 lines or [Instrumental]

[Verse 2]
4 lines

[Drop]
Repeat

[Outro]
Fade
```

## Rhyme Schemes

### AABB (Simple, Catchy)
```
[Verse]
Walking down the street tonight (A)
Everything is feeling right (A)
Stars are shining up above (B)
Thinking about the one I love (B)
```

### ABAB (Classic, Narrative)
```
[Verse]
The morning sun begins to rise (A)
I watch the world come alive (B)
With dreams reflected in your eyes (A)
This moment I want to survive (B)
```

### ABCB (Subtle, Sophisticated)
```
[Verse]
The rain falls down on empty streets (A)
I'm walking through the night (B)
Memories of what we had (C)
Still burning ever bright (B)
```

### Free (Modern, Emotional)
```
[Verse]
Sometimes I wonder
If the stars remember our names
We were young once
Dancing in the flames
```

## Syllable Matching

Keep syllable counts similar for matching lines:

### Good
```
Walking down the street (5)
Looking for the beat (5)

I can see the light (5)
Everything's alright (5)
```

### Bad
```
Walking down the street (5)
I am looking everywhere for something to complete (12)
```

## Hook Techniques

### Repetition
```
[Chorus]
We're gonna make it
We're gonna make it through the night
We're gonna make it
Everything will be alright
```

### Question/Answer
```
[Verse]
Why does the rain keep falling down?

[Chorus]
Because the sky knows how I feel
The tears I hide are all too real
```

### Contrast
```
[Verse]
Quiet whispers in the dark
Waiting for the spark

[Chorus]
EXPLODE into the light!
We're burning so bright tonight!
```

## Vocal Cues

Add these in brackets for dynamic control:

```
[Verse - soft]
gentle lyrics here

[Chorus - powerful]
BIG EMOTIONAL LYRICS

[Bridge - whispered]
intimate quiet section

[Outro - fading]
slowly ending here
```

## Emotional Arc

### Build-Up Pattern
```
[Verse 1] - Establish situation (calm)
[Chorus] - Emotional release (medium)
[Verse 2] - Develop conflict (building)
[Chorus] - Bigger release (powerful)
[Bridge] - Climax or twist (intense)
[Final Chorus] - Resolution (triumphant)
```

### Storytelling Pattern
```
[Verse 1] - Setup: introduce character/situation
[Verse 2] - Conflict: problem emerges
[Chorus] - Theme: emotional core
[Verse 3] - Resolution: how it ends
[Outro] - Reflection
```

## Writing Tips

### Do
- Use concrete imagery over abstract concepts
- Match syllables across rhyming lines
- Vary line lengths for rhythm interest
- Repeat key phrases for memorability
- Use present tense for immediacy

### Don't
- Overcomplicate vocabulary
- Use too many syllables per line
- Mix too many metaphors
- Rhyme every single line
- Be too literal or cliché

## Templates

### Love Song
```
[Verse 1]
When I see you standing there
Time stops, I forget to breathe
Your smile lights up the air
Something I could never leave

[Chorus]
You're the one I've been waiting for
The answer to my prayer
Forever isn't long enough
When you're standing there

[Verse 2]
Every moment that we share
Feels like a dream come true
Nothing else could compare
To the way I feel with you

[Chorus]
...
```

### Breakup/Sad
```
[Verse 1]
Empty rooms and photographs
Memories we used to share
I'm still searching for the halves
Of the heart you left somewhere

[Chorus]
Why did you have to go
Leave me standing in the rain
Now all I seem to know
Is the echo of the pain

...
```

### Empowerment/Anthemic
```
[Verse 1]
They said I couldn't make it
Told me I would fall
But I refused to break, kid
Now I'm standing tall

[Chorus]
Rise up! (rise up!)
We're stronger than they know
Rise up! (rise up!)
It's time to let it show

...
```

### Party/Fun
```
[Verse 1]
Friday night, feeling alive
Music's pumping, ready to dive
Into the beat, onto the floor
This is what we're living for

[Chorus]
Let's go! (let's go!)
Tonight we own the night
Let's go! (let's go!)
Everything feels so right

...
```

## Instrumental Sections

```
[Instrumental]
(guitar solo)

[Break]
(drum break)

[Build]
(rising synth)

[Drop]
(bass drop, crowd goes wild)
```

## Length Guidelines

| Section | Lines | Words |
|---------|-------|-------|
| Verse | 4-8 | 30-60 |
| Chorus | 2-4 | 15-30 |
| Bridge | 2-4 | 15-30 |
| Outro | 1-2 | 5-15 |

**Total song:** ~150-300 words for a 2-3 minute track.
