# Summary Output Formats

## By Length

### TLDR (1 sentence)
```
📝 TLDR: [Core message in one clear sentence, max 25 words]
```
**Use for:** Social sharing, quick reference, email subject lines.

### Brief (2-3 sentences)
```
📝 BRIEF: [Main point]. [Key supporting evidence or context]. [Implication or conclusion].
```
**Use for:** Slack updates, meeting prep, quick decisions.

### Standard (1 paragraph)
```
📝 SUMMARY (Standard: ~100 words)
[Opening with core message. Supporting points integrated naturally. Context where needed. Conclusion or implication.]
```
**Use for:** Reports, emails, general communication.

### Extended (multi-paragraph)
```
📝 SUMMARY (Extended: ~300 words)

[Overview paragraph with thesis]

[Body paragraph with key points and evidence]

[Conclusion paragraph with implications]
```
**Use for:** Executive summaries, comprehensive briefs, study materials.

---

## By Structure

### Bullet Points
```
💡 KEY POINTS
• [Point 1 — most important]
• [Point 2 — second priority]
• [Point 3 — supporting]
• [Point 4 — context if needed]
```
**Use for:** Scannable content, presentation prep, quick reference.

### Numbered List
```
📋 MAIN TAKEAWAYS
1. [First key point]
2. [Second key point]
3. [Third key point]
```
**Use for:** Prioritized information, action items, sequential points.

### Structured Sections
```
📊 EXECUTIVE SUMMARY

**Context:** [Why this matters]
**Findings:** [What was discovered]
**Implications:** [What it means]
**Recommendation:** [What to do]
```
**Use for:** Business reports, research summaries, decision documents.

### Q&A Format
```
❓ SUMMARY AS Q&A

**What is this about?**
[Topic and scope]

**What are the key findings?**
[Main points]

**Why does it matter?**
[Implications]
```
**Use for:** FAQ creation, explainers, educational content.

---

## By Audience

### Executive
```
📊 EXECUTIVE BRIEF

⚡ BOTTOM LINE: [One sentence decision/insight]

KEY POINTS:
• [Business impact point]
• [Risk or opportunity]
• [Resource implication]

RECOMMENDATION: [Action to take]
```

### Technical
```
🔧 TECHNICAL SUMMARY

OVERVIEW: [What it does/solves]
APPROACH: [How it works]
KEY SPECS: [Critical numbers/constraints]
LIMITATIONS: [What it doesn't do]
```

### General/Public
```
📝 PLAIN ENGLISH SUMMARY

[Simple explanation of what this is about, avoiding jargon. 
Analogies welcome. Focus on "why should I care?"]
```

### Academic
```
📚 ABSTRACT-STYLE SUMMARY

BACKGROUND: [Context and gap]
METHODS: [Approach taken]
RESULTS: [Key findings]
CONCLUSIONS: [Implications for field]
```

---

## Format Selection Guide

| Audience | Urgency | Best Format |
|----------|---------|-------------|
| Executive | High | TLDR + bullets |
| Executive | Low | Structured sections |
| Team | High | Brief + action items |
| Team | Low | Standard paragraph |
| Public | Any | Plain English |
| Technical | Any | Technical template |
| Academic | Any | Abstract-style |

| Purpose | Best Format |
|---------|-------------|
| Quick decision | TLDR |
| Meeting prep | Bullets |
| Report section | Structured |
| Email forward | Brief |
| Study/reference | Extended |
| Social share | TLDR |
