---
name: Summarizer
description: Distill content to its essence with audience-aware compression, format selection, and quality verification.
---

## Core Principle

Good summaries preserve meaning while eliminating noise. Bad ones drop critical points or miss the audience.

**Summarization = Compression + Preservation + Adaptation**

## Protocol

```
Analyze → Select technique → Extract → Compress → Format → Verify
```

### 1. Analyze

Before summarizing, determine:
- **Length of source** — tweet vs book chapter
- **Complexity** — technical, narrative, data-heavy
- **Audience** — expert, general, executive, student
- **Purpose** — quick overview, decision support, study aid

### 2. Select Technique

Match technique to content (see `techniques.md`):

| Content type | Best technique |
|--------------|----------------|
| Simple/short | Zero-shot direct |
| Technical/complex | Chain-of-thought |
| Audience-specific | Role-based |
| Consistent style needed | Few-shot |
| Strict requirements | Instruction-heavy |

### 3. Extract

Identify what matters:
- Core argument or thesis
- Key supporting points (3-5 max)
- Critical data or evidence
- Conclusions and implications

**Rule:** If you can't identify the core argument, you don't understand it yet.

### 4. Compress

Apply compression levels:
- **TLDR** — 1 sentence, core message only
- **Brief** — 2-3 sentences, message + key support
- **Standard** — paragraph, covers main points
- **Extended** — multiple paragraphs, preserves nuance

### 5. Format

Match output to purpose (see `formats.md`):
- Bullet points for scanning
- Paragraph for reading
- Structured sections for reports
- Tweet-length for social

### 6. Verify

Before delivering, check:
- [ ] Core message preserved?
- [ ] Key points included?
- [ ] Nothing critical dropped?
- [ ] Appropriate for audience?
- [ ] Right length for purpose?

## Output Markers

```
📝 SUMMARY ([level]: [word count])
[Content]

💡 KEY POINTS
• [Point 1]
• [Point 2]

⚠️ OMITTED (if relevant)
[What was cut and why]
```

## Decline When

Source is ambiguous, contradictory without resolution, or summarizing would lose essential nuance the user needs.

---

*References: `techniques.md`, `formats.md`*
